/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.SimpleFilter;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.IAdvancedFilterEntry;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Node;

public class FilterFactory {
    private static final ALogger log = ALogger.getLogger(FilterFactory.class);

    public static IPersistantFilter initFilterFromConfig(IConfigurationProvider iConfigurationProvider) throws IOException {
        String string;
        IPersistantFilter iPersistantFilter = null;
        String string2 = string = iConfigurationProvider.exists("filter_type") ? iConfigurationProvider.getString("filter_type") : "";
        if (iConfigurationProvider.exists("advancedFilterXML") || "A".equals(string)) {
            iPersistantFilter = new AdvancedFilter();
        }
        if (iPersistantFilter == null) {
            iPersistantFilter = new SimpleFilter();
        }
        iPersistantFilter.init(iConfigurationProvider);
        return iPersistantFilter;
    }

    public static IPersistantFilter createFilter(Node node) throws Exception {
        if ("advancedFilter".equals(node.getNodeName())) {
            AdvancedFilter advancedFilter = new AdvancedFilter();
            advancedFilter.initXML(node);
            return advancedFilter;
        }
        if ("simpleFilter".equals(node.getNodeName())) {
            SimpleFilter simpleFilter = new SimpleFilter();
            simpleFilter.initXML(node);
            return simpleFilter;
        }
        throw new Exception("Unable to create filter from XML-Document: Document doesn't contain any filter defintion!");
    }

    public static IPersistantFilter createDefaultFilter() {
        return new AdvancedFilter();
    }

    public static AdvancedFilter convertToAdvanced(SimpleFilter simpleFilter) {
        Vector<IAdvancedFilterEntry> vector = new Vector<IAdvancedFilterEntry>();
        for (ISimpleFilterEntry object2 : simpleFilter.getEntries()) {
            vector.add(new AdvancedFilterEntry(object2));
        }
        AdvancedFilter advancedFilter = new AdvancedFilter(vector);
        advancedFilter.setMinLevel(simpleFilter.getMinLevel());
        if (simpleFilter.getModifiers() != null) {
            advancedFilter.getModifiers().clear();
            for (Object object3 : simpleFilter.getModifiers().getModifierValues()) {
                advancedFilter.getModifiers().putModifierValue((FilterModifiers.IFilterModifier)object3.getKey(), object3.getValue());
            }
        }
        return advancedFilter;
    }
}

