/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IFilterEntry;
import com.agfa.pacs.listtext.lta.filter.IFilterEntryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public abstract class AbstractFilterEntryType
implements IFilterEntryType {
    public abstract Object convertToDicom(String[] var1, FilterModifiers var2);

    @Override
    public boolean supportsORMatch() {
        return false;
    }

    @Override
    public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
        int n = iFilterEntry.getCriterion().getTag();
        int[] nArray = DicomUtils.getFullTagPath((int)n);
        if (nArray != null) {
            Object object = this.convertToDicom(iFilterEntry.getSearchStrings(), filterModifiers);
            if (object instanceof String && object.equals("*")) {
                return;
            }
            this.updateDataset(attributes, nArray, object, filterModifiers);
        } else if (n == 4390932) {
            attributes.setString("dcm4che/archive", 4390932, VR.SH, iFilterEntry.getSearchStrings());
        } else {
            Object object = this.convertToDicom(iFilterEntry.getSearchStrings(), filterModifiers);
            if (n != 0x100010 && object instanceof String && object.equals("*")) {
                return;
            }
            this.updateDataset(attributes, n, object, filterModifiers);
        }
    }

    private void updateDataset(Attributes attributes, int n, Object object, FilterModifiers filterModifiers) {
        String[] stringArray = attributes.getStrings(n);
        if (stringArray != null && stringArray.length > 0 && this.isORMatchEnabled(filterModifiers)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            arrayList.add(object.toString());
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = arrayList.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append("\\").append((String)iterator.next());
            }
            object = stringBuilder.toString();
        }
        FilterUtilities.putValue(object, n, attributes);
    }

    private void updateDataset(Attributes attributes, int[] nArray, Object object, FilterModifiers filterModifiers) {
        String[] stringArray = DicomUtils.getStrings((int[])nArray, (Attributes)attributes);
        if (stringArray != null && stringArray.length > 0 && this.isORMatchEnabled(filterModifiers)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            arrayList.add(object.toString());
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = arrayList.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append("\\").append((String)iterator.next());
            }
            object = stringBuilder.toString();
        }
        FilterUtilities.putValue(object, nArray, attributes);
    }

    protected boolean isORMatchEnabled(FilterModifiers filterModifiers) {
        Boolean bl;
        return filterModifiers != null && (bl = (Boolean)filterModifiers.getModifierValue(FilterUtilities.OrMatchesSupported)) != null && Boolean.TRUE.equals(bl);
    }
}

