/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.exporter;

import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.util.WaitCancelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.Semaphore;

public class DicomDataRequestProgressStateNotifier
extends Thread
implements WaitCancelable {
    protected Collection<IDicomDataRequest> requests;
    protected ProgressState progressState;
    protected String description;
    protected IDicomDataRequester requester;
    private Semaphore finished = new Semaphore(0);
    private boolean running = false;

    public DicomDataRequestProgressStateNotifier(ProgressState progressState, Collection<IDicomDataRequest> collection, IDicomDataRequester iDicomDataRequester, String string) {
        this.requests = new Vector<IDicomDataRequest>();
        if (collection != null) {
            this.requests.addAll(collection);
        }
        this.progressState = progressState;
        this.description = string;
        this.requester = iDicomDataRequester;
        this.setDaemon(true);
        this.setName("DownloadRequester");
        this.setPriority(1);
    }

    @Override
    public void run() {
        this.progressState.setState(JobState.STARTED);
        this.progressState.setProgressTitle(this.description);
        if (this.progress(true)) {
            this.progressState.setState(JobState.FINISHED);
            this.progressState.setStateMessage("Finished");
        }
    }

    protected boolean progress(boolean bl) {
        this.running = true;
        int n = this.requests.size();
        int n2 = 0;
        ArrayList<IDicomDataRequest> arrayList = new ArrayList<IDicomDataRequest>();
        while (true) {
            for (IDicomDataRequest iDicomDataRequest : this.requests) {
                if (this.requester != null && this.progressState.isCanceled()) {
                    this.requester.cancelRequest(iDicomDataRequest);
                    if (!arrayList.contains(iDicomDataRequest)) {
                        arrayList.add(iDicomDataRequest);
                    }
                }
                if (iDicomDataRequest.isFinished()) {
                    ++n2;
                    if (!arrayList.contains(iDicomDataRequest)) {
                        arrayList.add(iDicomDataRequest);
                    }
                }
                if (!iDicomDataRequest.hasError()) continue;
                this.progressState.setStateMessage(iDicomDataRequest.getErrorMessage());
                this.progressState.setState(JobState.FAILED);
                if (arrayList.contains(iDicomDataRequest)) break;
                arrayList.add(iDicomDataRequest);
                break;
            }
            for (IDicomDataRequest iDicomDataRequest : arrayList) {
                this.requests.remove(iDicomDataRequest);
            }
            arrayList.clear();
            if (!bl) {
                this.requests = null;
                return false;
            }
            if (this.progressState.isCanceled() || this.progressState.getProgressState() == JobState.FAILED) break;
            this.progressState.setState(JobState.PROGRESSING);
            this.progressState.setProgress((float)n2 / (float)n);
            if (n2 >= n) break;
            try {
                DicomDataRequestProgressStateNotifier.sleep(750L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.running = false;
        this.finished.release(1000);
        return true;
    }

    public void cancel() {
        if (!this.progressState.isCanceled()) {
            this.progressState.setState(JobState.CANCELLED);
        }
        this.finished.release(1000);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void waitUntilFinished() {
        this.finished.acquireUninterruptibly();
        this.finished.release();
    }

    public synchronized void waitUntilFinished(int n) {
        this.finished.acquireUninterruptibly();
        this.finished.release();
    }

    public void setCanBeCanceled(boolean bl) {
        this.progressState.setCancelable(bl);
    }
}

