/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.async;

import com.agfa.pacs.base.util.ProcessorUtilities;
import com.agfa.pacs.listtext.async.AsyncTaskData;
import com.agfa.pacs.listtext.async.AsyncWorker;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncWorkerPool {
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private WeakHashMap<AsyncWorker, Semaphore> workerLocks = new WeakHashMap();
    private ThreadPoolExecutor pool;

    public static final AsyncWorkerPool getInstance() {
        return FieldHolder.field;
    }

    public AsyncWorkerPool() {
        int n = ProcessorUtilities.getNumberOfParallelThreads2Run();
        this.pool = new ThreadPoolExecutor(n, n, 30L, TimeUnit.SECONDS, this.queue, new AsyncThreadFactory());
        this.pool.allowCoreThreadTimeOut(true);
    }

    public Executor getTaskExecutor() {
        return this.pool;
    }

    public void placeTask(Runnable runnable) {
        this.pool.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void placeTaskToWorker(AsyncWorker asyncWorker, AsyncTaskData asyncTaskData) {
        Semaphore semaphore = null;
        AsyncWorkerPool asyncWorkerPool = this;
        synchronized (asyncWorkerPool) {
            semaphore = this.workerLocks.get(asyncWorker);
            if (semaphore == null) {
                semaphore = new Semaphore(1);
                this.workerLocks.put(asyncWorker, semaphore);
            }
        }
        this.pool.execute(new DedicatedTask(asyncWorker, semaphore, asyncTaskData));
    }

    private static final class AsyncThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger counter = new AtomicInteger(1);

        private AsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "AsyncWorker-" + counter.incrementAndGet());
            thread.setPriority(1);
            return thread;
        }
    }

    private static class DedicatedTask
    implements Runnable {
        public final AsyncWorker worker;
        public final Semaphore lock;
        public final AsyncTaskData taskData;

        public DedicatedTask(AsyncWorker asyncWorker, Semaphore semaphore, AsyncTaskData asyncTaskData) {
            this.worker = asyncWorker;
            this.lock = semaphore;
            this.taskData = asyncTaskData;
        }

        @Override
        public void run() {
            this.lock.acquireUninterruptibly();
            try {
                this.worker.performBackgroundAction(this.taskData);
            }
            finally {
                this.lock.release();
            }
        }
    }

    private static class FieldHolder {
        static final AsyncWorkerPool field = new AsyncWorkerPool();

        private FieldHolder() {
        }
    }
}

