/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class CombinedEventDelta {
    private final boolean addition;
    private IObjectManager objectManager;
    private static final int arrayGrowthSpace = 5;
    private Map extensionsByID = null;
    private Map extPointsByID = null;
    private ArrayList allExtensions = null;
    private ArrayList allExtensionPoints = null;

    private CombinedEventDelta(boolean bl) {
        this.addition = bl;
    }

    public static CombinedEventDelta recordAddition() {
        return new CombinedEventDelta(true);
    }

    public static CombinedEventDelta recordRemoval() {
        return new CombinedEventDelta(false);
    }

    public boolean isAddition() {
        return this.addition;
    }

    public boolean isRemoval() {
        return !this.addition;
    }

    public void setObjectManager(IObjectManager iObjectManager) {
        this.objectManager = iObjectManager;
    }

    public IObjectManager getObjectManager() {
        return this.objectManager;
    }

    private List getExtensionsBucket(String string) {
        ArrayList arrayList;
        if (this.extensionsByID == null) {
            this.extensionsByID = new HashMap();
        }
        if ((arrayList = (ArrayList)this.extensionsByID.get(string)) == null) {
            arrayList = new ArrayList(5);
            this.extensionsByID.put(string, arrayList);
        }
        return arrayList;
    }

    private List getExtPointsBucket(String string) {
        ArrayList arrayList;
        if (this.extPointsByID == null) {
            this.extPointsByID = new HashMap();
        }
        if ((arrayList = (ArrayList)this.extPointsByID.get(string)) == null) {
            arrayList = new ArrayList(5);
            this.extPointsByID.put(string, arrayList);
        }
        return arrayList;
    }

    private List getExtPointsGlobal() {
        if (this.allExtensionPoints == null) {
            this.allExtensionPoints = new ArrayList();
        }
        return this.allExtensionPoints;
    }

    private List getExtensionsGlobal() {
        if (this.allExtensions == null) {
            this.allExtensions = new ArrayList();
        }
        return this.allExtensions;
    }

    public void rememberExtensionPoint(ExtensionPoint extensionPoint) {
        String string = extensionPoint.getUniqueIdentifier();
        Integer n = new Integer(extensionPoint.getObjectId());
        this.getExtPointsBucket(string).add(n);
        this.getExtPointsGlobal().add(n);
    }

    public void rememberExtension(ExtensionPoint extensionPoint, int n) {
        String string = extensionPoint.getUniqueIdentifier();
        Integer n2 = new Integer(n);
        this.getExtensionsBucket(string).add(n2);
        this.getExtensionsGlobal().add(n2);
    }

    public void rememberExtensions(ExtensionPoint extensionPoint, int[] nArray) {
        if (nArray == null) {
            return;
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            this.rememberExtension(extensionPoint, nArray[n]);
            ++n;
        }
    }

    public IExtensionPoint[] getExtensionPoints(String string) {
        List list = null;
        if (string != null && this.extPointsByID != null) {
            list = (List)this.extPointsByID.get(string);
        } else if (string == null) {
            list = this.allExtensionPoints;
        }
        if (list == null) {
            return null;
        }
        int n = list.size();
        ArrayList<ExtensionPointHandle> arrayList = new ArrayList<ExtensionPointHandle>(n);
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = (Integer)list.get(n2);
            ExtensionPointHandle extensionPointHandle = new ExtensionPointHandle(this.objectManager, n3);
            arrayList.add(extensionPointHandle);
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new IExtensionPoint[arrayList.size()]);
    }

    public IExtension[] getExtensions(String string) {
        List list = null;
        if (string != null && this.extensionsByID != null) {
            list = (List)this.extensionsByID.get(string);
        } else if (string == null) {
            list = this.allExtensions;
        }
        if (list == null) {
            return null;
        }
        int n = list.size();
        ArrayList<ExtensionHandle> arrayList = new ArrayList<ExtensionHandle>(n);
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = (Integer)list.get(n2);
            ExtensionHandle extensionHandle = new ExtensionHandle(this.objectManager, n3);
            arrayList.add(extensionHandle);
            ++n2;
        }
        return arrayList.toArray(new IExtension[arrayList.size()]);
    }
}

