/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.math;

import javax.vecmath.Point2d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector2d;

public class Matrix2d {
    public static final Matrix2d identity = new Matrix2d(1.0, 0.0, 0.0, 1.0);
    public static final Matrix2d trafoFlipH = new Matrix2d(1.0, 0.0, 0.0, -1.0);
    public static final Matrix2d trafoFlipV = new Matrix2d(-1.0, 0.0, 0.0, 1.0);
    public static final Matrix2d trafoRotL = new Matrix2d(0.0, 1.0, -1.0, 0.0);
    public static final Matrix2d trafoRotR = new Matrix2d(0.0, -1.0, 1.0, 0.0);
    public static final Matrix2d trafoRot180 = new Matrix2d(-1.0, 0.0, 0.0, -1.0);
    public static final Matrix2d trafoUnity = new Matrix2d(1.0, 0.0, 0.0, 1.0);
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2d() {
        this.setIdentity();
    }

    public Matrix2d(double d, double d2, double d3, double d4) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
    }

    public Matrix2d(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m10 = dArray[2];
        this.m11 = dArray[3];
    }

    public Matrix2d(Matrix2d matrix2d) {
        this.m00 = matrix2d.m00;
        this.m01 = matrix2d.m01;
        this.m10 = matrix2d.m10;
        this.m11 = matrix2d.m11;
    }

    public void add(double d) {
        this.m00 += d;
        this.m01 += d;
        this.m10 += d;
        this.m11 += d;
    }

    public void add(double d, Matrix2d matrix2d) {
        this.m00 = matrix2d.m00 + d;
        this.m01 = matrix2d.m01 + d;
        this.m10 = matrix2d.m10 + d;
        this.m11 = matrix2d.m11 + d;
    }

    public void add(Matrix2d matrix2d) {
        this.m00 += matrix2d.m00;
        this.m01 += matrix2d.m01;
        this.m10 += matrix2d.m10;
        this.m11 += matrix2d.m11;
    }

    public void add(Matrix2d matrix2d, Matrix2d matrix2d2) {
        this.m00 = matrix2d.m00 + matrix2d2.m00;
        this.m01 = matrix2d.m01 + matrix2d2.m01;
        this.m10 = matrix2d.m10 + matrix2d2.m10;
        this.m11 = matrix2d.m11 + matrix2d2.m11;
    }

    public double determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public boolean epsilonEquals(Matrix2d matrix2d, double d) {
        return Math.abs(this.m00 - matrix2d.m00) <= d && Math.abs(this.m01 - matrix2d.m01) <= d && Math.abs(this.m10 - matrix2d.m10) <= d && Math.abs(this.m11 - matrix2d.m11) <= d;
    }

    public boolean equals(Matrix2d matrix2d) {
        try {
            return this.m00 == matrix2d.m00 && this.m01 == matrix2d.m01 && this.m10 == matrix2d.m10 && this.m11 == matrix2d.m11;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public double getElement(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.m00;
            }
            return this.m01;
        }
        if (n2 == 0) {
            return this.m10;
        }
        return this.m11;
    }

    public void invert() {
        double d = this.determinant();
        if (d == 0.0) {
            throw new SingularMatrixException();
        }
        double d2 = this.m11 / d;
        double d3 = -this.m01 / d;
        double d4 = -this.m10 / d;
        double d5 = this.m00 / d;
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = d4;
        this.m11 = d5;
    }

    public void invert(Matrix2d matrix2d) {
        this.set(matrix2d);
        this.invert();
    }

    public void mul(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m10 *= d;
        this.m11 *= d;
    }

    public void mul(double d, Matrix2d matrix2d) {
        this.set(matrix2d);
        this.mul(d);
    }

    public void mul(Matrix2d matrix2d) {
        this.set(this.m00 * matrix2d.m00 + this.m01 * matrix2d.m10, this.m00 * matrix2d.m01 + this.m01 * matrix2d.m11, this.m10 * matrix2d.m00 + this.m11 * matrix2d.m10, this.m10 * matrix2d.m01 + this.m11 * matrix2d.m11);
    }

    public void mul(Matrix2d matrix2d, Matrix2d matrix2d2) {
        this.set(matrix2d.m00 * matrix2d2.m00 + matrix2d.m01 * matrix2d2.m10, matrix2d.m00 * matrix2d2.m01 + matrix2d.m01 * matrix2d2.m11, matrix2d.m10 * matrix2d2.m00 + matrix2d.m11 * matrix2d2.m10, matrix2d.m10 * matrix2d2.m01 + matrix2d.m11 * matrix2d2.m11);
    }

    public void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
    }

    public void negate(Matrix2d matrix2d) {
        this.set(matrix2d);
        this.negate();
    }

    public void set(Matrix2d matrix2d) {
        this.m00 = matrix2d.m00;
        this.m01 = matrix2d.m01;
        this.m10 = matrix2d.m10;
        this.m11 = matrix2d.m11;
    }

    public void set(double d, double d2, double d3, double d4) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
    }

    public void set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m10 = dArray[2];
        this.m11 = dArray[3];
    }

    public void set(double d) {
        this.m00 = this.m11 = d;
        this.m10 = 0.0;
        this.m01 = 0.0;
    }

    public void setIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m11 == 1.0 && this.m10 == 0.0 && this.m01 == 0.0;
    }

    public void setZero() {
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
    }

    public void sub(Matrix2d matrix2d) {
        this.m00 -= matrix2d.m00;
        this.m01 -= matrix2d.m01;
        this.m10 -= matrix2d.m10;
        this.m11 -= matrix2d.m11;
    }

    public void sub(Matrix2d matrix2d, Matrix2d matrix2d2) {
        this.set(matrix2d);
        this.sub(matrix2d2);
    }

    public void transpose() {
        double d = this.m10;
        this.m10 = this.m01;
        this.m01 = d;
    }

    public void transpose(Matrix2d matrix2d) {
        this.set(matrix2d);
        this.transpose();
    }

    public void transform(double[] dArray) {
        double d = this.m00 * dArray[0] + this.m01 * dArray[1];
        double d2 = this.m10 * dArray[0] + this.m11 * dArray[1];
        dArray[0] = d;
        dArray[1] = d2;
    }

    public void transform(Point2d point2d) {
        double d = this.m00 * point2d.x + this.m01 * point2d.y;
        double d2 = this.m10 * point2d.x + this.m11 * point2d.y;
        point2d.x = d;
        point2d.y = d2;
    }

    public void transform(Vector2d vector2d) {
        double d = this.m00 * vector2d.x + this.m01 * vector2d.y;
        double d2 = this.m10 * vector2d.x + this.m11 * vector2d.y;
        vector2d.x = d;
        vector2d.y = d2;
    }

    public String toString() {
        return String.valueOf(this.m00) + "/" + this.m01 + " " + this.m10 + "/" + this.m11;
    }

    public boolean swappedCoordinates() {
        return this.m10 != 0.0 || this.m01 != 0.0;
    }
}

