/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.twod;

import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class PolarPoint2d
implements Comparable<PolarPoint2d> {
    public Point2d cartesian;
    public double angle;
    public double radius;

    public PolarPoint2d(Point2d point2d, Point2d point2d2) {
        this.cartesian = point2d;
        Vector2d vector2d = new Vector2d((Tuple2d)point2d);
        vector2d.sub((Tuple2d)point2d2);
        this.radius = vector2d.length();
        this.angle = Math.atan2(vector2d.y, vector2d.x) * 180.0 / Math.PI;
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
    }

    public String toString() {
        return String.format("(x=%.2f,y=%.2f)-(r=%.2f,t=%.2f)", this.cartesian.x, this.cartesian.y, this.radius, this.angle);
    }

    @Override
    public int compareTo(PolarPoint2d polarPoint2d) {
        if (this.angle < polarPoint2d.angle) {
            return -1;
        }
        if (this.angle > polarPoint2d.angle) {
            return 1;
        }
        return 0;
    }
}

