/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.geometry.api.threed.IShape3d;
import com.agfa.hap.geometry.impl.threed.Line;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class Shape3d
implements IShape3d {
    protected List<Vector4d> orientation = null;
    private Transform3D volumeToShape = null;
    private Transform3D shapeToVolume = null;
    protected Point3d center = null;
    protected Vector3d scale = null;

    public Shape3d(Point3d point3d, List<Vector4d> list, Vector3d vector3d) {
        if (point3d == null) {
            throw new IllegalArgumentException("center is NULL.");
        }
        if (list == null) {
            throw new IllegalArgumentException("orientation is NULL.");
        }
        if (list.size() != 3) {
            throw new IllegalArgumentException("orientation size is " + list.size() + " instead of 3.");
        }
        if (vector3d == null) {
            throw new IllegalArgumentException("scale is NULL.");
        }
        this.center = point3d;
        this.orientation = list;
        this.scale = vector3d;
        this.volumeToShape = null;
        this.calculateTransforms(point3d, list, vector3d);
    }

    @Override
    public Point3d getCenter() {
        return this.center;
    }

    protected abstract List<Point3d> intersect(Point3d var1, Vector3d var2, ILine var3);

    @Override
    public List<Point3d> intersect(ILine iLine) {
        if (iLine == null) {
            throw new IllegalArgumentException("line is NULL.");
        }
        iLine = this.transformLine(iLine);
        List<Point3d> list = this.intersect(iLine.getPoint0(), iLine.getDirection(), iLine);
        return this.transformPoints(list);
    }

    private Line transformLine(ILine iLine) {
        Point3d point3d = iLine.getPoint0();
        Vector4d vector4d = new Vector4d(point3d.x, point3d.y, point3d.z, 1.0);
        Vector3d vector3d = iLine.getDirection();
        Vector4d vector4d2 = new Vector4d(vector3d.x, vector3d.y, vector3d.z, 0.0);
        this.volumeToShape.transform(vector4d);
        this.volumeToShape.transform(vector4d2);
        return new Line(new Point3d(vector4d.x, vector4d.y, vector4d.z), new Vector3d(vector4d2.x, vector4d2.y, vector4d2.z));
    }

    private List<Point3d> transformPoints(List<Point3d> list) {
        for (Point3d point3d : list) {
            Vector4d vector4d = new Vector4d(point3d.x, point3d.y, point3d.z, 1.0);
            this.shapeToVolume.transform(vector4d);
            point3d.x = vector4d.x;
            point3d.y = vector4d.y;
            point3d.z = vector4d.z;
        }
        return list;
    }

    private void calculateTransforms(Point3d point3d, List<Vector4d> list, Vector3d vector3d) {
        this.shapeToVolume = new Transform3D();
        double[] dArray = new double[]{vector3d.x, 0.0, 0.0, 0.0, 0.0, vector3d.y, 0.0, 0.0, 0.0, 0.0, vector3d.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D transform3D = new Transform3D(dArray);
        this.shapeToVolume.mul(transform3D, this.shapeToVolume);
        Vector4d vector4d = list.get(0);
        Vector4d vector4d2 = list.get(1);
        Vector4d vector4d3 = list.get(2);
        vector4d.normalize();
        vector4d2.normalize();
        vector4d3.normalize();
        double[] dArray2 = new double[]{vector4d.x, vector4d2.x, vector4d3.x, 0.0, vector4d.y, vector4d2.y, vector4d3.y, 0.0, vector4d.z, vector4d2.z, vector4d3.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D transform3D2 = new Transform3D(dArray2);
        this.shapeToVolume.mul(transform3D2, this.shapeToVolume);
        double[] dArray3 = new double[]{1.0, 0.0, 0.0, point3d.x, 0.0, 1.0, 0.0, point3d.y, 0.0, 0.0, 1.0, point3d.z, 0.0, 0.0, 0.0, 1.0};
        Transform3D transform3D3 = new Transform3D(dArray3);
        this.shapeToVolume.mul(transform3D3, this.shapeToVolume);
        this.volumeToShape = new Transform3D(this.shapeToVolume);
        this.volumeToShape.invert();
    }
}

