/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.impl.threed.CrossCurveSectionHelper;
import com.agfa.hap.geometry.impl.threed.SectionPlane;
import javax.media.j3d.Transform3D;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class PolyLine {
    public float[] xPoint;
    public float[] yPoint;
    public float[] zPoint;
    protected int bufferSize;
    protected int validItems;
    int addValue;
    protected final int SMOOTHING_DISTANCE = 10;
    private boolean zScaled = true;

    public PolyLine() {
        this(5);
    }

    public PolyLine(int n) {
        this(n, 5);
    }

    public PolyLine(int n, int n2) {
        this.bufferSize = n;
        this.validItems = 0;
        this.addValue = n2;
        this.xPoint = new float[this.bufferSize];
        this.yPoint = new float[this.bufferSize];
        this.zPoint = new float[this.bufferSize];
    }

    public PolyLine(PolyLine polyLine) {
        this.bufferSize = polyLine.bufferSize;
        this.validItems = polyLine.validItems;
        this.addValue = polyLine.addValue;
        this.xPoint = new float[this.bufferSize];
        this.yPoint = new float[this.bufferSize];
        this.zPoint = new float[this.bufferSize];
        int n = 0;
        while (n < this.validItems) {
            this.xPoint[n] = polyLine.xPoint[n];
            this.yPoint[n] = polyLine.yPoint[n];
            this.zPoint[n] = polyLine.zPoint[n];
            ++n;
        }
    }

    public void cleanUp() {
        this.xPoint = null;
        this.yPoint = null;
        this.zPoint = null;
    }

    public void add(float f, float f2, float f3) {
        if (this.validItems == this.bufferSize) {
            this.grow();
        }
        this.xPoint[this.validItems] = f;
        this.yPoint[this.validItems] = f2;
        this.zPoint[this.validItems] = f3;
        ++this.validItems;
    }

    public void clear() {
        this.validItems = 0;
    }

    public void swappXYZ() {
        int n = this.validItems / 2;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.validItems - n2 - 1;
            float f = this.xPoint[n2];
            this.xPoint[n2] = this.xPoint[n3];
            this.xPoint[n3] = f;
            f = this.yPoint[n2];
            this.yPoint[n2] = this.yPoint[n3];
            this.yPoint[n3] = f;
            f = this.zPoint[n2];
            this.zPoint[n2] = this.zPoint[n3];
            this.zPoint[n3] = f;
            ++n2;
        }
    }

    public float[] getXPoints() {
        return this.xPoint;
    }

    public float[] getYPoints() {
        return this.yPoint;
    }

    public float[] getZPoints() {
        return this.zPoint;
    }

    public int getCount() {
        return this.validItems;
    }

    public void setCount(int n) {
        if (n <= this.bufferSize) {
            this.validItems = n;
        }
    }

    protected void grow() {
        this.bufferSize += this.addValue;
        if (this.bufferSize <= this.validItems) {
            new Exception("Invalid state : validItems will be out of bufferSize").printStackTrace();
        }
        float[] fArray = new float[this.bufferSize];
        float[] fArray2 = new float[this.bufferSize];
        float[] fArray3 = new float[this.bufferSize];
        int n = 0;
        while (n < this.validItems) {
            fArray[n] = this.xPoint[n];
            fArray2[n] = this.yPoint[n];
            fArray3[n] = this.zPoint[n];
            ++n;
        }
        this.xPoint = fArray;
        this.yPoint = fArray2;
        this.zPoint = fArray3;
    }

    public void setZScaled(boolean bl) {
        this.zScaled = bl;
    }

    public boolean isZscaled() {
        return this.zScaled;
    }

    public SectionPlane getNormalPlane(int n, double d, Transform3D transform3D) {
        if (n < 0 || n >= this.validItems) {
            return null;
        }
        Vector4d vector4d = new Vector4d();
        Vector4d vector4d2 = new Vector4d();
        Vector4d vector4d3 = new Vector4d();
        vector4d3.x = this.xPoint[n];
        vector4d3.y = this.yPoint[n];
        vector4d3.z = (double)this.zPoint[n] * d;
        vector4d3.w = 1.0;
        Vector4d vector4d4 = new Vector4d(0.0, 0.0, 0.0, 0.0);
        if (n >= 10) {
            vector4d4.x = this.xPoint[n - 10];
            vector4d4.y = this.yPoint[n - 10];
            vector4d4.z = (double)this.zPoint[n - 10] * d;
        } else {
            vector4d4.x = this.xPoint[0];
            vector4d4.y = this.yPoint[0];
            vector4d4.z = (double)this.zPoint[0] * d;
        }
        if (n < this.validItems - 10 - 1) {
            vector4d4.x -= (double)this.xPoint[n + 10];
            vector4d4.y -= (double)this.yPoint[n + 10];
            vector4d4.z -= (double)this.zPoint[n + 10] * d;
        } else {
            vector4d4.x -= (double)this.xPoint[this.validItems - 1];
            vector4d4.y -= (double)this.yPoint[this.validItems - 1];
            vector4d4.z -= (double)this.zPoint[this.validItems - 1] * d;
        }
        if (Math.abs(vector4d4.z) < 1.0E-5) {
            vector4d4.z = 1.0E-5;
        }
        vector4d4.normalize();
        Vector3d vector3d = new Vector3d(vector4d2.x, vector4d2.y, vector4d2.z);
        Vector3d vector3d2 = new Vector3d(vector4d.x, vector4d.y, vector4d.z);
        Vector3d vector3d3 = new Vector3d(vector4d4.x, vector4d4.y, vector4d4.z);
        CrossCurveSectionHelper.computeLeftAndUpVec(vector3d3, transform3D, vector3d2, vector3d);
        vector4d.set((Tuple3d)vector3d2);
        vector4d2.set((Tuple3d)vector3d);
        return new SectionPlane(vector4d3, vector4d, vector4d2);
    }
}

