/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.api.factories;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.geometry.api.threed.IPolygon;
import com.agfa.hap.geometry.api.threed.IShape3d;
import com.agfa.hap.geometry.impl.threed.Cuboid;
import com.agfa.hap.geometry.impl.threed.Ellipsoid;
import com.agfa.hap.geometry.impl.threed.Line;
import com.agfa.hap.geometry.impl.threed.Polygon;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class GeometryFactory3d {
    private static final GeometryFactory3d INSTANCE = new GeometryFactory3d();

    public static GeometryFactory3d getInstance() {
        return INSTANCE;
    }

    private GeometryFactory3d() {
    }

    public IShape3d createEllipsoid(Point3d point3d, List<Vector4d> list, Vector3d vector3d) {
        return new Ellipsoid(point3d, list, vector3d);
    }

    public IShape3d createCuboid(Point3d point3d, Vector3d vector3d, List<Vector4d> list) {
        return new Cuboid(point3d, vector3d, list);
    }

    public IPolygon createPolygon(List<Point3d> list) {
        return new Polygon(list);
    }

    public ILine createLine(Point3d point3d, Point3d point3d2) {
        return new Line(point3d, point3d2);
    }

    public ILine createLine(Point3d point3d, Point3d point3d2, boolean bl) {
        return new Line(point3d, point3d2, bl);
    }

    public ILine createLine(Point3d point3d, Vector3d vector3d) {
        return new Line(point3d, vector3d);
    }
}

