/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.util.referencedobject.IObjectReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThumbnailFrame
implements IObjectReference {
    private IObjectInfo object;
    private Integer frameNumber;

    public ThumbnailFrame(IObjectInfo iObjectInfo, Integer n) {
        this.object = iObjectInfo;
        this.frameNumber = n;
    }

    public IObjectInfo getObject() {
        return this.object;
    }

    public Integer getFrameNumber() {
        return this.frameNumber;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.object.getSOPInstanceUID());
        if (this.frameNumber != null) {
            stringBuilder.append('_');
            stringBuilder.append(this.frameNumber);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static Map<String, BitSet> getFrameSelection(List<ThumbnailFrame> list) {
        HashMap<String, BitSet> hashMap = new HashMap<String, BitSet>();
        for (ThumbnailFrame thumbnailFrame : list) {
            if (thumbnailFrame.getFrameNumber() == null) continue;
            BitSet bitSet = (BitSet)hashMap.get(thumbnailFrame.getObject().getSOPInstanceUID());
            if (bitSet == null) {
                bitSet = new BitSet();
                hashMap.put(thumbnailFrame.getObject().getSOPInstanceUID(), bitSet);
            }
            bitSet.set(thumbnailFrame.getFrameNumber());
        }
        return hashMap;
    }

    public boolean equals(Object object) {
        if (object instanceof ThumbnailFrame) {
            ThumbnailFrame thumbnailFrame = (ThumbnailFrame)object;
            return this.object == thumbnailFrame.getObject() && this.frameNumber == thumbnailFrame.getFrameNumber();
        }
        return super.equals(object);
    }
}

