/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;

class SearchableKeywordListModel
extends AbstractListModel {
    private Map<String, IKeyword> totalSet = new TreeMap<String, IKeyword>();
    private List<IKeyword> qualifiedSet = new ArrayList<IKeyword>();
    private String qualifier = null;

    public SearchableKeywordListModel(Collection<? extends IKeyword> collection) {
        if (collection != null) {
            this.qualifiedSet.addAll(collection);
            for (IKeyword iKeyword : collection) {
                this.totalSet.put(iKeyword.toString().toLowerCase(), iKeyword);
            }
        }
    }

    @Override
    public int getSize() {
        return this.qualifiedSet.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.qualifiedSet.get(n);
    }

    public void reset() {
        if (this.qualifier != null) {
            this.qualifier = null;
            this.qualifiedSet.clear();
            this.qualifiedSet.addAll(this.totalSet.values());
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public void qualify(String string) {
        if (string == null) {
            this.reset();
        } else if (!string.equals(this.qualifier)) {
            string = string.replaceAll("\\*", ".*");
            this.qualifier = string = string.replaceAll("\\?", ".");
            this.qualifiedSet.clear();
            String string2 = ".*" + string.toLowerCase() + ".*";
            for (Map.Entry<String, IKeyword> entry : this.totalSet.entrySet()) {
                if (!entry.getKey().matches(string2)) continue;
                this.qualifiedSet.add(entry.getValue());
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

