/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.retriever;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.StreamUtils;

public class CDDiskPixelDataInfo
implements IPixelDataInfo {
    private static final ALogger log = ALogger.getLogger(CDDiskPixelDataInfo.class);
    private String transferSyntaxUID;
    private Attributes description;
    private boolean swapEndian;
    private URL url;
    private long position;
    private CacheID cacheID;
    private long length;

    public CDDiskPixelDataInfo(URL uRL, long l, long l2, Attributes attributes, boolean bl) {
        this.url = uRL;
        this.position = l;
        this.length = l2;
        this.description = attributes;
        this.transferSyntaxUID = attributes.getString(131088);
        this.swapEndian = bl;
    }

    public byte[] readFromDisk() {
        InputStream inputStream = null;
        try {
            inputStream = this.url.openStream();
            StreamUtils.skipFully((InputStream)inputStream, (long)this.position);
            byte[] byArray = DataCacheProviderFactory.getCache().allocBytes(this.length);
            int n = inputStream.read(byArray);
            if (n != byArray.length) {
                log.warn("Not enough pixel data");
            }
            inputStream.close();
            if (this.swapEndian) {
                InputStreamDicomDataReader.swapByteArray((byte[])byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
            }
            log.error("Could not read from disk", (Throwable)iOException);
            return null;
        }
    }

    public void setCacheID(CacheID cacheID) {
        this.cacheID = cacheID;
    }

    public CacheID getCacheID() {
        return this.cacheID;
    }

    public Object getData() {
        return null;
    }

    public Class<?> getDataClass() {
        return null;
    }

    public Attributes getDescription() {
        return this.description;
    }

    public IInstanceInfo getInstanceInfo() {
        return null;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public boolean isDataInCacheMemory() {
        return true;
    }

    public boolean isLossless() {
        return true;
    }
}

