/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.transfercapability;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.dcm4che3.net.TransferCapability;

public abstract class TransferCapabilityFactory {
    private static TransferCapabilityFactory implementation;

    public static synchronized TransferCapabilityFactory getInstance() {
        if (implementation == null) {
            TransferCapabilityFactory.initialize();
        }
        return implementation;
    }

    public List<TransferCapability> getTransferCapabilities(boolean bl, boolean bl2) {
        ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
        List<ITransferCapabilityProvider> list = implementation.getITransferCapabilityProviderInt();
        for (ITransferCapabilityProvider iTransferCapabilityProvider : list) {
            List<TransferCapability> list2 = iTransferCapabilityProvider.getTransferCapabilities();
            if (bl && bl2) {
                if (list2 == null) continue;
                for (TransferCapability transferCapability : list2) {
                    arrayList.add(this.clone(transferCapability));
                }
                continue;
            }
            for (TransferCapability transferCapability : list2) {
                if (transferCapability.getRole() == TransferCapability.Role.SCP != bl2 || transferCapability.getRole() == TransferCapability.Role.SCU != bl) continue;
                arrayList.add(this.clone(transferCapability));
            }
        }
        return arrayList;
    }

    private TransferCapability clone(TransferCapability transferCapability) {
        TransferCapability transferCapability2 = new TransferCapability(transferCapability.getCommonName(), transferCapability.getSopClass(), transferCapability.getRole(), transferCapability.getTransferSyntaxes());
        if (transferCapability.getQueryOptions() != null) {
            transferCapability2.setQueryOptions((EnumSet)transferCapability.getQueryOptions().clone());
        }
        transferCapability2.setStorageOptions(transferCapability.getStorageOptions());
        return transferCapability2;
    }

    protected abstract List<ITransferCapabilityProvider> getITransferCapabilityProviderInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)TransferCapabilityFactory.class.getName()));
            implementation = (TransferCapabilityFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + TransferCapabilityFactory.class.getName(), reflectiveOperationException);
        }
    }
}

