/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.device;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.dicom.device.IDicomService;
import java.util.List;

public abstract class DicomServiceFactory {
    private static DicomServiceFactory implementation;

    public static synchronized DicomServiceFactory getInstance() {
        if (implementation == null) {
            DicomServiceFactory.initialize();
        }
        return implementation;
    }

    public List<IDicomService> getDicomServiceProvider() {
        return implementation.getDicomServiceProviderInt();
    }

    protected abstract List<IDicomService> getDicomServiceProviderInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DicomServiceFactory.class.getName()));
            implementation = (DicomServiceFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DicomServiceFactory.class.getName(), reflectiveOperationException);
        }
    }
}

