/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICFindSCU;
import com.agfa.pacs.data.dicom.comm.DicomSCU;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.util.TagUtils;

public class DicomCFindSCU
extends DicomSCU
implements ICFindSCU {
    private static final ALogger log = ALogger.getLogger(DicomCFindSCU.class);
    private DimseRSP response;
    protected Set<String> qrTSUID;
    protected String qrSOPClass;

    public DicomCFindSCU(IDicomNode iDicomNode, UIDMap uIDMap, boolean bl) {
        super(iDicomNode, bl);
        this.addTransferCapabilities(uIDMap);
    }

    @Override
    public synchronized List<Attributes> cFind(Attributes attributes) throws DicomException {
        if (this.qrSOPClass == null) {
            throw new DicomException("No SOP Class");
        }
        try {
            String string = this.qrTSUID.iterator().next();
            this.response = this.association.cfind(this.qrSOPClass, 1, attributes, string, -1);
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
            boolean bl = true;
            while (this.response.next()) {
                Attributes attributes2 = this.response.getCommand();
                this.handleStatus(attributes2, bl);
                bl = false;
                if (!this.isPending(attributes2)) continue;
                Attributes attributes3 = this.response.getDataset();
                arrayList.add(attributes3);
            }
            return arrayList;
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    public synchronized void cancel() throws Exception {
        this.response.cancel(this.association);
    }

    @Override
    protected void handleStatus(Attributes attributes, boolean bl) throws DicomException {
        super.handleStatus(attributes, bl);
        int n = attributes.getInt(2304, 0);
        switch (n) {
            case 65280: {
                if (!log.isDebugEnabled()) break;
                log.debug("Status: " + Integer.toHexString(n));
                log.debug("PENDING: Successfully received data for the current request.");
                break;
            }
            case 65281: {
                if (!bl) break;
                log.warn("Status: " + Integer.toHexString(n));
                log.warn("PENDING: One or more optional keys were not supported for existence and/or matching for the Identifer.");
                this.showTags(attributes.getInts(2305));
                break;
            }
            case 0: {
                if (!log.isDebugEnabled()) break;
                log.debug("Status: " + Integer.toHexString(n));
                log.debug("SUCCESS: Finished receiving data for the current request.");
                break;
            }
            case 42752: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Refused: Out of Resources.");
                log.error(attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Refused: Out of Resources.");
            }
            case 43264: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Identifier does not match SOP Class.");
                log.error(attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Identifier does not match SOP Class.");
            }
            case 65024: {
                log.info("Status: " + Integer.toHexString(n));
                log.info("CANCEL: Request was cancelled.");
                break;
            }
            default: {
                log.error("Status: " + Integer.toHexString(n));
                if ((n & 0xC000) != 49152) break;
                log.error("FAILURE: Unable to process.");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                throw new DicomException(n, "FAILURE: Unable to process.");
            }
        }
    }

    private void showTags(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Tag: ");
            stringBuilder.append(TagUtils.toString((int)n3));
            stringBuilder.append(" ");
            stringBuilder.append(ElementDictionary.keywordOf((int)n3, null));
            log.error(stringBuilder.toString());
            ++n2;
        }
    }
}

