/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.equinox.launcher.Main;

public class CDMain
extends Main {
    private static final String PROP_WEBSTART_AUTOMATIC_INSTALLATION = "eclipse.webstart.automaticInstallation";
    private static final String DEFAULT_OSGI_BUNDLES = "org.eclipse.equinox.common@2:start, org.eclipse.core.runtime@start";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private Map allBundles = null;
    private List bundleList = null;

    public static void main(String[] stringArray) {
        System.setSecurityManager(null);
        int n = new CDMain().run(stringArray);
        if (!Boolean.getBoolean("osgi.noShutdown")) {
            System.exit(n);
        }
    }

    private void setDefaultBundles() {
        if (System.getProperty(PROP_OSGI_BUNDLES) != null) {
            return;
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, DEFAULT_OSGI_BUNDLES);
    }

    @Override
    protected void basicRun(String[] stringArray) throws Exception {
        this.setDefaultBundles();
        this.initializeBundleListStructure();
        this.discoverBundles();
        this.allBundles.remove("OSGI");
        super.basicRun(stringArray);
    }

    @Override
    protected void beforeFwkInvocation() {
        if (System.getProperty(PROP_CHECK_CONFIG) == null) {
            System.getProperties().put(PROP_CHECK_CONFIG, "true");
        }
        this.buildOSGiBundleList();
        this.cleanup();
    }

    private void cleanup() {
        this.allBundles = null;
        this.bundleList = null;
    }

    @Override
    protected String searchFor(String string, String string2) {
        String[] stringArray = this.getArrayFromList(System.getProperties().getProperty("osgi.framework.extensions.path"));
        if (stringArray != null && stringArray.length > 0 && Arrays.asList(stringArray).contains(string)) {
            return super.searchFor(string, string2);
        }
        ArrayList arrayList = (ArrayList)this.allBundles.get(string);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 1) {
            return ((BundleInfo)arrayList.get((int)0)).location;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = (String)arrayList.get(n3);
            n2 = this.findMax(stringArray2);
            ++n3;
        }
        return ((BundleInfo)arrayList.get((int)n2)).location;
    }

    private BundleInfo findBundle(String string, String string2, boolean bl) {
        ArrayList arrayList = (ArrayList)this.allBundles.get(string.toUpperCase(Locale.ENGLISH));
        int n = arrayList.size();
        if (n == 1) {
            return (BundleInfo)arrayList.remove(0);
        }
        if (n == 0) {
            return null;
        }
        if (string2 != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                BundleInfo bundleInfo = (BundleInfo)iterator.next();
                if (!bundleInfo.version.equals(string2)) continue;
                iterator.remove();
                return bundleInfo;
            }
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = (String)arrayList.get(n3);
            n2 = this.findMax(stringArray);
            ++n3;
        }
        return (BundleInfo)arrayList.remove(n2);
    }

    private void discoverBundles() {
        this.allBundles = new HashMap();
        File file = new File(System.getProperty("osgi.framework")).getParentFile();
        File[] fileArray = file.listFiles(new JarFilter());
        int n = 0;
        while (n < fileArray.length) {
            BundleInfo bundleInfo = this.getBundleInfo(fileArray[n]);
            if (bundleInfo != null) {
                ArrayList<BundleInfo> arrayList = (ArrayList<BundleInfo>)this.allBundles.get(bundleInfo.bsn);
                if (arrayList == null) {
                    arrayList = new ArrayList<BundleInfo>(1);
                    this.allBundles.put(bundleInfo.bsn, arrayList);
                }
                arrayList.add(bundleInfo);
            }
            ++n;
        }
    }

    private void initializeBundleListStructure() {
        String string = System.getProperty(PROP_OSGI_BUNDLES);
        if (string == null || string.trim().equals("")) {
            this.bundleList = new ArrayList(0);
            return;
        }
        this.bundleList = new ArrayList(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.bsn = string3;
            int n = string2.lastIndexOf(64);
            if (n != -1) {
                bundleInfo.bsn = string2.substring(0, n);
                bundleInfo.startData = string2.substring(n);
            }
            this.bundleList.add(bundleInfo);
        }
    }

    private BundleInfo getBundleInfo(File file) {
        try {
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.version = "1.0.0";
            bundleInfo.location = file.toURL().toString();
            bundleInfo.bsn = file.getName().substring(0, file.getName().length() - 4).toUpperCase(Locale.ENGLISH);
            return bundleInfo;
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private void buildOSGiBundleList() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(this.allBundles.size() * 30);
        for (Object object2 : this.bundleList) {
            object = this.findBundle(((BundleInfo)object2).bsn, ((BundleInfo)object2).version, true);
            stringBuffer.append("reference:").append(((BundleInfo)object).location).append(((BundleInfo)object2).startData).append(',');
        }
        if (!Boolean.FALSE.toString().equalsIgnoreCase(System.getProperties().getProperty(PROP_WEBSTART_AUTOMATIC_INSTALLATION))) {
            for (Object object2 : this.allBundles.values()) {
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    BundleInfo bundleInfo = (BundleInfo)object.next();
                    stringBuffer.append("reference:").append(bundleInfo.location).append(',');
                }
            }
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, stringBuffer.toString());
    }

    private class BundleInfo {
        String bsn;
        String version;
        String startData;
        String location;

        private BundleInfo() {
        }
    }

    private class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toUpperCase(Locale.ENGLISH).endsWith(".JAR");
        }
    }
}

