/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.lang.reflect.Method;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class CompatibilityHelper {
    private static final String OPTION_DEBUG_COMPATIBILITY = "org.eclipse.core.runtime/compatibility/debug";
    public static final boolean DEBUG = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption("org.eclipse.core.runtime/compatibility/debug"));
    public static final String PI_RUNTIME_COMPATIBILITY = "org.eclipse.core.runtime.compatibility";
    private static Bundle compatibility = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static synchronized void nullCompatibility() {
        compatibility = null;
    }

    public static synchronized Bundle initializeCompatibility() {
        if (compatibility == null || (compatibility.getState() & 0x13) != 0) {
            compatibility = InternalPlatform.getDefault().getBundle(PI_RUNTIME_COMPATIBILITY);
        }
        return compatibility;
    }

    public static void setPlugin(IPluginDescriptor iPluginDescriptor, Plugin plugin) {
        if (CompatibilityHelper.initializeCompatibility() == null) {
            throw new IllegalStateException();
        }
        try {
            Class<?> clazz = iPluginDescriptor.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.Plugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("setPlugin", classArray);
            method.invoke((Object)iPluginDescriptor, plugin);
        }
        catch (Exception exception) {}
    }

    public static synchronized IPluginDescriptor getPluginDescriptor(String string) {
        CompatibilityHelper.initializeCompatibility();
        if (compatibility == null) {
            throw new IllegalStateException();
        }
        Class clazz = null;
        try {
            clazz = compatibility.loadClass("org.eclipse.core.internal.plugins.InternalPlatform");
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("getPluginDescriptor", classArray);
            return (IPluginDescriptor)method.invoke((Object)clazz, string);
        }
        catch (Exception exception) {
            if (DEBUG) {
                String string2 = "Error running compatibility code";
                Status status = new Status(4, "org.eclipse.core.runtime", 1, string2, (Throwable)exception);
                InternalPlatform.getDefault().log((IStatus)status);
            }
            return null;
        }
    }

    public static synchronized void setActive(IPluginDescriptor iPluginDescriptor) {
        CompatibilityHelper.initializeCompatibility();
        if (compatibility == null) {
            throw new IllegalStateException();
        }
        try {
            Method method = iPluginDescriptor.getClass().getMethod("setActive", null);
            method.invoke((Object)iPluginDescriptor, null);
        }
        catch (Exception exception) {}
    }

    public static synchronized boolean hasPluginObject(IPluginDescriptor iPluginDescriptor) {
        CompatibilityHelper.initializeCompatibility();
        if (compatibility == null) {
            throw new IllegalStateException();
        }
        Boolean bl = Boolean.FALSE;
        try {
            Method method = iPluginDescriptor.getClass().getMethod("hasPluginObject", null);
            bl = (Boolean)method.invoke((Object)iPluginDescriptor, null);
        }
        catch (Exception exception) {}
        return bl;
    }
}

