/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.undo;

import com.agfa.pacs.event.internal.task.Task;
import com.agfa.pacs.event.internal.task.TaskCache;
import com.agfa.pacs.event.internal.task.TaskGroup;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class UndoRedoContainer {
    protected LinkedList<TaskGroup> undoStack;
    protected int limit;
    protected ListIterator<TaskGroup> undoPos = null;
    protected TaskCache taskCache;

    public UndoRedoContainer(int n) {
        this.limit = n;
        this.undoStack = new LinkedList();
        this.taskCache = TaskCache.instance();
    }

    public void putTask(TaskGroup taskGroup) {
        if (this.undoPos != null) {
            while (this.undoPos.hasNext()) {
                this.taskCache.putDelayedTaskGroup(this.undoPos.next());
                this.undoPos.remove();
            }
            this.undoPos = null;
        }
        this.undoStack.addLast(taskGroup);
        if (this.undoStack.size() > this.limit) {
            this.taskCache.putDelayedTaskGroup(this.undoStack.removeFirst());
        }
    }

    public TaskGroup undo() {
        if (this.undoPos == null) {
            this.undoPos = this.undoStack.listIterator(this.undoStack.size());
        }
        return this.undoPos.previous();
    }

    public boolean canUndo() {
        if (this.undoPos == null) {
            return this.undoStack.size() > 0;
        }
        return this.undoPos.hasPrevious();
    }

    public TaskGroup redo() {
        if (this.undoPos == null) {
            throw new NoSuchElementException();
        }
        return this.undoPos.next();
    }

    public boolean canRedo() {
        if (this.undoPos == null) {
            return false;
        }
        return this.undoPos.hasNext();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void removeAll() {
        while (!this.undoStack.isEmpty()) {
            this.taskCache.putTaskGroup(this.undoStack.removeFirst());
        }
    }

    public String toString() {
        ListIterator listIterator = this.undoStack.listIterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UndoRedoContainer\n");
        int n = 0;
        while (listIterator.hasNext()) {
            stringBuffer.append(" - (" + n++ + ") " + listIterator.next());
        }
        if (this.undoPos != null) {
            stringBuffer.append("pos = < " + this.undoPos.previousIndex() + "|" + this.undoPos.nextIndex() + "> " + this.undoPos.toString() + "\n");
        }
        TaskGroup[] taskGroupArray = this.undoStack.toArray(new TaskGroup[0]);
        if (this.undoPos != null) {
            TaskGroup taskGroup = this.undoPos.previousIndex() - 2 >= 0 ? taskGroupArray[this.undoPos.previousIndex() - 2] : null;
            TaskGroup taskGroup2 = this.undoPos.previousIndex() - 1 >= 0 ? taskGroupArray[this.undoPos.previousIndex() - 1] : null;
            TaskGroup taskGroup3 = taskGroupArray[this.undoPos.previousIndex()];
            TaskGroup taskGroup4 = taskGroupArray[this.undoPos.nextIndex()];
            if (taskGroup != null) {
                stringBuffer.append("ppprevious:\n");
                for (Task task : taskGroup) {
                    stringBuffer.append(" " + task + "\n");
                }
            }
            if (taskGroup2 != null) {
                stringBuffer.append("pprevious:\n");
                for (Task task : taskGroup2) {
                    stringBuffer.append(" " + task + "\n");
                }
            }
            if (taskGroup3 != null) {
                stringBuffer.append("previous:\n");
                for (Task task : taskGroup3) {
                    stringBuffer.append(" " + task + "\n");
                }
            }
            if (taskGroup4 != null) {
                stringBuffer.append("next:\n");
                for (Task task : taskGroup4) {
                    stringBuffer.append(" " + task + "\n");
                }
            }
        }
        return stringBuffer.toString();
    }
}

