/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.tools;

import com.agfa.pacs.logging.ALogger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EventEngineSemaphore {
    private static final ALogger LOGGER = ALogger.getLogger(EventEngineSemaphore.class);
    private final int maxCount;
    private int curCount;
    private AtomicInteger waitingThreads = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public EventEngineSemaphore() {
        this.maxCount = 1;
        this.curCount = 1;
    }

    public EventEngineSemaphore(int n) {
        this.maxCount = n;
        this.curCount = n;
    }

    public EventEngineSemaphore(int n, int n2) {
        this.maxCount = n;
        this.curCount = n2;
    }

    public boolean P() {
        this.lock.lock();
        try {
            this.waitingThreads.incrementAndGet();
            boolean bl = false;
            while (this.curCount <= 0) {
                try {
                    bl = true;
                    this.condition.await();
                }
                catch (Exception exception) {
                    LOGGER.error("Exception in Semaphore: " + exception);
                }
            }
            this.waitingThreads.decrementAndGet();
            --this.curCount;
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean P(int n) {
        this.lock.lock();
        try {
            this.waitingThreads.incrementAndGet();
            boolean bl = true;
            while (this.curCount <= 0 && bl) {
                try {
                    bl = this.condition.await(n, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    LOGGER.error("Exception in Semaphore: " + exception);
                }
            }
            this.waitingThreads.decrementAndGet();
            if (bl) {
                --this.curCount;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean P_uninterruptly() {
        this.lock.lock();
        try {
            this.waitingThreads.incrementAndGet();
            boolean bl = false;
            boolean bl2 = false;
            while (this.curCount <= 0) {
                try {
                    bl = true;
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            this.waitingThreads.decrementAndGet();
            --this.curCount;
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean P_nonBlocking() {
        this.lock.lock();
        try {
            if (this.curCount <= 0) {
                return false;
            }
            --this.curCount;
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int addP_nonBlocking(int n) {
        this.lock.lock();
        try {
            this.curCount -= n;
            int n2 = this.curCount;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int V() {
        this.lock.lock();
        try {
            ++this.curCount;
            if (this.waitingThreads.get() > 0) {
                this.condition.signal();
            }
            int n = this.curCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int V(int n) {
        this.lock.lock();
        try {
            this.curCount += n;
            if (this.waitingThreads.get() > 0) {
                if (n > 1) {
                    this.condition.signalAll();
                } else {
                    this.condition.signal();
                }
            }
            int n2 = this.curCount;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getCurrCount() {
        this.lock.lock();
        try {
            int n = this.curCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public boolean isBlocking() {
        return this.curCount <= 0;
    }
}

