/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.task;

import com.agfa.pacs.cache.IMemoryAlertListener;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.task.Task;
import com.agfa.pacs.event.internal.task.TaskGroup;

public class TaskCache
implements IMemoryAlertListener {
    protected static final TaskCache singelton = new TaskCache();
    protected Task head;
    protected Task tail;
    protected TaskGroup tgHead;
    protected TaskGroup tgTail;
    protected TaskGroup tgHead_offline;
    protected TaskGroup tgTail_offline;
    protected Object tailSync = new Object();
    protected long dbgGiven = 0L;
    protected long dbgReturned = 0L;
    protected long dbgReturned_delayed = 0L;

    public static TaskCache instance() {
        return singelton;
    }

    private TaskCache() {
        this.head = new Task(null, null);
        this.head.clearForDeletion = true;
        this.tail = new Task(null, null);
        this.tail.clearForDeletion = true;
        this.head.next = this.tail;
        this.tgHead = this.tgTail = new TaskGroup();
        this.tgHead_offline = this.tgTail_offline = new TaskGroup();
        MemoryAlertHandler.addMemoryAlertListener((IMemoryAlertListener)this);
    }

    public Task getTask() {
        return this.getTask(null, null);
    }

    public synchronized Task getTask(Event event, IEventListener iEventListener) {
        ++this.dbgGiven;
        if (this.head.next == this.tail) {
            this.retrieveDelayedTasks();
        }
        if (this.head.next == this.tail) {
            return new Task(event, iEventListener);
        }
        if (!this.head.clearForDeletion) {
            return new Task(event, iEventListener);
        }
        Task task = this.head;
        this.head = this.head.next;
        task.e = event;
        task.l = iEventListener;
        task.u.disposed();
        task.next = null;
        task.clearForDeletion = false;
        task.followUp = null;
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTask(Task task) {
        ++this.dbgReturned;
        task.next = null;
        task.e = null;
        task.l = null;
        task.u.disposed();
        task.clearForDeletion = true;
        Object object = this.tailSync;
        synchronized (object) {
            this.tail.next = task;
            this.tail = task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTaskGroup(TaskGroup taskGroup) {
        this.dbgReturned += (long)(taskGroup.count + 1);
        Object object = this.tailSync;
        synchronized (object) {
            this.tail.next = taskGroup.head;
            this.tail = taskGroup.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDelayedTaskGroup(TaskGroup taskGroup) {
        TaskGroup taskGroup2 = this.tgHead;
        synchronized (taskGroup2) {
            this.tgTail.next = taskGroup;
            this.tgTail = taskGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveDelayedTasks() {
        if (this.tgHead_offline == this.tgTail_offline && this.tgHead != this.tgTail) {
            TaskGroup taskGroup = this.tgHead;
            synchronized (taskGroup) {
                this.tgHead_offline.next = this.tgHead.next;
                this.tgTail_offline = this.tgTail;
                this.tgHead.next = null;
                this.tgTail = this.tgHead;
            }
        }
        this.cleanUpOffline();
    }

    protected void cleanUpOffline() {
        block0: while (this.tgHead_offline != null) {
            Task task = this.tgHead_offline.head;
            while (task != null) {
                Object object;
                if (task.clearForDeletion) {
                    ++this.dbgReturned_delayed;
                    task.l = null;
                    task.e = null;
                    task.u.disposed();
                    object = task;
                    task = task.next;
                    ((Task)object).next = this.head;
                    this.head = object;
                    continue;
                }
                this.tgHead_offline.head = task;
                object = this.tgHead_offline;
                if (this.tgHead_offline == this.tgHead_offline.next) {
                    ((TaskGroup)object).next = null;
                    this.tgHead_offline = null;
                } else {
                    this.tgHead_offline = this.tgHead_offline.next;
                }
                this.putDelayedTaskGroup((TaskGroup)object);
                continue block0;
            }
            this.tgHead_offline.event = null;
            this.tgHead_offline.head = null;
            this.tgHead_offline.tail = null;
            this.tgHead_offline = this.tgHead_offline == this.tgHead_offline.next ? null : this.tgHead_offline.next;
        }
        this.tgTail_offline = this.tgHead_offline = new TaskGroup();
    }

    public long getCounter() {
        return this.dbgGiven - this.dbgReturned - this.dbgReturned_delayed;
    }

    public synchronized long memoryAlert(long l, boolean bl) {
        this.retrieveDelayedTasks();
        this.retrieveDelayedTasks();
        int n = 0;
        while (this.head.next != this.tail) {
            this.head = this.head.next;
            ++n;
        }
        return n * 16;
    }
}

