/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.debug.format;

import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.debug.format.AbstractFormatter;
import com.agfa.pacs.event.internal.debug.format.IFormatter;

public class EventFormatter
extends AbstractFormatter<Event> {
    private static final String NON_STRING_PAYLOAD = "<not string payload>";
    private static final String NO_PAYLOAD = "<no payload>";

    @Override
    public String format(Event event, IFormatter.FORMAT_MODE fORMAT_MODE) {
        if (event == null) {
            return "Event(UNKNOWN)";
        }
        String string = EventEngineFactory.getInstance().getEventName(event.getEventID());
        if (IFormatter.FORMAT_MODE.COMPLETE.equals((Object)fORMAT_MODE)) {
            return String.format("Event(uid: %s, id: %s, eventName: %s, transfer: %s, action: %s, internal: %s, payload: %s)", event.getUID(), event.getEventID(), string, event.transfer, event.action, event.isInternal(), EventFormatter.getFormattedPayload(event));
        }
        return String.format("Event(uid: %s, id: %s, eventName: %s)", event.getUID(), event.getEventID(), string);
    }

    private static String getFormattedPayload(Event event) {
        String string = NO_PAYLOAD;
        Object object = event.getPayload();
        if (object != null) {
            string = object instanceof String ? (String)object : NON_STRING_PAYLOAD;
        }
        return string;
    }
}

