/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal;

import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventDispatcher;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.undo.UndoRedoEngine;
import com.agfa.pacs.logging.ALogger;

public class InternalEventListener
implements IEventListener {
    private static final ALogger LOGGER = ALogger.getLogger(InternalEventListener.class);
    protected UndoRedoEngine undoRedo;
    protected IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();

    public InternalEventListener(IEventDispatcher iEventDispatcher) {
        this.undoRedo = iEventDispatcher.getUndoRedoEngine();
    }

    public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        switch (iEvent.getEventID()) {
            case 0: {
                if (((Event)iEvent).transfer != Transfer.BLOCKING) {
                    LOGGER.info("undo events should be sent blocking");
                }
                this.undoRedo.undo();
                break;
            }
            case 1: {
                if (((Event)iEvent).transfer != Transfer.BLOCKING) {
                    LOGGER.info("redo events should be sent blocking");
                }
                this.undoRedo.redo();
            }
        }
        return false;
    }

    public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        return false;
    }

    public IListenerSynchronization getSync() {
        return this.sync;
    }
}

