/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal;

import com.agfa.pacs.event.AsyncEventHookContainer;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.SyncEventHookContainer;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class EventDictionary {
    private static final ALogger logger = ALogger.getLogger(EventDictionary.class);
    private static EventDictionary dict = new EventDictionary();
    protected Hashtable<String, Integer> eventTypes = new Hashtable();
    protected Hashtable<Integer, String> eventNames = new Hashtable();

    public static EventDictionary getInstance() {
        return dict;
    }

    protected EventDictionary() {
        try {
            Field[] fieldArray = IEvent.class.getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n].getName().startsWith("EVENTID")) {
                    this.eventTypes.put(fieldArray[n].getName(), fieldArray[n].getInt(null));
                    this.eventNames.put(fieldArray[n].getInt(null), fieldArray[n].getName());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            logger.warn("Error while creating EventDictionary.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getExistingEventID(String string) {
        Integer n;
        EventDictionary eventDictionary = this;
        synchronized (eventDictionary) {
            n = this.eventTypes.get(string);
        }
        if (n == null) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEventID(String string, SyncEventHookContainer syncEventHookContainer, AsyncEventHookContainer asyncEventHookContainer) {
        int n = this.getExistingEventID(string);
        if (n < 0) {
            EventDictionary eventDictionary = this;
            synchronized (eventDictionary) {
                n = this.eventTypes.size() + 500;
                this.eventTypes.put(string, n);
            }
            this.eventNames.put(n, string);
            if (syncEventHookContainer != null) {
                syncEventHookContainer.registerEventID(string, n);
            }
            if (asyncEventHookContainer != null) {
                asyncEventHookContainer.registerEventID(string, n);
            }
        }
        return n;
    }

    public String resolveName(int n) {
        return this.eventNames.get(n);
    }
}

