/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.AsyncEventHookContainer;
import com.agfa.pacs.event.EventDispatcherFactory;
import com.agfa.pacs.event.EventHookContainerFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventDispatcher;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.event.ListenerSynchronization;
import com.agfa.pacs.event.SyncEventHookContainer;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.EventDictionary;
import com.agfa.pacs.event.internal.InternalEventListener;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.listener.ListenerProviderInstance;
import com.agfa.pacs.event.internal.listener.ListenerProviderPlugin;
import com.agfa.pacs.event.internal.registry.EventListenerProviderRegistry;
import com.agfa.pacs.event.internal.task.TaskGroup;
import com.agfa.pacs.event.internal.tools.EventEngineSemaphore;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class EventEngine
implements IEventEngine {
    protected IEventDispatcher eDispatcher = EventDispatcherFactory.getInstance();
    public static final EventListenerProviderRegistry registry = new EventListenerProviderRegistry();
    protected SyncEventHookContainer syncHooks;
    protected AsyncEventHookContainer asyncHooks;
    protected long sendCounter = 0L;
    private Queue<Sender> postQueue;

    public void init() {
        this.register(this.createListenerProvider(new InternalEventListener(this.eDispatcher)), "EEINTERNAL");
        this.syncHooks = EventHookContainerFactory.getSynchronHooks();
        registry.setSynchronousEventHooks(this.syncHooks);
        IEventListenerProvider<IEventListener> iEventListenerProvider = this.syncHooks.getEventListenerProvider();
        if (iEventListenerProvider != null) {
            this.register(iEventListenerProvider, "EEHOOK");
        }
        this.asyncHooks = EventHookContainerFactory.getAsynchronHooks();
        registry.setAsynchronousEventHooks(this.asyncHooks);
        this.register(this.asyncHooks, "EEHOOK");
        TaskGroup.registerHooks(this.asyncHooks);
        EventHookContainerFactory.registerSingleEventListener(this);
        EventHookContainerFactory.registerSingleEventListenerProvider(this);
    }

    public IEventListenerProvider<IEventListener> createListenerProvider(Collection<? extends IEventListener> collection) {
        return new ListenerProviderInstance(collection);
    }

    public IEventListenerProvider<IEventListener> createListenerProvider(IEventListener iEventListener) {
        return new ListenerProviderInstance(iEventListener);
    }

    public IEventListenerProvider<IEventListener> createListenerProvider(String string) {
        return ListenerProviderPlugin.create(string);
    }

    public boolean register(IEventListenerProvider iEventListenerProvider, String string) {
        return registry.register((IEventListenerProvider<IEventListener>)iEventListenerProvider, string);
    }

    public boolean unregister(IEventListenerProvider<?> iEventListenerProvider) {
        return registry.unregister(iEventListenerProvider);
    }

    public boolean unregister(String string) {
        return registry.unregister(string);
    }

    public IEventListenerProvider<IEventListener> getGroup(String string, boolean bl) {
        return registry.getGroup(string, bl);
    }

    public int getEventID(String string) {
        return EventDictionary.getInstance().getEventID(string, this.syncHooks, this.asyncHooks);
    }

    public String getEventName(int n) {
        return EventDictionary.getInstance().resolveName(n);
    }

    public IEvent createEvent(int n) {
        return new Event(n, true, true);
    }

    public IEvent createInternalEvent(int n) {
        return new Event(n, false, false);
    }

    public IEvent createScriptableEvent(int n) {
        return new Event(n, false, true);
    }

    public IEvent createUndoableEvent(int n) {
        return new Event(n, true, false);
    }

    public IEvent createEvent(int n, IEventListenerProvider<? extends IEventListener> iEventListenerProvider, Object object, Serializable serializable, ActionInfo actionInfo) {
        return new Event(n, iEventListenerProvider, object, serializable, actionInfo, true, true);
    }

    public IEvent createInternalEvent(int n, IEventListenerProvider<? extends IEventListener> iEventListenerProvider, Object object, Serializable serializable, ActionInfo actionInfo) {
        return new Event(n, iEventListenerProvider, object, serializable, actionInfo, false, false);
    }

    public IEvent createScriptableEvent(int n, IEventListenerProvider<? extends IEventListener> iEventListenerProvider, Object object, Serializable serializable, ActionInfo actionInfo) {
        return new Event(n, iEventListenerProvider, object, serializable, actionInfo, false, true);
    }

    public IEvent createUndoableEvent(int n, IEventListenerProvider<? extends IEventListener> iEventListenerProvider, Object object, Serializable serializable, ActionInfo actionInfo) {
        return new Event(n, iEventListenerProvider, object, serializable, actionInfo, true, false);
    }

    public void sendEvent(IEvent iEvent) {
        if (((Event)iEvent).eDestination == null) {
            ((Event)iEvent).eDestination = registry;
        }
        this.asyncHooks.setTicket(++this.sendCounter);
        try {
            this.eDispatcher.send((Event)iEvent);
        }
        catch (RuntimeException runtimeException) {
            this.asyncHooks.setTicket(--this.sendCounter);
            throw runtimeException;
        }
        this.syncHooks.handle(iEvent);
    }

    public void sendStreamEvent(IEvent iEvent) {
        ((Event)iEvent).transfer = Transfer.STREAMED;
        this.sendEvent(iEvent);
    }

    public void sendExclusiveEvent(IEvent iEvent) {
        ((Event)iEvent).transfer = Transfer.EXCLUSIVE;
        ((Event)iEvent).syncSem = new EventEngineSemaphore(1);
        this.sendEvent(iEvent);
    }

    public void sendFlushedEvent(IEvent iEvent) {
        ((Event)iEvent).transfer = Transfer.FLUSHED;
        this.sendEvent(iEvent);
    }

    public void sendBlockingEvent(IEvent iEvent) {
        ((Event)iEvent).transfer = Transfer.BLOCKING;
        this.sendEvent(iEvent);
    }

    public void sendOrderedEvent(IEvent iEvent) {
        ((Event)iEvent).transfer = Transfer.ORDERED;
        this.sendEvent(iEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"MWN_MISMATCHED_NOTIFY"})
    public void postEvent(IEvent iEvent) {
        if (this.postQueue == null) {
            this.setupPostThread();
        }
        Queue<Sender> queue = this.postQueue;
        synchronized (queue) {
            this.postQueue.add(new Sender(iEvent));
            this.postQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPostThread() {
        EventEngine eventEngine = this;
        synchronized (eventEngine) {
            if (this.postQueue == null) {
                this.postQueue = new LinkedList<Sender>();
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        while (true) {
                            Sender sender;
                            Queue queue = EventEngine.this.postQueue;
                            synchronized (queue) {
                                while (true) {
                                    if (!EventEngine.this.postQueue.isEmpty()) {
                                        sender = (Sender)EventEngine.this.postQueue.poll();
                                        break;
                                    }
                                    try {
                                        EventEngine.this.postQueue.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            sender.run();
                        }
                    }
                }, "PostEventThread");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public EventListenerProviderRegistry getEventListenerProviderRegistry() {
        return registry;
    }

    public IEventDispatcher getDispatcher() {
        return this.eDispatcher;
    }

    public boolean executeSynchronized(Runnable runnable, IEventListener iEventListener, int n) {
        ListenerSynchronization listenerSynchronization = (ListenerSynchronization)iEventListener.getSync();
        int n2 = 0;
        if (listenerSynchronization != null) {
            n2 = listenerSynchronization.acquireReentrent(n);
        }
        if (n2 >= 0) {
            try {
                runnable.run();
                return true;
            }
            finally {
                if (listenerSynchronization != null && n2 > 0) {
                    listenerSynchronization.release();
                }
            }
        }
        return false;
    }

    public void asyncExecuteSynchronized(IEventListener iEventListener, IEventListener iEventListener2, int n, Object object) {
        IEvent iEvent = this.createInternalEvent(n);
        iEvent.setDestination((IEventListenerProvider)new ListenerSynchronizationWrapper(iEventListener, (ListenerSynchronization)iEventListener2.getSync()));
        iEvent.setPayload(object);
        this.sendEvent(iEvent);
    }

    private static class ListenerSynchronizationWrapper
    implements IEventListenerProvider<IEventListener>,
    IEventListener,
    Iterator<IEventListener> {
        private final IEventListener callback;
        private final ListenerSynchronization sync;
        private boolean consumed;

        private ListenerSynchronizationWrapper(IEventListener iEventListener, ListenerSynchronization listenerSynchronization) {
            this.callback = iEventListener;
            this.sync = listenerSynchronization;
        }

        public Iterator<IEventListener> iterator() {
            return this;
        }

        public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
            return this;
        }

        public IListenerSynchronization getSync() {
            return this.sync;
        }

        public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            return this.callback.handleEvent(iEvent, iUndoInformation);
        }

        public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            return this.callback.handleUndoEvent(iEvent, iUndoInformation);
        }

        @Override
        public boolean hasNext() {
            return !this.consumed;
        }

        @Override
        public IEventListener next() {
            if (this.consumed) {
                throw new NoSuchElementException();
            }
            this.consumed = true;
            return this;
        }

        @Override
        public void remove() {
            if (this.consumed) {
                throw new NoSuchElementException();
            }
            this.consumed = true;
        }
    }

    protected class Sender
    implements Runnable {
        protected IEvent event;

        public Sender(IEvent iEvent) {
            this.event = iEvent;
        }

        @Override
        public void run() {
            if (((Event)this.event).eDestination == null) {
                ((Event)this.event).eDestination = registry;
            }
            EventEngine.this.asyncHooks.setTicket(++EventEngine.this.sendCounter);
            try {
                EventEngine.this.eDispatcher.send((Event)this.event);
            }
            catch (RuntimeException runtimeException) {
                EventEngine.this.asyncHooks.setTicket(--EventEngine.this.sendCounter);
                throw runtimeException;
            }
            EventEngine.this.syncHooks.handle(this.event);
        }
    }
}

