/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.lw.datainfo;

import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.lw.datainfo.IDicomDatabaseAccess;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.filter.NoFilter;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.lw.QueryCancelException;
import com.agfa.pacs.data.shared.lw.impl.IntermediateDataInfo;
import com.agfa.pacs.data.shared.node.AbstractDataInfoNode;
import com.agfa.pacs.instrumentation.TUIDRegistry;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public abstract class AbstractDicomDataInfoNode
extends AbstractDataInfoNode {
    private static final ALogger LOGGER = ALogger.getLogger(AbstractDicomDataInfoNode.class);
    private static final Class[] levelClasses = new Class[]{IPatientInfo.class, IStudyInfo.class, ISeriesInfo.class, IObjectInfo.class};
    private static final boolean USE_INSTRUMENTATION = ApplicationManagement.getInstance().getApplicationType().isAgilityPlatform();
    private static final int MAXIMUM_SEARCH_ENTRY_LENGTH = 20000;
    private static IDataInfoFactory diFact = DataInfoFactoryProvider.getInstance();
    private static final String KEY_SEPARATOR = "$$";
    private IDataProviderIdentifier dataProviderIdentifier;
    protected IDicomDatabaseAccess dicomDatabaseAccess;
    private boolean cancel;

    public AbstractDicomDataInfoNode(IDataProviderIdentifier iDataProviderIdentifier, IDicomDatabaseAccess iDicomDatabaseAccess) {
        super(iDataProviderIdentifier.getName());
        this.dataProviderIdentifier = iDataProviderIdentifier;
        this.dicomDatabaseAccess = iDicomDatabaseAccess;
        this.cancel = false;
    }

    public IDataProviderIdentifier getIdentifier() {
        return this.dataProviderIdentifier;
    }

    public IDicomNode getDicomNode() {
        return (IDicomNode)this.dataProviderIdentifier;
    }

    public IRootInfo getDataInfo(IFilter iFilter) throws Exception {
        List list;
        this.cancel = false;
        IRootInfo iRootInfo = null;
        if (iFilter == null) {
            iFilter = new NoFilter();
        }
        iFilter.putModifierValue(FilterModifiers.SemanticPNMatchingNegotiated, (Object)this.dicomDatabaseAccess.isSemanticPNMatchingNegotiated());
        Level level = iFilter.getLeafLevel();
        Level level2 = iFilter.getMinLevel();
        if (this.dicomDatabaseAccess.isRelational()) {
            if (level2 == Level.Patient && level != Level.Patient && (list = iFilter.getLevel(level)).size() > 0 && !((Attributes)list.get(0)).isEmpty() && !this.dicomDatabaseAccess.isNoExtendedNegotation() && this.dicomDatabaseAccess.isUseMultivaluedUIDs()) {
                return this.optimizedWholePatientSearch(iFilter, level2, level);
            }
            if (level2 != null && level2.compareTo((Enum)level) > 0) {
                level = level2;
            }
            iRootInfo = this.getRelationalDataInfo(iFilter, levelClasses[level.getLevel()]);
        } else {
            while ((list = iFilter.getLevel(level)).size() <= 1 && ((Attributes)list.get(0)).isEmpty() && (level = Level.get((int)(level.getLevel() - 1))).compareTo((Enum)Level.Study) > 0) {
            }
            iRootInfo = this.getHierarchicalDataInfo(iFilter, iFilter.getRootLevel(), level);
        }
        DataInfoUtilities.setSource((IDataInfo)iRootInfo, (IDataInfoSource)this);
        if (level2 != null && Level.Object != level2) {
            if (level2.compareTo((Enum)level) > 0) {
                list = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, (Class)levelClasses[level2.getLevel()]);
                for (IDataInfo iDataInfo : list) {
                    if (!this.cancel) {
                        boolean bl;
                        if (!iDataInfo.hasChildren() || !(bl = iDataInfo.childrenAvailable())) continue;
                        DataInfoUtilities.getLevel((IDataInfo)iDataInfo, (Class)levelClasses[level.getLevel()]);
                        continue;
                    }
                    break;
                }
            } else if (level2.compareTo((Enum)level) < 0) {
                list = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, (Class)levelClasses[level2.getLevel()]);
                for (IDataInfo iDataInfo : list) {
                    if (!(iDataInfo instanceof IntermediateDataInfo)) continue;
                    ((IntermediateDataInfo)iDataInfo).resetChildren();
                }
            }
        }
        if (this.cancel) {
            throw new QueryCancelException();
        }
        if (level2 != null && iFilter.getLeafLevel() == Level.Series) {
            DataInfoUtilities.getLevel((IDataInfo)iRootInfo, (Class)levelClasses[iFilter.getLeafLevel().getLevel()]);
        }
        return iRootInfo;
    }

    public List<Attributes> rawDicomSearch(Attributes attributes, String string) throws DicomException {
        return this.dicomDatabaseAccess.rawDicomSearch(attributes, string);
    }

    private Collection<IPatientInfo> createPatientsOnly(Set<String> set, Level level) throws Exception {
        List<Attributes> list = null;
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (String string : set) {
            int n = string.indexOf(KEY_SEPARATOR);
            Attributes attributes = new Attributes();
            attributes.setString(0x100020, VR.LO, string.substring(0, n));
            if (n + 2 != string.length()) {
                attributes.setString(0x100021, VR.LO, string.substring(n + 2));
            }
            arrayList.add(attributes);
        }
        list = this.dicomDatabaseAccess.getRelationalSearch(arrayList, null, level);
        return this.createDataInfos(list, level);
    }

    private Collection<IPatientInfo> createDataInfos(List<Attributes> list, Level level) {
        Map<String, IPatientInfo> map = this.dicomDatabaseAccess.createPatients(list, false);
        if (level == Level.Study) {
            this.dicomDatabaseAccess.createStudies(list, map, true);
        } else if (level == Level.Series) {
            Map<String, IStudyInfo> map2 = this.dicomDatabaseAccess.createStudies(list, map, false);
            this.dicomDatabaseAccess.createSeries(list, map2, true);
        } else {
            throw new UnsupportedOperationException("Incorect Leaf level" + level);
        }
        return map.values();
    }

    /*
     * WARNING - void declaration
     */
    private IRootInfo optimizedWholePatientSearch(IFilter iFilter, Level level, Level level2) throws Exception {
        void var13_22;
        IRootInfo iRootInfo = diFact.createRootInfo("ROOT");
        List<Attributes> list = AbstractDicomDataInfoNode.compileSearchTables(iFilter);
        List<Attributes> list2 = this.dicomDatabaseAccess.getRelationalSearch(list, null, level2);
        if (list2.isEmpty()) {
            return iRootInfo;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        HashSet<String> hashSet2 = new HashSet<String>();
        string = list2.get(0).getString(0x100021);
        if (string != null && string.length() == 0) {
            string = null;
        }
        String string2 = null;
        int n = 0;
        boolean bl = true;
        for (Attributes attributes : list2) {
            string2 = attributes.getString(0x100021);
            if (string2 != null) {
                if (string != null && string.equals(string2)) {
                    hashSet2.add(attributes.getString(0x100020));
                    ++n;
                    continue;
                }
                hashSet.add(String.valueOf(attributes.getString(0x100020)) + KEY_SEPARATOR + string2);
                bl = false;
                continue;
            }
            if (string == null) {
                hashSet2.add(attributes.getString(0x100020));
                ++n;
                continue;
            }
            hashSet.add(String.valueOf(attributes.getString(0x100020)) + KEY_SEPARATOR);
            bl = false;
        }
        if (!bl && string != null) {
            for (String string3 : hashSet2) {
                hashSet.add(String.valueOf(string3) + KEY_SEPARATOR + string);
            }
            hashSet2.clear();
        }
        LOGGER.debug("Innefective search with patients:" + hashSet.size());
        if (!hashSet.isEmpty()) {
            iRootInfo.addChildren(this.createPatientsOnly(hashSet, level2));
        }
        LOGGER.debug("Efective search with patients:" + n);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : hashSet2) {
            var13_22.append(string4).append('\\');
            if (var13_22.length() <= 20000) continue;
            var13_22.deleteCharAt(var13_22.length() - 1);
            this.searchMultiplePatientIDs(var13_22.toString(), string, iRootInfo, level2);
            StringBuilder stringBuilder2 = new StringBuilder();
        }
        if (var13_22.length() > 0) {
            var13_22.deleteCharAt(var13_22.length() - 1);
            this.searchMultiplePatientIDs(var13_22.toString(), string, iRootInfo, level2);
        }
        DataInfoUtilities.setSource((IDataInfo)iRootInfo, (IDataInfoSource)this);
        return iRootInfo;
    }

    private void searchMultiplePatientIDs(String string, String string2, IRootInfo iRootInfo, Level level) throws Exception {
        Object object;
        Attributes attributes = new Attributes();
        attributes.setString(0x100020, VR.LO, string);
        List<Attributes> list = this.dicomDatabaseAccess.getRelationalSearch(Collections.singletonList(attributes), null, level);
        Iterator<Attributes> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string3 = object.getString(0x100021);
            boolean bl = false;
            if (string2 == null) {
                bl = string3 == null;
            } else {
                boolean bl2 = bl = string3 != null && string2.equals(string3);
            }
            if (bl) continue;
            iterator.remove();
        }
        object = this.createDataInfos(list, level);
        iRootInfo.addChildren((Collection)object);
    }

    public void cancelQuery() {
        this.cancel = true;
        this.dicomDatabaseAccess.cancel();
    }

    public abstract List<FilterTag> getResultTags();

    public abstract List<FilterTag> getSearchTags();

    public IDataInfoRetriever getRetriever() {
        return this.dicomDatabaseAccess;
    }

    public boolean supportORQueries() {
        return true;
    }

    private IRootInfo getHierarchicalDataInfo(IFilter iFilter, Level level, Level level2) throws Exception {
        if (this.cancel) {
            throw new QueryCancelException();
        }
        IRootInfo iRootInfo = diFact.createRootInfo("ROOT");
        List<IDataInfo> list = this.dicomDatabaseAccess.getHierarchicalDataInfo(iFilter, level, level2);
        List list2 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        if (this.studyDefaults != null) {
            for (IPatientInfo iPatientInfo : list2) {
                this.applyStudyDefaults(iPatientInfo.getStudies());
            }
        }
        iRootInfo.addChildren((Collection)list2);
        DataInfoUtilities.removeStumps((IDataInfo)iRootInfo, (Class)levelClasses[level2.getLevel()]);
        return iRootInfo;
    }

    private IRootInfo getRelationalDataInfo(IFilter iFilter, Class<? extends IDataInfo> clazz) throws Exception {
        if (this.cancel) {
            throw new QueryCancelException();
        }
        IRootInfo iRootInfo = diFact.createRootInfo("ROOT");
        List<IDataInfo> list = this.getRelationalDataInfo(clazz, iFilter);
        List list2 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        if (this.studyDefaults != null) {
            for (IPatientInfo iPatientInfo : list2) {
                this.applyStudyDefaults(iPatientInfo.getStudies());
            }
        }
        iRootInfo.addChildren((Collection)list2);
        return iRootInfo;
    }

    private static List<Attributes> compileSearchTables(IFilter iFilter) {
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        List list = iFilter.getLevel(Level.Patient);
        List list2 = iFilter.getLevel(Level.Study);
        List list3 = iFilter.getLevel(Level.Series);
        List list4 = iFilter.getLevel(Level.Object);
        for (Attributes attributes : list) {
            for (Attributes attributes2 : list2) {
                for (Attributes attributes3 : list3) {
                    for (Attributes attributes4 : list4) {
                        Attributes attributes5 = new Attributes();
                        attributes5.addAll(attributes4);
                        attributes5.addAll(attributes3);
                        attributes5.addAll(attributes2);
                        attributes5.addAll(attributes);
                        arrayList.add(attributes5);
                    }
                }
            }
        }
        return arrayList;
    }

    private List<IDataInfo> getRelationalDataInfo(Class<? extends IDataInfo> clazz, IFilter iFilter) throws Exception {
        List<Attributes> list = AbstractDicomDataInfoNode.compileSearchTables(iFilter);
        if (USE_INSTRUMENTATION) {
            TUIDRegistry.transferTUID((Object)iFilter, list);
        }
        if (this.cancel) {
            throw new QueryCancelException();
        }
        if (IPatientInfo.class.equals(clazz)) {
            return this.dicomDatabaseAccess.getRelationalPatientInfo(list, null);
        }
        if (IStudyInfo.class.equals(clazz)) {
            return this.dicomDatabaseAccess.getRelationalStudyInfo(list, null);
        }
        if (ISeriesInfo.class.equals(clazz)) {
            return this.dicomDatabaseAccess.getRelationalSeriesInfo(list, null);
        }
        if (IObjectInfo.class.equals(clazz)) {
            return this.dicomDatabaseAccess.getRelationalObjectInfo(list, null);
        }
        return null;
    }
}

