/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.util.message;

import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.impaxee.Messages;
import com.tiani.util.message.IMessageHandler;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;

public class Message {
    public static final int OK = 0;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private static final String DEFAULT_INFORMATION_TITLE = Messages.getString("Information");
    private static final String DEFAULT_WARNING_TITLE = Messages.getString("Warning");
    private static final String DEFAULT_QUESTION_TITLE = Messages.getString("Question");
    private static final String DEFAULT_ERROR_TITLE = Messages.getString("Error");
    private static Stack<IMessageHandler> messageHandlers = new Stack();

    public static void pushMessageHandler(IMessageHandler iMessageHandler) {
        messageHandlers.push(iMessageHandler);
    }

    private static IMessageHandler peekMessageHandler() {
        return messageHandlers.peek();
    }

    public static void info(Object object) {
        Message.peekMessageHandler().info(DEFAULT_INFORMATION_TITLE, object, null);
    }

    public static void info(String string, Object object) {
        Message.peekMessageHandler().info(string, object, null);
    }

    public static void error(Object object) {
        Message.peekMessageHandler().error(null, DEFAULT_ERROR_TITLE, object, null);
    }

    public static void error(Throwable throwable, Object object) {
        ExceptionHandlerFactory.getInstance().handleException(throwable);
        Message.peekMessageHandler().error(throwable, DEFAULT_ERROR_TITLE, object, null);
    }

    public static void error(String string, Object object) {
        Message.peekMessageHandler().error(null, string, object, null);
    }

    public static int okCancel(Object object) {
        return Message.okCancel(DEFAULT_QUESTION_TITLE, object);
    }

    public static int okCancel(String string, Object object) {
        return Message.okCancel(string, object, null);
    }

    public static int okCancel(String string, Object object, Object[] objectArray) {
        return Message.peekMessageHandler().okCancel(string, object, objectArray, false);
    }

    public static void warning(Object object) {
        Message.warning(DEFAULT_WARNING_TITLE, object);
    }

    public static void warning(String string, Object object) {
        Message.warning(string, object, null);
    }

    public static void warning(String string, Object object, Object[] objectArray) {
        Message.peekMessageHandler().warning(string, object, objectArray);
    }

    public static int yesNo(Object object) {
        return Message.yesNo(DEFAULT_QUESTION_TITLE, object);
    }

    public static int yesNo(String string, Object object) {
        return Message.yesNo(string, object, null);
    }

    public static int yesNo(String string, Object object, Object[] objectArray) {
        return Message.peekMessageHandler().yesNo(string, object, objectArray);
    }

    public static Object choose(String string, Object object, Object[] objectArray, Object ... objectArray2) {
        return Message.peekMessageHandler().choose(string, object, objectArray, objectArray2);
    }

    public static Number queryNumber(String string, Object object, Object[] objectArray, Double d, String string2, boolean bl) {
        return Message.peekMessageHandler().queryNumber(string, object, objectArray, d, string2, bl);
    }

    public static Object input(Component component, Object object, String string, Object object2) {
        return Message.peekMessageHandler().input(component, object, string, object2);
    }

    public static String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

