/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.util.expressions;

import com.agfa.pacs.impaxee.Messages;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.tiani.util.expressions.BooleanNode;
import com.tiani.util.expressions.ConditionUtil;
import com.tiani.util.expressions.impl.NumberConstantNode;
import com.tiani.util.expressions.impl.NumberEqualNode;
import com.tiani.util.expressions.impl.NumberGreaterEqualNode;
import com.tiani.util.expressions.impl.NumberGreaterNode;
import com.tiani.util.expressions.impl.NumberLessEqualNode;
import com.tiani.util.expressions.impl.NumberLessNode;
import com.tiani.util.expressions.impl.NumberNotEqualNode;
import com.tiani.util.expressions.impl.NumberPACSiNode;
import com.tiani.util.expressions.impl.StringConstantNode;
import com.tiani.util.expressions.impl.StringContainsNode;
import com.tiani.util.expressions.impl.StringDoesNotContainNode;
import com.tiani.util.expressions.impl.StringEndsWithNode;
import com.tiani.util.expressions.impl.StringEqualNode;
import com.tiani.util.expressions.impl.StringGreaterEqualNode;
import com.tiani.util.expressions.impl.StringGreaterNode;
import com.tiani.util.expressions.impl.StringHasPositionFromMaxNode;
import com.tiani.util.expressions.impl.StringHasPositionFromMinNode;
import com.tiani.util.expressions.impl.StringIncludesOneOfNode;
import com.tiani.util.expressions.impl.StringIsEnhancedNode;
import com.tiani.util.expressions.impl.StringIsMaxInNode;
import com.tiani.util.expressions.impl.StringIsMinInNode;
import com.tiani.util.expressions.impl.StringIsNoneOfNode;
import com.tiani.util.expressions.impl.StringIsOneOfNode;
import com.tiani.util.expressions.impl.StringLessEqualNode;
import com.tiani.util.expressions.impl.StringLessNode;
import com.tiani.util.expressions.impl.StringNotEqualNode;
import com.tiani.util.expressions.impl.StringPACSiNode;
import com.tiani.util.expressions.impl.StringStartsWithNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OperatorEnum {
    AND("AND", null, true, false, false, Messages.getString("OperatorEnum.AND")),
    OR("OR", null, true, false, false, Messages.getString("OperatorEnum.OR")),
    XOR("XOR", null, true, false, false, Messages.getString("OperatorEnum.XOR")),
    NOT("NOT", null, true, true, false, Messages.getString("OperatorEnum.NOT")),
    EQUAL("==", "=", false, false, false, Messages.getString("OperatorEnum.Equality")),
    NOT_EQUAL("!=", "<>", false, false, false, Messages.getString("OperatorEnum.Inequality")),
    LESS_THAN("<", null, false, false, false, Messages.getString("OperatorEnum.LessThan")),
    LESS_EQUAL("<=", null, false, false, false, Messages.getString("OperatorEnum.LessThanOrEqualTo")),
    GREATER_THAN(">", null, false, false, false, Messages.getString("OperatorEnum.GreaterThan")),
    GREATER_EQUAL(">=", null, false, false, false, Messages.getString("OperatorEnum.GreaterThanOrEqualTo")),
    CONTAINS("CONTAINS", null, false, false, false, Messages.getString("OperatorEnum.Contains")),
    DOESNOTCONTAIN("DOESNOTCONTAIN", null, false, false, false, Messages.getString("OperatorEnum.DoesNotContain")),
    ISONEOF("ISONEOF", null, false, false, false, Messages.getString("OperatorEnum.IsOneOf")),
    ISNONEOF("ISNONEOF", null, false, false, false, Messages.getString("OperatorEnum.IsNoneOf")),
    STARTSWITH("STARTSWITH", null, false, false, false, Messages.getString("OperatorEnum.StartsWith")),
    ENDSWITH("ENDSWITH", null, false, false, false, Messages.getString("OperatorEnum.EndsWith")),
    INCLUDESONEOF("INCLUDESONEOF", null, false, false, false, Messages.getString("OperatorEnum.IncludesOneOf")),
    ISMAXIN("ISMAXIN", null, false, true, true, Messages.getString("OperatorEnum.IsMaxIn")),
    ISMININ("ISMININ", null, false, true, true, Messages.getString("OperatorEnum.IsMinIn")),
    HASPOSITIONFROMMAX("HASPOSITIONFROMMAX", null, false, false, true, Messages.getString("OperatorEnum.HasPositionFromMax")),
    HASPOSITIONFROMMIN("HASPOSITIONFROMMIN", null, false, false, true, Messages.getString("OperatorEnum.HasPositionFromMin")),
    ISENHANCED("ISENHANCED", null, false, true, true, Messages.getString("OperatorEnum.ISENHANCED"));

    private String symbol;
    private String alternativeSymbol;
    private boolean logic;
    private boolean unary;
    private boolean conditionalHanging;
    private String description;
    private static Map<String, OperatorEnum> symbols;
    private static List<OperatorEnum> commonOperators;
    private static List<OperatorEnum> logicOperators;
    private static List<OperatorEnum> conditionalHangingOperators;
    private static List<OperatorEnum> unaryOperators;
    private static List<OperatorEnum> binaryOperators;

    static {
        commonOperators = new ArrayList<OperatorEnum>();
        logicOperators = new ArrayList<OperatorEnum>();
        conditionalHangingOperators = new ArrayList<OperatorEnum>();
        unaryOperators = new ArrayList<OperatorEnum>();
        binaryOperators = new ArrayList<OperatorEnum>();
        for (OperatorEnum operatorEnum : EnumSet.allOf(OperatorEnum.class)) {
            if (operatorEnum.isLogic()) {
                logicOperators.add(operatorEnum);
            } else if (operatorEnum.isConditionalHanging()) {
                conditionalHangingOperators.add(operatorEnum);
            } else {
                commonOperators.add(operatorEnum);
            }
            if (operatorEnum.isUnary()) {
                unaryOperators.add(operatorEnum);
                continue;
            }
            binaryOperators.add(operatorEnum);
        }
    }

    private OperatorEnum(String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4) {
        this.symbol = string2;
        this.alternativeSymbol = string3;
        this.logic = bl;
        this.unary = bl2;
        this.conditionalHanging = bl3;
        this.description = string4;
        OperatorEnum.getSymbols().put(string2, this);
        if (string3 != null) {
            OperatorEnum.getSymbols().put(string3, this);
        }
    }

    public static OperatorEnum parse(String string) throws ParseException {
        OperatorEnum operatorEnum = symbols.get(string);
        if (string == null) {
            throw new ParseException("Could not parse:" + string);
        }
        return operatorEnum;
    }

    public static List<OperatorEnum> getCommonOperators() {
        return commonOperators;
    }

    public static List<OperatorEnum> getLogicOperators() {
        return logicOperators;
    }

    public static List<OperatorEnum> getConditionalHangingOperators() {
        return conditionalHangingOperators;
    }

    public static List<OperatorEnum> getUnaryOperators() {
        return unaryOperators;
    }

    public static List<OperatorEnum> getBinaryOperators() {
        return binaryOperators;
    }

    public String toString() {
        return this.symbol;
    }

    public String getOperator() {
        return this.symbol;
    }

    public String getAlternativeSymbol() {
        return this.alternativeSymbol;
    }

    public boolean isLogic() {
        return this.logic;
    }

    public boolean isUnary() {
        return this.unary;
    }

    public boolean isBinary() {
        return !this.unary;
    }

    public boolean isConditionalHanging() {
        return this.conditionalHanging;
    }

    public String getDescription() {
        return this.description;
    }

    private static Map<String, OperatorEnum> getSymbols() {
        if (symbols == null) {
            symbols = new HashMap<String, OperatorEnum>();
        }
        return symbols;
    }

    public static String getValueFormatHint(Integer n, OperatorEnum operatorEnum) {
        switch (operatorEnum) {
            case ISMAXIN: 
            case ISMININ: 
            case ISENHANCED: {
                return null;
            }
            case ISONEOF: 
            case ISNONEOF: 
            case INCLUDESONEOF: {
                return Messages.getString("OperatorEnum.MultiStringValue");
            }
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                if (!ConditionUtil.requiresNumberValue(n)) break;
                return Messages.getString("OperatorEnum.NumberValue");
            }
        }
        return Messages.getString("OperatorEnum.StringValue");
    }

    public static BooleanNode createBooleanNode(Integer n, OperatorEnum operatorEnum, String string) {
        switch (operatorEnum) {
            case CONTAINS: {
                return new StringContainsNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case DOESNOTCONTAIN: {
                return new StringDoesNotContainNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case ENDSWITH: {
                return new StringEndsWithNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case EQUAL: {
                Double d;
                if (ConditionUtil.requiresNumberValue(n) && (d = OperatorEnum.parseNumber(string)) != null) {
                    return new NumberEqualNode(new NumberPACSiNode(n), new NumberConstantNode(d));
                }
                return new StringEqualNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case NOT_EQUAL: {
                Double d;
                if (ConditionUtil.requiresNumberValue(n) && (d = OperatorEnum.parseNumber(string)) != null) {
                    return new NumberNotEqualNode(new NumberPACSiNode(n), new NumberConstantNode(d));
                }
                return new StringNotEqualNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case GREATER_EQUAL: {
                Double d;
                if (ConditionUtil.requiresNumberValue(n) && (d = OperatorEnum.parseNumber(string)) != null) {
                    return new NumberGreaterEqualNode(new NumberPACSiNode(n), new NumberConstantNode(d));
                }
                return new StringGreaterEqualNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case GREATER_THAN: {
                Double d;
                if (ConditionUtil.requiresNumberValue(n) && (d = OperatorEnum.parseNumber(string)) != null) {
                    return new NumberGreaterNode(new NumberPACSiNode(n), new NumberConstantNode(d));
                }
                return new StringGreaterNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case LESS_EQUAL: {
                Double d;
                if (ConditionUtil.requiresNumberValue(n) && (d = OperatorEnum.parseNumber(string)) != null) {
                    return new NumberLessEqualNode(new NumberPACSiNode(n), new NumberConstantNode(d));
                }
                return new StringLessEqualNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case LESS_THAN: {
                Double d;
                if (ConditionUtil.requiresNumberValue(n) && (d = OperatorEnum.parseNumber(string)) != null) {
                    return new NumberLessNode(new NumberPACSiNode(n), new NumberConstantNode(d));
                }
                return new StringLessNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case STARTSWITH: {
                return new StringStartsWithNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case ISONEOF: {
                return new StringIsOneOfNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case ISNONEOF: {
                return new StringIsNoneOfNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case INCLUDESONEOF: {
                return new StringIncludesOneOfNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case HASPOSITIONFROMMAX: {
                return new StringHasPositionFromMaxNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case HASPOSITIONFROMMIN: {
                return new StringHasPositionFromMinNode(new StringPACSiNode(n), new StringConstantNode(string));
            }
            case ISMAXIN: {
                return new StringIsMaxInNode(new StringPACSiNode(n));
            }
            case ISMININ: {
                return new StringIsMinInNode(new StringPACSiNode(n));
            }
            case ISENHANCED: {
                return new StringIsEnhancedNode(new StringPACSiNode(n));
            }
        }
        return null;
    }

    private static Double parseNumber(String string) {
        try {
            return new Double(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

