/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.controls.hotregion.HotRegionImage;
import com.tiani.gui.controls.hotregion.HotRegionListenerExtension;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.keypress.gui.ActionsDlg;
import com.tiani.jvision.vis.Vis2;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class VisHRSet
implements HotRegionListenerExtension,
Iterable<HotRegion> {
    protected static final ALogger log = ALogger.getLogger(VisHRSet.class);
    public static final int B1 = 9;
    public static final int B2 = 10;
    public static final int B3 = 11;
    public static final int B4 = 12;
    public static final int B5 = 13;
    public static final int B6 = 14;
    private static String iconPath = "/icons/";
    private static final int iconHeightSmall = 32;
    private static final int iconHeightMedium = 55;
    private static final int iconHeightLarge = 64;
    private static IAIconFactory iconFactoryScaledSmall = IAIconFactory.createMonochromeIconFactory(32);
    private static IAIconFactory iconFactoryScaledMedium = IAIconFactory.createMonochromeIconFactory(55);
    protected static IAIconFactory iconFactoryScaledLarge = IAIconFactory.createMonochromeIconFactory(64);
    public static PIcon ICON_ZOOM = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_zoom.svg");
    public static PIcon ICON_PAN = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_pan.svg");
    public static PIcon ICON_RESET = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_reset.svg");
    public static PIcon ICON_DELETE_ROI = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_delete_roi.svg");
    public static PIcon ICON_SLICETHROUGH = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_slide.svg");
    public static PIcon ICON_SLICETHROUGH_SMALL = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_slide.svg");
    public static PIcon ICON_FLIP_HOR = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_flip_horizontal.svg");
    public static PIcon ICON_FLIP_VER = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_flip_vertical.svg");
    public static PIcon ICON_ROTATE_VARIABLE = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_rotate.svg");
    public static PIcon ICON_ROTATE_LEFT = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_rotate_left.svg");
    public static PIcon ICON_ROTATE_RIGHT = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_rotate_right.svg");
    public static PIcon ICON_NAVIG_BACKWARD = iconFactoryScaledMedium.loadIcon(ActionsDlg.class, "hotregion_navigate_previous.svg");
    public static PIcon ICON_NAVIG_FORWARD = iconFactoryScaledMedium.loadIcon(ActionsDlg.class, "hotregion_navigate_next.svg");
    public static PIcon ICON_TRACKBALL = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_rot_volume_normal.svg");
    public static TIcon ICON_TRACKBALL_LIGHT = new TIcon(String.valueOf(iconPath) + "hotvisualtrackballlight.gif");
    public static PIcon ICON_CUTTING_PLANE_0 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane0.svg");
    public static PIcon ICON_CUTTING_PLANE_1 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane1.svg");
    public static PIcon ICON_CUTTING_PLANE_2 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane2.svg");
    public static PIcon ICON_CUTTING_PLANE_3 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane3.svg");
    public static PIcon ICON_CUTTING_PLANE_4 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane4.svg");
    public static PIcon ICON_CUTTING_PLANE_5 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane5.svg");
    public static PIcon ICON_CUTTING_PLANE_6 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplanefront.svg");
    public static PIcon ICON_CUTTING_PLANE_7 = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplaneback.svg");
    public static PIcon ICON_CUTTING_PLANE_VIC_RIGHT = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane0.svg");
    public static PIcon ICON_CUTTING_PLANE_VIC_LEFT = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane1.svg");
    public static PIcon ICON_CUTTING_PLANE_VIC_ANTERIOR = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane3.svg");
    public static PIcon ICON_CUTTING_PLANE_VIC_POSTERIOR = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane2.svg");
    public static PIcon ICON_CUTTING_PLANE_VIC_FEET = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane5.svg");
    public static PIcon ICON_CUTTING_PLANE_VIC_HEAD = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_cutplane4.svg");
    public static PIcon ICON_CLINAPPS_INVISIBLE_START_BUTTON = iconFactoryScaledLarge.loadIcon(ActionsDlg.class, "hotregion_invisible.svg");
    public static PIcon ICON_WINDOW_LEVEL = iconFactoryScaledSmall.loadIcon(ActionsDlg.class, "hotregion_window_level.svg");
    public static PIcon ICON_SLICE_THICKNESS = iconFactoryScaledMedium.loadIcon(ActionsDlg.class, "hotregion_slice_thickness.svg");
    public static TIcon ICON_ISO_0 = new TIcon(String.valueOf(iconPath) + "hotvisualiso0.gif");
    public static TIcon ICON_ISO_1 = new TIcon(String.valueOf(iconPath) + "hotvisualiso1.gif");
    public static TIcon ICON_TRANSPARENCY_0 = new TIcon(String.valueOf(iconPath) + "hotvisualtransp0.gif");
    public static TIcon ICON_TRANSPARENCY_1 = new TIcon(String.valueOf(iconPath) + "hotvisualtransp1.gif");
    public static final TIcon ICON_3D_RANGE = new TIcon(String.valueOf(iconPath) + "hotvisual3drange.gif");
    public static final TIcon ICON_3D_ROTIER = new TIcon(String.valueOf(iconPath) + "hotvisual3drotier.gif");
    public static final TIcon ICON_3D_SCROLL = new TIcon(String.valueOf(iconPath) + "hotvisual3dscroll.gif");
    public static final TIcon ICON_AXIAL = new TIcon(String.valueOf(iconPath) + "axial.GIF");
    public static final TIcon ICON_CORONAL = new TIcon(String.valueOf(iconPath) + "coronal.GIF");
    public static final TIcon ICON_SAGITTAL = new TIcon(String.valueOf(iconPath) + "sagittal.GIF");
    public static final float alphaIn = (float)Config.impaxee.jvision.HR_VISUAL.AlphaIn.get();
    public static final float alphaOut = (float)Config.impaxee.jvision.HR_VISUAL.AlphaOut.get();
    public static final float alphaAction = (float)Config.impaxee.jvision.HR_VISUAL.AlphaAction.get();
    public static final float alphaDisabled = (float)Config.impaxee.jvision.HR_VISUAL.AlphaDisabled.get();
    public static final int delayFadeIn = (int)Config.impaxee.jvision.HR_VISUAL.DelayFadeIn.get();
    public static final int delayFadeOut = (int)Config.impaxee.jvision.HR_VISUAL.DelayFadeOut.get();
    public static final int timeFadeIn = (int)Config.impaxee.jvision.HR_VISUAL.TimeFadeIn.get();
    public static final int timeFadeOut = (int)Config.impaxee.jvision.HR_VISUAL.TimeFadeOut.get();
    public static final int DURATION_SHOW_TEMPORARILY = (int)Config.impaxee.jvision.HR_VISUAL.DurationShowTemporarily.get();
    public static HotRegion.VisibilityStatus visibilityStatus;
    protected Vis2 vis;
    private Map<String, HotRegion> hrs = new HashMap<String, HotRegion>();
    protected HotRegion[] hrslyt;

    public VisHRSet(Vis2 vis2) {
        this.vis = vis2;
        visibilityStatus = PActionRegistry.getAction("HOTREGION_PAINTED").isSelected() ? HotRegion.VisibilityStatus.DEFAULT : HotRegion.VisibilityStatus.FULLY_TRANSPARENT;
        this.createHRs();
        this.updateHRs();
    }

    public abstract String getType();

    public void addHR(String string, TIcon tIcon, int n) {
        try {
            this.addHR(string, new HotRegionImage(tIcon), n);
        }
        catch (Exception exception) {
            log.error("Error loading icon" + string, (Throwable)exception);
        }
    }

    public void addHR(String string, PIcon pIcon, int n) {
        try {
            this.addHR(string, new HotRegionImage(pIcon), n);
        }
        catch (Exception exception) {
            log.error("Error loading icon" + string, (Throwable)exception);
        }
    }

    public void addHR(String string, HotRegionImage hotRegionImage, int n) {
        HotRegion hotRegion = this.createHR(string, hotRegionImage, HotRegion.HotRegionType.Normal_Dark);
        try {
            this.hrslyt[n] = hotRegion;
        }
        catch (Exception exception) {
            log.error("Exception addHR");
        }
        this.addHR(hotRegion);
    }

    public void removeHR(int n) {
        if (this.hrslyt[n] == null) {
            return;
        }
        this.hrs.remove(this.hrslyt[n]);
        this.updateHRs();
    }

    public abstract void relayout(int var1, int var2, boolean var3);

    protected abstract void createHRs();

    public void setParent(Vis2 vis2) {
        this.vis = vis2;
    }

    public void destroy() {
        this.vis = null;
        this.hrs = null;
        this.hrslyt = null;
    }

    protected void addHR(HotRegion hotRegion) {
        this.hrs.put(hotRegion.getName(), hotRegion);
        this.updateHRs();
    }

    public void removeHR(HotRegion hotRegion) {
        if (hotRegion != null && this.hrs != null) {
            this.hrs.remove(hotRegion.getName());
            this.updateHRs();
        }
    }

    @Override
    public Iterator<HotRegion> iterator() {
        return this.hrs.values().iterator();
    }

    public HotRegion getHR(String string) {
        return this.hrs.get(string);
    }

    protected void setHRBounds(String string, int n, int n2, int n3, int n4) {
        HotRegion hotRegion = this.getHR(string);
        if (hotRegion == null) {
            return;
        }
        hotRegion.setBounds(n, n2, n3, n4);
        hotRegion.setGrabOffset(-1, -1);
    }

    protected HotRegion createHR(String string, PIcon pIcon, HotRegion.HotRegionType hotRegionType) {
        return this.createHR(string, new HotRegionImage(pIcon), hotRegionType);
    }

    protected HotRegion createHR(String string, HotRegionImage hotRegionImage, HotRegion.HotRegionType hotRegionType) {
        HotRegion hotRegion = new HotRegion();
        hotRegion.removeMouseListener(hotRegion);
        hotRegion.removeMouseMotionListener(hotRegion);
        hotRegion.setName(string);
        if (hotRegionImage != null) {
            hotRegion.setImage(hotRegionImage);
        }
        hotRegion.setType(hotRegionType);
        hotRegion.setCursor(null);
        hotRegion.addListener(this);
        return hotRegion;
    }

    public void updateHRs() {
        boolean bl = false;
        try {
            if (this.vis.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo() != null) {
                bl = this.vis.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside();
            }
        }
        catch (Exception exception) {
            System.out.println();
        }
        for (HotRegion hotRegion : this.hrs.values()) {
            if (!bl) {
                float f = alphaIn;
                hotRegion.setAlphaOut(f /= 2.0f);
            } else {
                hotRegion.setAlphaOut(alphaOut);
            }
            hotRegion.updateVisibilityStatus();
        }
    }

    @Override
    public void hotRegionEntered(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.vis != null && this.vis.getView() != null) {
            TEvent tEvent = new TEvent(21);
            this.vis.getView().handleTEvent(tEvent, hotRegion, 0);
        }
    }

    @Override
    public void hotRegionExited(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.vis != null && this.vis.getView() != null) {
            TEvent tEvent = new TEvent(22);
            this.vis.getView().handleTEvent(tEvent, hotRegion, 0);
        }
    }

    @Override
    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.vis != null) {
            this.vis.hotRegionPressed(hotRegion, mouseEvent);
        }
    }

    @Override
    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.vis != null) {
            this.vis.hotRegionReleased(hotRegion, mouseEvent);
        }
    }

    @Override
    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        if (this.vis != null) {
            this.vis.hotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4);
        }
    }
}

