/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.data.shared.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.keyimages.KeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.gui.controls.basic.RepaintListener;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorComponent;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.ImageFilterNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;

public class Vis2
extends MultiMonitorComponent
implements RepaintListener {
    private static final ALogger log = ALogger.getLogger(Vis2.class);
    private static final KeyImageManager keyManager = KeyImageManager.getInstance();
    private static final Color COLOR_NOSELECT = new Color(0x303030);
    public static final Color COLOR_SELECT = new Color(0xD0D0D0);
    public static final Color COLOR_LASTMODIFIED = new Color(3760479);
    private static IAIconFactory iconFactoryBw = IAIconFactory.createMonochromeIconFactory(22);
    private static IAIconFactory iconFactoryBwScaled = IAIconFactory.createMonochromeIconFactory(66);
    public static final PIcon ICON_JPEGLOSSY_ORIGINAL = iconFactoryBwScaled.loadIcon("jpeglossy.svg");
    public static final PIcon ICON_SECONDARYCAPTURE_ORIGINAL = iconFactoryBwScaled.loadIcon("seqlabel_secondarycapture.svg");
    private static final PIcon ICON_JPEGLOSSY = iconFactoryBw.loadIcon("jpeglossy.svg");
    private static final PIcon ICON_LOAD = IAIconFactory.DEFAULT_FACTORY.loadIcon("clock.gif");
    private static final PIcon ICON_SECONDARYCAPTURE_UNSAVED = iconFactoryBw.loadIcon("seqlabel_notsaved.svg");
    private static final PIcon ICON_SECONDARYCAPTURE_SAVED = iconFactoryBw.loadIcon("seqlabel_secondarycapture.svg");
    private static final PIcon ICON_STOP = iconFactoryBwScaled.loadIcon("stops.svg");
    private static final PIcon ICON_INCORRECTLYORIENTED = IAIconFactory.DEFAULT_FACTORY.loadIcon("incorrectlyoriented.svg");
    private static final PIcon ICON_SYNC = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize.svg");
    private static final PIcon ICON_SYNCPOINT = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize_point.svg");
    private static final PIcon ICON_SYNC_MANUAL = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize_manual.svg");
    private static final PIcon ICON_SYNCPOINT_MANUAL = IAIconFactory.DEFAULT_FACTORY.loadIcon("synchronize_manual_point.svg");
    private static final PIcon ICON_REGISTRATION_VERIFIED = IAIconFactory.DEFAULT_FACTORY.loadIcon("RegistrationVerified.svg");
    private static final PIcon ICON_REGISTRATION_UNVERIFIED = IAIconFactory.DEFAULT_FACTORY.loadIcon("RegistrationUnverified.svg");
    private static final PIcon ICON_EXTERNAL_PRESSTATE = iconFactoryBw.loadIcon("neutral_presstate_hr.svg");
    private static final PIcon ICON_RWVM_AVAILABLE = IAIconFactory.DEFAULT_FACTORY.loadIcon("rwvm_available.svg");
    private static final PIcon ICON_RWVM_ACTIVE = IAIconFactory.DEFAULT_FACTORY.loadIcon("rwvm_active.svg");
    private static final PIcon ICON_FRAMERATE_WARNING = IAIconFactory.DEFAULT_FACTORY.loadIcon("snail.png");
    private static final PIcon ICON_FILTER_ACTIVE = IAIconFactory.DEFAULT_FACTORY.loadIcon("overlay_filter.svg");
    protected static final boolean whiteBackground = Config.impaxee.jvision.DISPLAY.whiteBackground.get();
    private static final int maxHROutsideWidth = 24;
    private static final int maxHROutsideHeight = 24;
    public static volatile boolean countFirstImage;
    private static double sliceSkipPerDXRelMinus;
    private static double sliceSkipPerDXRelPlus;
    private static int sliceStartIndex;
    public static final Point zoomRectStartPt;
    public static final Point zoomRectEndPt;
    private boolean isZoomRectActive = false;
    private VisDisplay2 parent;
    private VisData data;
    private VisMouseHandler mouseHandler;
    private VisHRSet hotRegions;
    private boolean isHRPaintMode = false;
    private boolean ignorePaint = false;
    private boolean hrInside = true;

    static {
        zoomRectStartPt = new Point();
        zoomRectEndPt = new Point();
    }

    public Vis2(VisDisplay2 visDisplay2) {
        this.parent = visDisplay2;
        this.setOpaque(false);
        this.setLayout(null);
        this.mouseHandler = new VisMouseHandler(this);
    }

    public void destruct() {
        this.clear(true);
        this.mouseHandler.destruct();
        if (this.hotRegions != null) {
            this.hotRegions.destroy();
            this.hotRegions = null;
        }
        this.mouseHandler = null;
    }

    public void clear(boolean bl) {
        this.setData(null, false);
        this.removeHRs();
        if (bl) {
            this.repaint();
        }
    }

    public VisDisplay2 getVisDisplay() {
        return this.parent;
    }

    public JComponent getContentPane() {
        return this.mouseHandler;
    }

    public void setHRPaintMode(boolean bl) {
        this.setHRPaintMode(bl, true);
    }

    public void setHRPaintMode(boolean bl, boolean bl2) {
        if (bl == this.isHRPaintMode) {
            return;
        }
        this.isHRPaintMode = bl;
        if (bl2 && this.hotRegions != null) {
            for (HotRegion hotRegion : this.hotRegions) {
                hotRegion.setRepaintListener(this.isHRPaintMode ? this : null);
            }
        }
    }

    public VisMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public IViewMouseHandler getViewMouseHandler() {
        if (this.data == null) {
            return null;
        }
        if (this.data.getView() == null) {
            return null;
        }
        return this.data.getView().getMouseHandler();
    }

    public VisHRSet getHRSet() {
        return this.hotRegions;
    }

    public void setHRSet(VisHRSet visHRSet) {
        this.hotRegions = visHRSet;
    }

    public boolean isSelected() {
        if (this.data == null) {
            return false;
        }
        return this.data.isSelected();
    }

    public void setSelected(boolean bl) {
        this.setSelected(bl, false);
    }

    public void setSelected(boolean bl, boolean bl2) {
        if (this.data == null) {
            return;
        }
        this.data.setSelected(bl);
        if (bl2) {
            this.repaintBorder();
        }
    }

    public boolean makeTheLastModified() {
        if (VisData.isBlockLastModifiedChange()) {
            return false;
        }
        this.requestFocusInWindow();
        if (this.data == null) {
            return false;
        }
        VisData visData = VisData.getLastModified();
        this.data.makeTheLastModified();
        if (visData != null && visData.getVisual() != this) {
            if (visData.getVisual() != null) {
                visData.getVisual().repaintBorder();
            }
            return true;
        }
        return false;
    }

    public void startZoomRect(int n, int n2) {
        Vis2.zoomRectStartPt.x = n;
        Vis2.zoomRectStartPt.y = n2;
        Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x;
        Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y;
        this.isZoomRectActive = true;
    }

    public void dragZoomRect(int n, int n2) {
        int n3;
        int n4 = n - Vis2.zoomRectStartPt.x;
        int n5 = n2 - Vis2.zoomRectStartPt.y;
        float f = (float)this.getSize().width / (float)this.getSize().height;
        if (f > 1.0f || (double)(f - 1.0f) > 0.01 && Math.abs(n4) > Math.abs(n5)) {
            Vis2.zoomRectEndPt.x = n;
            n3 = Math.abs(Math.round((float)(Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x) / f));
            if (n5 < 0) {
                n3 = -n3;
            }
            Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y + n3;
        } else {
            Vis2.zoomRectEndPt.y = n2;
            n3 = Math.abs(Math.round((float)(Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y) * f));
            if (n4 < 0) {
                n3 = -n3;
            }
            Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x + n3;
        }
        n3 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (Vis2.zoomRectEndPt.x < 0) {
            Vis2.zoomRectEndPt.x = 0;
            bl = true;
        } else if (Vis2.zoomRectEndPt.x >= this.getSize().width) {
            Vis2.zoomRectEndPt.x = this.getSize().width - 1;
            bl = true;
        } else if (Vis2.zoomRectEndPt.y < 0) {
            Vis2.zoomRectEndPt.y = 0;
            bl2 = true;
        } else if (Vis2.zoomRectEndPt.y >= this.getSize().height) {
            Vis2.zoomRectEndPt.y = this.getSize().height - 1;
            bl2 = true;
        }
        if (bl) {
            n3 = Math.abs(Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x);
            n6 = Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y > 0 ? 1 : -1;
            n6 = (int)((float)(n6 * n3) / f);
            Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y + n6;
        } else if (bl2) {
            n6 = Math.abs(Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y);
            n3 = Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x > 0 ? 1 : -1;
            n3 = (int)((float)(n6 * n3) * f);
            Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x + n3;
        }
    }

    public void stopZoomRect(int n, int n2) {
        this.isZoomRectActive = false;
    }

    public View getView() {
        if (this.data != null) {
            return this.data.getView();
        }
        return null;
    }

    public VisData getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean canShowMenu() {
        if (this.hasData() && this.data != null) {
            return !this.data.isVideo();
        }
        return false;
    }

    public boolean canHandleMouseWheel() {
        if (this.hasData() && this.data != null) {
            return !this.data.isVideo();
        }
        return false;
    }

    public void setData(VisData visData, boolean bl) {
        boolean bl2 = this.ignorePaint = !bl;
        if (this.data == visData && this.data != null && this.data.getVisual() != this) {
            this.data.setView(this);
            return;
        }
        VisData visData2 = this.data;
        this.data = visData;
        if (visData2 != null && this.data == null) {
            visData2.setView(null);
        }
        this.onDataChanged();
        if (this.data != null) {
            this.data.setView(this);
        }
        if (this.data != null && this.data.getView() != null && this.data.getView().getMouseHandler() != null) {
            Rectangle rectangle = this.getBounds();
            this.data.getView().getMouseHandler().setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.data.setVisualBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.ignorePaint = false;
        this.isHRPaintMode = false;
    }

    public void onDataChanged() {
        if (VisDisplay2.pjvi1754_isNavigDragActive() && this.parent == VisDisplay2.getNavigDrawOwner()) {
            return;
        }
        VisHRSet visHRSet = null;
        if (this.data != null && this.data.getView() != null) {
            visHRSet = this.data.getView().getHRSet(this.hotRegions, this);
        }
        if (this.hotRegions != null) {
            if (this.hotRegions == visHRSet) {
                this.hotRegions.setParent(this);
                return;
            }
            this.hotRegions.destroy();
            this.hotRegions = null;
        }
        this.hotRegions = visHRSet;
        if (this.hotRegions == null) {
            return;
        }
        this.updateHROutsideMode();
        this.addHRs();
    }

    public void paintNow() {
        if (!this.ignorePaint) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            this.paint(graphics);
            graphics.dispose();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.paintComponent(graphics);
    }

    @Override
    public void paintComponents(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.paintComponents(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.update(graphics);
    }

    @Override
    public void repaint() {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.repaint();
    }

    @Override
    public boolean handleComponentRepaint(Component component) {
        if (!this.isHRPaintMode) {
            return false;
        }
        if (this.getView() != null) {
            this.getView().setImgInvalid(true);
        }
        this.repaint();
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        this.render(graphics, n, n2);
    }

    private void renderEmpty(Graphics graphics, int n, int n2) {
        if (whiteBackground) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.fillRect(0, 0, n, n2);
    }

    private void render(Graphics graphics, int n, int n2) {
        try {
            int n3;
            int n4;
            int n5;
            if (this.data == null || !this.data.isImageAvailable() && this.data.getView() instanceof ImgView2) {
                this.paintVisBorder(graphics);
                this.renderEmpty(graphics, n, n2);
                if (this.getView() instanceof ImgView2) {
                    ImgView2 imgView2 = (ImgView2)this.getView();
                    imgView2.paintPoster(graphics);
                }
                return;
            }
            View view = this.data.getView();
            if (!(this.data.isLoaded() || view instanceof ImgView2 && ((ImgView2)view).getFrameData().getTokenData().hasToken())) {
                view.onEnterView();
                this.renderEmpty(graphics, n, n2);
                super.paint(graphics);
                int n6 = ICON_LOAD.getIconWidth();
                int n7 = n / 2;
                if (n2 < n) {
                    n7 = n2;
                }
                this.paintProgress(view, graphics, n, n2);
                if (n6 > n7) {
                    n6 = n7;
                    graphics.drawImage(ICON_LOAD.getImage(), n / 2 - n6 / 2, n2 / 2 - n6 / 2, n6, n6, null);
                } else {
                    graphics.drawImage(ICON_LOAD.getImage(), n / 2 - n6 / 2, n2 / 2 - n6 / 2, null);
                }
                this.paintVisBorder(graphics);
                return;
            }
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = this.data.getImage();
            }
            catch (Throwable throwable) {
                log.error("Vis2", throwable);
                ExceptionHandlerFactory.getInstance().handleException(throwable);
                bufferedImage = null;
            }
            this.paintVisBorder(graphics);
            Graphics graphics2 = graphics;
            if (bufferedImage != null) {
                if (!this.isHRPaintMode && this.data.isImageAvailable()) {
                    graphics.drawImage(bufferedImage, 1, 1, null);
                    if (countFirstImage) {
                        try {
                            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                            if (iHanging != null && iHanging.getStudyContainer() != null && iHanging.getStudyContainer().getBaseStudy() == this.data.getStudyData()) {
                                countFirstImage = false;
                                PerformanceProfiler.getInstance().setFirstDisplay(this.data.getImageInformation().getStudyInstanceUID());
                            }
                        }
                        catch (Exception exception) {
                            log.warn("Performance profiler error", (Throwable)exception);
                        }
                    }
                }
                this.paintProgress(view, graphics, n, n2);
                if (this.isHRPaintMode) {
                    graphics = bufferedImage.getGraphics();
                }
            }
            try {
                super.paint(graphics);
            }
            catch (Exception exception) {
                log.error("error", (Throwable)exception);
                ExceptionHandlerFactory.getInstance().handleException((Throwable)exception);
            }
            if (this.data != null && !VisDisplay2.pjvi1754_isNavigDragActive()) {
                PIcon pIcon;
                Object object;
                Object object2;
                Object object3;
                boolean bl = view.isCine();
                n5 = n / 3;
                n4 = (n - 2) / 7;
                n3 = (n2 - 2) / 7;
                if (!this.getVisDisplay().isAggregating() && !bl && (object3 = keyManager.getKeyInfo((IFrameObjectData)(object2 = this.getData().getFrameData()))) != null) {
                    KeyImageType[] keyImageTypeArray = KeyImageType.values();
                    int n8 = keyImageTypeArray.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        object = keyImageTypeArray[n9];
                        if (((KeyImageInfo)object3).isMarked((KeyImageType)((Object)object))) {
                            PIcon pIcon2 = object.getIcon();
                            int n10 = Math.min(pIcon2.getIconWidth(), n4);
                            int n11 = Math.min(pIcon2.getIconHeight(), n3);
                            graphics.drawImage(pIcon2.getImage(), n5, n2 - n11 - 2, n10, n11, null);
                            n5 += n10 + 2;
                        }
                        ++n9;
                    }
                }
                if (!this.data.isCorrectlyOriented()) {
                    int n12 = Math.min(ICON_INCORRECTLYORIENTED.getIconWidth(), n4);
                    int n13 = Math.min(ICON_INCORRECTLYORIENTED.getIconHeight(), n3);
                    graphics.drawImage(ICON_INCORRECTLYORIENTED.getImage(), n5, n2 - n13 - 2, n12, n13, null);
                    n5 += n12 + 2;
                }
                if (this.parent.getData().isSynchronized()) {
                    boolean bl2 = this.getData().getParent().isManuallySynced();
                    int n14 = Math.min(ICON_SYNC.getIconWidth(), n4);
                    int n15 = Math.min(ICON_SYNC.getIconHeight(), n3);
                    if (this.parent.getData().getSyncPointData() == this.getData()) {
                        n14 = Math.min(ICON_SYNCPOINT.getIconWidth(), n4);
                        n15 = Math.min(ICON_SYNCPOINT.getIconHeight(), n3);
                        if (bl2) {
                            graphics.drawImage(ICON_SYNCPOINT_MANUAL.getImage(), n5, n2 - n15 - 2, n14, n15, null);
                        } else {
                            graphics.drawImage(ICON_SYNCPOINT.getImage(), n5, n2 - n15 - 2, n14, n15, null);
                        }
                        n5 += n14 + 2;
                    } else {
                        if (bl2) {
                            graphics.drawImage(ICON_SYNC_MANUAL.getImage(), n5, n2 - n15 - 2, n14, n15, null);
                        } else {
                            graphics.drawImage(ICON_SYNC.getImage(), n5, n2 - n15 - 2, n14, n15, null);
                        }
                        n5 += n14 + 2;
                    }
                }
                object2 = this.data.getView().getRenderer();
                if (!bl) {
                    IRDCRenderer iRDCRenderer;
                    IFramePresentationState iFramePresentationState;
                    FrameOfReferenceManager.REGISTRATION_TYPE rEGISTRATION_TYPE;
                    object3 = DataSelectionManager.getInstance().getCurrentPatient();
                    if (object3 != null && object3.getPatientData().existsWorldToWorldTransforms() && (object = VisData.getLastModified()) != null && (rEGISTRATION_TYPE = FrameOfReferenceManager.getTypeOfWorldToWorldTransform(this.data.getImageInformation().getFrameOfReferenceUID(), ((VisData)object).getImageInformation().getFrameOfReferenceUID())) != null) {
                        PIcon pIcon3 = rEGISTRATION_TYPE == FrameOfReferenceManager.REGISTRATION_TYPE.UNVERIFIED ? ICON_REGISTRATION_UNVERIFIED : ICON_REGISTRATION_VERIFIED;
                        int n16 = Math.min(pIcon3.getIconWidth(), n4);
                        int n17 = Math.min(pIcon3.getIconHeight(), n3);
                        graphics.drawImage(pIcon3.getImage(), n5, n2 - n17 - 2, n16, n17, null);
                        n5 += n16 + 2;
                    }
                    object = null;
                    if (object2 != null) {
                        object = ((Renderer)object2).getLeaf();
                    }
                    if (object instanceof IRDCRenderer && (iFramePresentationState = (iRDCRenderer = (IRDCRenderer)object).getCurrentFramePresentationState()) != null && iFramePresentationState.isExternal() && !iFramePresentationState.isTemporary()) {
                        int n18 = Math.min(ICON_EXTERNAL_PRESSTATE.getIconWidth(), n4);
                        int n19 = Math.min(ICON_EXTERNAL_PRESSTATE.getIconHeight(), n3);
                        graphics.drawImage(ICON_EXTERNAL_PRESSTATE.getImage(), n5, n2 - n19 - 2, n18, n19, null);
                        n5 += n18 + 2;
                    }
                }
                if (view.getImageState().getCurrentValueMapping() instanceof RealWorldValueMapping) {
                    int n20 = Math.min(ICON_RWVM_ACTIVE.getIconWidth(), n4);
                    int n21 = Math.min(ICON_RWVM_ACTIVE.getIconHeight(), n3);
                    graphics.drawImage(ICON_RWVM_ACTIVE.getImage(), n5, n2 - n21 - 2, n20, n21, null);
                    n5 += n20 + 2;
                } else if (view.getImageInformation() != null && !view.getImageInformation().getRealWorldValueMappings().isEmpty()) {
                    int n22 = Math.min(ICON_RWVM_AVAILABLE.getIconWidth(), n4);
                    int n23 = Math.min(ICON_RWVM_AVAILABLE.getIconHeight(), n3);
                    graphics.drawImage(ICON_RWVM_AVAILABLE.getImage(), n5, n2 - n23 - 2, n22, n23, null);
                    n5 += n22 + 2;
                }
                if (this.data.isSecondaryCapture()) {
                    PIcon pIcon4 = this.data.isSecondaryCaptureSaved() ? ICON_SECONDARYCAPTURE_SAVED : ICON_SECONDARYCAPTURE_UNSAVED;
                    int n24 = Math.min(pIcon4.getIconWidth(), n4);
                    int n25 = Math.min(pIcon4.getIconHeight(), n3);
                    graphics.drawImage(pIcon4.getImage(), n5, n2 - n25 - 2, n24, n25, null);
                    n5 += n24 + 2;
                }
                if (this.data.isLossy()) {
                    int n26 = Math.min(ICON_JPEGLOSSY.getIconWidth(), n4);
                    int n27 = Math.min(ICON_JPEGLOSSY.getIconHeight(), n3);
                    graphics.drawImage(ICON_JPEGLOSSY.getImage(), n5, n2 - n27 - 2, n26, n27, null);
                    n5 += n26 + 2;
                }
                if (this.parent.getFrameRateWarning()) {
                    int n28 = Math.min(ICON_FRAMERATE_WARNING.getIconWidth(), n4);
                    int n29 = Math.min(ICON_FRAMERATE_WARNING.getIconHeight(), n3);
                    graphics.drawImage(ICON_FRAMERATE_WARNING.getImage(), n5, n2 - n29 - 2, n28, n29, null);
                    n5 += n28 + 2;
                }
                if (!bl && object2 instanceof ImageFilterNode && ((ImageFilterNode)object2).isFilterActive()) {
                    int n30 = Math.min(ICON_FILTER_ACTIVE.getIconWidth(), n4);
                    int n31 = Math.min(ICON_FILTER_ACTIVE.getIconHeight(), n3);
                    graphics.drawImage(ICON_FILTER_ACTIVE.getImage(), n5, n2 - n31 - 2, n30, n31, null);
                    n5 += n30 + 2;
                }
                if ((pIcon = view.getFrameData().getStatusIcon()) != null) {
                    int n32 = Math.min(pIcon.getIconWidth(), n4);
                    int n33 = Math.min(pIcon.getIconHeight(), n3);
                    graphics.drawImage(pIcon.getImage(), n5, n2 - n33 - 2, n32, n33, null);
                    n5 += n32 + 2;
                }
            }
            if (this.data != null && this.data.isStopSignTimerRunning()) {
                int n34 = ICON_STOP.getIconWidth();
                n5 = ICON_STOP.getIconHeight();
                n4 = 0;
                n4 = n34 < n5 ? n34 : n5;
                if (n34 < n4) {
                    n4 = n34;
                }
                if (n5 < n4) {
                    n4 = n5;
                }
                if (this.data.isFirstInParent()) {
                    graphics.drawImage(ICON_STOP.getImage(), n4 / 4, n4 / 4, n4, n4, null);
                }
                if (this.data.isLastInParent()) {
                    graphics.drawImage(ICON_STOP.getImage(), n - n4 - n4 / 4 - 1, n2 - n4 - n4 / 4 - 1, n4, n4, null);
                }
            }
            if (this.isZoomRectActive) {
                graphics.setColor(Color.red);
                int n35 = Vis2.zoomRectStartPt.x;
                n5 = Vis2.zoomRectStartPt.y;
                if (Vis2.zoomRectEndPt.x < n35) {
                    n35 = Vis2.zoomRectEndPt.x;
                }
                if (Vis2.zoomRectEndPt.y < n5) {
                    n5 = Vis2.zoomRectEndPt.y;
                }
                n4 = Math.abs(Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x + 1);
                n3 = Math.abs(Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y + 1);
                graphics.drawRect(n35, n5, n4, n3);
            }
            if (this.isHRPaintMode) {
                graphics2.drawImage(bufferedImage, 1, 1, null);
            }
        }
        catch (Exception exception) {
            log.error("--- could not paint vis content!", (Throwable)exception);
        }
    }

    public static void print(VisData visData, Graphics graphics, int n, int n2, View.OverlayMode overlayMode) {
        try {
            int n3;
            int n4;
            int n5;
            int n6;
            if (graphics == null) {
                return;
            }
            if (visData == null) {
                return;
            }
            Rectangle rectangle = new Rectangle(visData.getView().getBoundsForVis());
            visData.getView().setBounds(0, 0, n, n2);
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = visData.captureImage();
            }
            catch (Throwable throwable) {
                log.error("Vis2", throwable);
                bufferedImage = null;
            }
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 1, 1, null);
            }
            int n7 = n / 3;
            if (!visData.isCorrectlyOriented()) {
                n6 = ICON_INCORRECTLYORIENTED.getIconWidth();
                n5 = ICON_INCORRECTLYORIENTED.getIconHeight();
                n4 = (n - 2) / 7;
                n3 = (n2 - 2) / 7;
                if (n6 > n4) {
                    n6 = n4;
                }
                if (n5 > n3) {
                    n5 = n3;
                }
                graphics.drawImage(ICON_INCORRECTLYORIENTED.getImage(), n7, n2 - n5 - 2, n6, n5, null);
                n7 += n6 + 2;
            }
            if (visData.isLossy()) {
                n6 = ICON_JPEGLOSSY.getIconWidth();
                n5 = ICON_JPEGLOSSY.getIconHeight();
                n4 = (n - 2) / 5;
                n3 = (n2 - 2) / 5;
                if (n4 > n6) {
                    n4 = n6;
                }
                if (n3 > n5) {
                    n3 = n5;
                }
                n6 = n4;
                n5 = n3;
                graphics.drawImage(ICON_JPEGLOSSY.getImage(), n / 2 - n6 / 2, n2 - n5 - 2, n6, n5, null);
            }
            visData.getView().setBoundsForVis(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        catch (Exception exception) {
            log.error("--- could not paint vis content!", (Throwable)exception);
        }
    }

    private void paintProgress(View view, Graphics graphics, int n, int n2) {
        Component component = view.getProgressDisplay();
        if (component != null) {
            int n3 = Math.min(n2 / 2 - 10, GUI.getScaledDiagnosticInt((int)20));
            if (n3 < 0) {
                n3 = 0;
            }
            component.setBounds(0, 0, n - 10, n3);
            graphics.translate(5, n2 - n3 - 10);
            component.paint(graphics);
            graphics.translate(-5, -(n2 - n3 - 10));
        }
    }

    public void repaintBorder() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintVisBorder(graphics);
        graphics.dispose();
    }

    public void paintVisBorder(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        if (this.getView() == null || !this.getView().visBorderEnabled()) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        int n3 = 0;
        int n4 = 0;
        if (this.data == null) {
            graphics.setColor(COLOR_NOSELECT);
            graphics.drawRect(n3, n4, n - 1, n2 - 1);
            return;
        }
        if (VisData.getLastModified() == this.data) {
            int n5 = 21;
            int n6 = 21;
            float f = (float)n / (float)n5;
            float f2 = (float)n2 / (float)n6;
            int n7 = n - 1;
            int n8 = n2 - 1;
            boolean bl = this.isSelected();
            if (bl) {
                graphics.setColor(COLOR_SELECT);
            } else {
                graphics.setColor(COLOR_NOSELECT);
            }
            graphics.drawLine(n3, n4, n3 + n7, n4);
            graphics.drawLine(n3, n4 + n2 - 1, n3 + n7, n4 + n2 - 1);
            graphics.setColor(COLOR_LASTMODIFIED);
            float f3 = 0.5f;
            int n9 = 0;
            while (n9 < n5) {
                int n10 = (int)f3;
                f3 += f;
                f3 += f;
                int n11 = n10 + (int)f;
                if (n11 > n7) {
                    n11 = n7;
                }
                graphics.drawLine(n3 + n10, n4, n3 + n11, n4);
                graphics.drawLine(n3 + n10, n4 + n2 - 1, n3 + n11, n4 + n2 - 1);
                n9 += 2;
            }
            if (bl) {
                graphics.setColor(COLOR_SELECT);
            } else {
                graphics.setColor(COLOR_NOSELECT);
            }
            graphics.drawLine(n3, n4, n3, n4 + n8);
            graphics.drawLine(n3 + n - 1, n4, n3 + n - 1, n4 + n8);
            graphics.setColor(COLOR_LASTMODIFIED);
            float f4 = 0.5f;
            int n12 = 0;
            while (n12 < n6) {
                int n13 = (int)f4;
                f4 += f2;
                f4 += f2;
                int n14 = n13 + (int)f2;
                if (n14 > n8) {
                    n14 = n8;
                }
                graphics.drawLine(n3, n4 + n13, n3, n4 + n14);
                graphics.drawLine(n3 + n - 1, n4 + n13, n3 + n - 1, n4 + n14);
                n12 += 2;
            }
            return;
        }
        if (!this.isSelected()) {
            graphics.setColor(COLOR_NOSELECT);
        } else {
            graphics.setColor(COLOR_SELECT);
        }
        graphics.drawRect(n3, n4, n - 1, n2 - 1);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getBounds().width;
        int n6 = this.getBounds().height;
        int n7 = this.getBounds().x;
        int n8 = this.getBounds().y;
        if (n5 == n3 && n6 == n4 && n7 == n && n8 == n2) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.mouseHandler.setBounds(n, n2, n3, n4);
        if (this.data != null && this.data.getView() != null) {
            this.data.getView().getMouseHandler().setBounds(this.getHROutsideWidth(), this.getHROutsideHeight(), n3, n4);
        }
        this.geometryChanged(n, n2, n3, n4, n5, n6);
    }

    private void geometryChanged(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.data != null && (n5 != n3 || n6 != n4)) {
            if (this.parent != null && this.parent.getLyt().allVisSameSize()) {
                if (this.parent.getVisView(0) == this) {
                    this.parent.resizeVisuals(n3, n4);
                }
            } else {
                this.data.setVisualBounds(n, n2, n3, n4);
            }
        }
        this.relayout();
    }

    protected void relayout() {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        if (this.hotRegions != null) {
            this.hotRegions.relayout(n, n2, this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside());
        }
    }

    public void removeHRs() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof HotRegion) {
                HotRegion hotRegion = (HotRegion)componentArray[n];
                hotRegion.reset();
                this.remove(componentArray[n]);
            }
            ++n;
        }
    }

    public void addHRs() {
        if (this.getData() != null && !this.getData().getView().addingHRsAllowed()) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof HotRegion) {
                this.remove(componentArray[n]);
            }
            ++n;
        }
        if (this.hotRegions == null) {
            return;
        }
        n = (int)Config.impaxee.jvision.HR_VISUAL.MinSize.get();
        if (this.getWidth() < n || this.getHeight() < n) {
            return;
        }
        this.hotRegions.relayout(this.getBounds().width, this.getBounds().height, this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside());
        for (HotRegion hotRegion : this.hotRegions) {
            if (this.parent != null && !this.getVisDisplay().isHotRegionsEnabled()) continue;
            hotRegion.setRepaintListener(this);
            this.add(hotRegion);
        }
        if (this.parent != null && this.parent.getData() != null) {
            this.setZoomHREnabled(this.parent.getData().getZoomMode() != ZoomMode.TRUESIZE);
        }
        this.repaint();
    }

    public void setZoomHREnabled(boolean bl) {
        if (this.hotRegions == null) {
            return;
        }
        HotRegion hotRegion = this.hotRegions.getHR("ZOOM");
        if (hotRegion != null) {
            hotRegion.setVisible(bl);
            hotRegion.setEnabled(bl);
        }
    }

    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.data == null || this.data.getView() == null) {
            return;
        }
        if (hotRegion.getName().equals("NAVIG_LEFT")) {
            this.getVisDisplay().startNavigDrag();
            this.getVisDisplay().doNavigDrag(-32);
            return;
        }
        if (hotRegion.getName().equals("NAVIG_RIGHT")) {
            this.getVisDisplay().startNavigDrag();
            this.getVisDisplay().doNavigDrag(32);
            return;
        }
        if (hotRegion.getName().equals("SLICETHROUGH") && this.getView() instanceof ImgView2) {
            Rectangle rectangle = this.getMouseHandler().getBounds();
            double d = mouseEvent.getX() + hotRegion.getBounds().x;
            double d2 = rectangle.getWidth() - (double)(mouseEvent.getX() + hotRegion.getBounds().x);
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            int n = visDisplay2.getVisNavigationEventHandler().getCurrentNavigationPosition();
            int n2 = visDisplay2.getVisNavigationEventHandler().getTotalNavigationPositionCount();
            sliceSkipPerDXRelPlus = this.computeSliceSkip(n2 - n - 1, d2);
            sliceSkipPerDXRelMinus = this.computeSliceSkip(n, d);
            sliceStartIndex = n;
            return;
        }
        if (hotRegion.getName().equals("WINDOW_LEVEL")) {
            int n = ModifierKeys.isCtrl((InputEvent)mouseEvent) ? 1 : 0;
            TEvent tEvent = new TEvent();
            tEvent.id = 62;
            this.getView().handleTEvent(tEvent, mouseEvent, n);
            return;
        }
        this.removeHRs();
        this.repaint();
        this.data.getView().hotRegionPressed(hotRegion, mouseEvent);
    }

    private double computeSliceSkip(int n, double d) {
        if (n == 0) {
            return 1.0;
        }
        return (double)n / d;
    }

    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.data == null || this.data.getView() == null) {
            return;
        }
        if (hotRegion.getName().equals("NAVIG_LEFT") || hotRegion.getName().equals("NAVIG_RIGHT")) {
            this.getVisDisplay().stopNavigDrag();
        } else {
            if (hotRegion.getName().equals("SLICETHROUGH") && this.getView() instanceof ImgView2) {
                return;
            }
            if (hotRegion.getName().equals("WINDOW_LEVEL")) {
                int n = ModifierKeys.isCtrl((InputEvent)mouseEvent) ? 1 : 0;
                TEvent tEvent = new TEvent();
                tEvent.id = 62;
                this.getView().handleTEvent(tEvent, mouseEvent, n);
                return;
            }
        }
        this.data.getView().hotRegionReleased(hotRegion, mouseEvent);
    }

    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        if (this.data == null || this.data.getView() == null) {
            return;
        }
        if (hotRegion.getName().equals("NAVIG_LEFT") || hotRegion.getName().equals("NAVIG_RIGHT")) {
            return;
        }
        if (hotRegion.getName().equals("SLICETHROUGH") && this.data.getView() instanceof ImgView2) {
            int n5 = n > 0 ? (int)Math.round((double)n * sliceSkipPerDXRelPlus) + sliceStartIndex : (int)Math.round((double)n * sliceSkipPerDXRelMinus) + sliceStartIndex;
            int n6 = this.getVisDisplay().getVisNavigationEventHandler().convertToMouseWheelMovement(n5);
            if (n6 != 0) {
                this.getVisDisplay().handleMouseWheelMovement(n6, true);
            }
            return;
        }
        if (hotRegion.getName().equals("WINDOW_LEVEL")) {
            int n7 = ModifierKeys.isCtrl((InputEvent)mouseEvent) ? 1 : 0;
            TEvent tEvent = new TEvent();
            tEvent.id = 62;
            this.getView().handleTEvent(tEvent, mouseEvent, n7);
            return;
        }
        this.data.getView().hotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4);
    }

    public int getHROutsideWidth() {
        int n = this.getBounds().width / 8;
        if (n > 24) {
            n = 24;
        }
        return n;
    }

    public int getHROutsideHeight() {
        int n = this.getBounds().width / 8;
        if (n > 24) {
            n = 24;
        }
        return n;
    }

    public void updateHROutsideMode() {
        boolean bl = true;
        if (this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo() != null) {
            bl = this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside();
        }
        this.updateHROutsideMode(bl);
    }

    public void updateHROutsideMode(boolean bl) {
        if (bl == this.hrInside) {
            return;
        }
        this.hrInside = bl;
        float f = 0.0f;
        if (!bl) {
            f = VisHRSet.alphaIn / 2.0f;
        } else {
            f = VisHRSet.alphaOut;
            Object object = this.getComponents();
            int n = 0;
            while (n < ((Component[])object).length) {
                if (object[n] instanceof HotRegion && object[n].isEnabled()) {
                    ((Component)object[n]).setVisible(true);
                }
                ++n;
            }
        }
        if (this.hotRegions != null) {
            for (Object object : this.hotRegions) {
                ((HotRegion)object).setAlphaOut(f);
                ((HotRegion)object).setAlpha(f);
                ((HotRegion)object).repaint();
            }
        }
    }

    public void refreshHRs() {
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public List<VisData> getVisData(boolean bl, boolean bl2) {
        List<VisData> list = null;
        if (bl) {
            list = this.getVisDisplay().getSelectedVis();
            if (bl2 && list.size() == 0) {
                Message.info(Messages.getString("VISPOPUP_NO_SELECTED_IMAGES"));
                return null;
            }
        } else {
            list = this.getVisDisplay().getVis();
        }
        return list;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }
}

