/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.keyimages.KeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;

public class PrintUtils {
    private static final ALogger log = ALogger.getLogger(PrintUtils.class);
    private static volatile boolean isPrinting;

    public static boolean isPrintingAvailable() {
        return DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform("PRINT") != null;
    }

    public static boolean print(List<VisData> list) {
        return PrintUtils.print(list, null);
    }

    public static boolean print(List<VisData> list, List<? extends IDataObject> list2) {
        if (isPrinting) {
            return false;
        }
        IPerform iPerform = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform("PRINT");
        if (iPerform != null) {
            PrintThread printThread = new PrintThread(iPerform, list, list2);
            printThread.start();
            return true;
        }
        log.warn("PrintUtils: No printing available");
        return false;
    }

    private static class PrintThread
    extends Thread {
        private List<VisData> data;
        private List<IDataObject> objects;
        private IPerform perform;

        public PrintThread(IPerform iPerform, List<VisData> list, List<? extends IDataObject> list2) {
            this.perform = iPerform;
            this.data = list;
            this.objects = list2;
        }

        @Override
        public void run() {
            isPrinting = true;
            CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
            HashMap<String, BitSet> hashMap = new HashMap<String, BitSet>();
            try {
                List<IDataObject> object = this.objects;
                if (this.data != null) {
                    for (VisData object22 : this.data) {
                        KeyImageInfo keyImageInfo;
                        if (!object22.isLoaded()) {
                            object22.loadFinal();
                        }
                        if ((keyImageInfo = KeyImageManager.getInstance().getKeyInfo(object22.getFrameData())) == null || !keyImageInfo.isMarked()) continue;
                        String string = object22.getFrameData().getSOPInstanceUID();
                        if (object22.getFrameData().getMainFrame().getFrameCount() > 1) {
                            BitSet bitSet = (BitSet)hashMap.get(string);
                            if (bitSet == null) {
                                bitSet = new BitSet(object22.getFrameData().getMainFrame().getFrameCount());
                                hashMap.put(string, bitSet);
                            }
                            bitSet.set(object22.getFrameData().getFrameNumber());
                            continue;
                        }
                        hashMap.put(string, null);
                    }
                    List<IDataObject> list = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().createRenderableObjects(this.data);
                    if (object == null) {
                        object = list;
                    } else {
                        object.addAll(list);
                    }
                }
                if (object != null && !object.isEmpty()) {
                    this.perform.perform(new IPerform.DefaultPerformContext(JVision2.getMainFrame(), hashMap), object);
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                isPrinting = false;
            }
        }
    }
}

