/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.vis.IVisDataChooser;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.event.VisNavigationEvent;
import java.util.ArrayList;
import java.util.List;

public class NavigThread
extends Thread {
    private static final ALogger log = ALogger.getLogger(NavigThread.class);
    private VisDisplay2 parent;
    private List<VisScreen2> screens;
    private VisNavigationEvent event;
    private int direction = 0;
    private long millisPerFrame;
    private long frameStart;
    private long frameTime;
    private long delay;
    private boolean isActive;
    public long initialDelayMillis = 500L;

    public NavigThread(VisDisplay2 visDisplay2, List<VisScreen2> list) {
        this.parent = visDisplay2;
        this.screens = list;
        this.event = new VisNavigationEvent();
        this.event.id = 1;
        this.event.bRepaint = true;
        this.setFPS(30);
    }

    public List<VisScreen2> getScreens() {
        return this.screens;
    }

    public void setFPS(int n) {
        if (n == 0) {
            this.direction = 0;
        } else {
            this.millisPerFrame = (long)(1000.0f / (float)n);
        }
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    boolean isActive() {
        return this.isActive;
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        final ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        if (VisData.getLastModified() == null) {
            return;
        }
        VisDisplay2 visDisplay2 = VisData.getLastModified().getParent().getVisDisplay();
        arrayList.add(visDisplay2);
        if (this.screens != null) {
            for (VisScreen2 visScreen2 : this.screens) {
                List<VisDisplay2> list = visScreen2.getSynchronizedDisplays();
                list.remove(visDisplay2);
                arrayList.addAll(list);
            }
        }
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                NavigThread.this.showNextFrame(arrayList);
            }
        });
        while (VisDisplay2.pjvi1754_isNavigDragActive() && this.parent == VisDisplay2.getNavigDrawOwner()) {
            if (System.currentTimeMillis() - l > this.initialDelayMillis) {
                this.isActive = true;
                try {
                    EventUtil.invokeSynchronous((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            NavigThread.this.doDrag(arrayList);
                        }
                    });
                }
                catch (Exception exception) {
                    log.error("NavigThread", (Throwable)exception);
                }
                continue;
            }
            try {
                NavigThread.sleep(this.initialDelayMillis / 5L);
            }
            catch (Exception exception) {
                log.error("NavigThread", (Throwable)exception);
            }
        }
        this.isActive = false;
        this.parent.navigDragStopped();
    }

    private void doDrag(List<VisDisplay2> list) {
        try {
            if (this.direction != 0) {
                this.frameStart = System.currentTimeMillis();
                this.showNextFrame(list);
                if (!VisDisplay2.pjvi1754_isNavigDragActive() || this.parent != VisDisplay2.getNavigDrawOwner()) {
                    return;
                }
                this.frameTime = System.currentTimeMillis() - this.frameStart;
                this.delay = this.millisPerFrame - this.frameTime;
            } else {
                this.delay = 50L;
            }
            if (!VisDisplay2.pjvi1754_isNavigDragActive() || this.parent != VisDisplay2.getNavigDrawOwner()) {
                return;
            }
            if (this.delay > 10L) {
                try {
                    NavigThread.sleep(this.delay);
                }
                catch (Exception exception) {
                    log.error("NavigThread", (Throwable)exception);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Throwable throwable) {
            log.error("NavigThread", throwable);
        }
    }

    private void showNextFrame(List<VisDisplay2> list) {
        this.event.value = this.direction;
        if (list != null) {
            if (this.parent.getData().isSynchronized()) {
                VisDisplay2.synchronizeDisplays(list, this.parent, IVisDataChooser.ByOne, this.event);
            } else {
                this.parent.handleNavigationEvent(this.event);
            }
        } else {
            this.parent.handleNavigationEvent(this.event);
        }
    }
}

