/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataActionProvider;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.VariableLayout;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytScreen;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class VariableLayoutActionProvider
implements PDataActionProvider {
    private String getIconForType(VariableLayout variableLayout) {
        return "icon_variable_layout_" + variableLayout.getID() + ".svg";
    }

    public static String getActionIDForType(VariableLayout variableLayout) {
        return "VARIABLE_LAYOUT_" + variableLayout.getID();
    }

    @Override
    public List<PDataAction> getDataActions() {
        ArrayList<PDataAction> arrayList = new ArrayList<PDataAction>();
        VariableLayout[] variableLayoutArray = VariableLayout.values();
        int n = variableLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLayout variableLayout = variableLayoutArray[n2];
            arrayList.add(new VariableLayoutDataAction(variableLayout));
            ++n2;
        }
        return arrayList;
    }

    private class VariableLayoutDataAction
    extends AbstractPDataAction {
        final VariableLayout type;

        public VariableLayoutDataAction(VariableLayout variableLayout) {
            super(true);
            this.type = variableLayout;
            this.init();
        }

        @Override
        protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            return new VariableLayoutAction(pDataProvider, pDataScope);
        }

        @Override
        public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
            return providerType == PDataProvider.ProviderType.Screen;
        }

        @Override
        public PDataScope[] getAvailableScopes() {
            return new PDataScope[]{PDataScope.CurrentScreen};
        }

        @Override
        public String getID() {
            return VariableLayoutActionProvider.getActionIDForType(this.type);
        }

        private class VariableLayoutAction
        extends AbstractPDataAction.AbstractInnerPAction {
            public VariableLayoutAction(PDataProvider pDataProvider, PDataScope pDataScope) {
                super(VariableLayoutActionProvider.this.getIconForType(VariableLayoutDataAction.this.type), pDataScope, pDataProvider);
            }

            @Override
            public String getCaption() {
                return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutVariable.screenLayoutVariable.Caption"), VariableLayoutDataAction.this.type.getDescription());
            }

            @Override
            public String getGroupName() {
                return LAYOUT_GROUP;
            }

            @Override
            public boolean isSelectable() {
                return true;
            }

            @Override
            public boolean isSelected() {
                if (!this.isEnabledImpl()) {
                    return false;
                }
                VisScreen2 visScreen2 = this.provider != null ? this.provider.getVisScreen() : VariableLayoutDataAction.getCurrentScreen();
                if (visScreen2 == null) {
                    return false;
                }
                LytScreen lytScreen = visScreen2.getLyt();
                if (lytScreen == null) {
                    return false;
                }
                return lytScreen.isEquivalent(VariableLayoutDataAction.this.type);
            }

            @Override
            protected boolean isEnabledImpl() {
                VisScreen2 visScreen2 = this.provider != null ? this.provider.getVisScreen() : VariableLayoutDataAction.getCurrentScreen();
                if (visScreen2 == null || !visScreen2.isLayoutChangeAllowed()) {
                    return false;
                }
                return JVision2.getMainFrame().getLytMode() == MainLayoutType.variable;
            }

            @Override
            public String getToolTipText() {
                return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutVariable.screenLayoutVariable.ToolTip"), VariableLayoutDataAction.this.type.getDescription());
            }

            @Override
            public boolean isUpdatingListeners() {
                return this.provider != null;
            }

            @Override
            public boolean perform(Component component) {
                this.notifyActionPerformed();
                VisScreen2 visScreen2 = this.provider != null ? this.provider.getVisScreen() : VariableLayoutDataAction.getCurrentScreen();
                if (visScreen2 == null) {
                    return false;
                }
                visScreen2.setLytMode(visScreen2.getLytMode(), VariableLayoutDataAction.this.type, true);
                return true;
            }
        }
    }
}

