/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.List;

public class ToggleLocalizerDataAction
extends AbstractPDataAction {
    public static final String ID = "TOGGLE_LOCALIZER";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new ToggleLocalizerAction(pDataScope);
    }

    @Override
    public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
        return false;
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class ToggleLocalizerAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public ToggleLocalizerAction(PDataScope pDataScope) {
            super(pDataScope, null);
        }

        @Override
        public String getCaption() {
            return Messages.getString("ImgView2.Localizer");
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            List<VisData> list = ToggleLocalizerDataAction.getVisDatas(PDataScope.CurrentImage);
            if (list == null || list.isEmpty()) {
                return false;
            }
            View view = list.get(0).getView();
            if (view instanceof ImgView2) {
                return ((ImgView2)view).isLocalizerEnabled();
            }
            return false;
        }

        @Override
        protected boolean isEnabledImpl() {
            ImgView2 imgView2 = this.getOneView();
            if (imgView2 == null) {
                return false;
            }
            return imgView2.canHaveLocalizer();
        }

        private ImgView2 getOneView() {
            List<VisDisplay2> list = ToggleLocalizerDataAction.getVisDisplays(this.scope);
            if (list.isEmpty()) {
                return null;
            }
            VisDisplay2 visDisplay2 = list.get(0);
            if (!visDisplay2.hasData()) {
                return null;
            }
            View view = visDisplay2.getVis(0).getView();
            if (!(view instanceof ImgView2)) {
                return null;
            }
            return (ImgView2)view;
        }

        @Override
        public String getToolTipText() {
            return this.getCaption();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            boolean bl = !this.isSelected();
            for (VisDisplay2 visDisplay2 : AbstractPDataAction.getVisDisplays(this.scope)) {
                ImgView2 imgView2 = this.getOneView();
                if (imgView2 != null && !bl && imgView2.isMiniLocalizerEnabled()) {
                    imgView2.toggleMiniLocalizer();
                }
                TEvent tEvent = new TEvent(116);
                TEventDispatch.sendEventToVis(visDisplay2, tEvent, (Object)(bl ? Localizer.LocalizerState.UserForcedOn : Localizer.LocalizerState.Off), TEventDispatch.ALL_VISUALS);
            }
            this.fireSelectionChanged();
            return true;
        }
    }
}

