/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.gui.ImageAreaWorklistChooserPanel;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class StoreTemporarySessions
extends SelectablePAction {
    public static final String ID = "StoreTemporarySessions";
    private static boolean selected = Config.impaxee.jvision.MAIN.CollectSessions.get();

    public static boolean isActivated() {
        return selected;
    }

    public StoreTemporarySessions() {
        super("session_cumulative.svg");
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public boolean perform(Component component) {
        if (DataSelectionManager.getInstance().isMultiPatientCompareActive()) {
            ALogger.getLogger(StoreTemporarySessions.class).info("No Session collection with multi-patient compare");
            this.forcedSelectionChanged();
            return false;
        }
        selected = !selected;
        this.fireSelectionChanged();
        if (!this.isSelected()) {
            this.notifyActionPerformed();
            ArrayList<Session> arrayList = new ArrayList<Session>();
            for (IPatientRepresentation object2 : DataManager.getInstance().getPatientRepresentations()) {
                Session session;
                if (DataSelectionManager.getInstance().getCurrentPatient() == object2) {
                    session = new Session(HangingUtil.createSessionName(), object2, new Date(), false);
                    AbstractSnapshotRuntime abstractSnapshotRuntime = session.getSnapshotModel().newInstance();
                    session.getSnapshotModel().insertAt(0, abstractSnapshotRuntime);
                    arrayList.add(session);
                    continue;
                }
                session = object2.getTemporarySession();
                if (session != null) {
                    arrayList.add(session);
                }
                object2.createTemporarySession(false);
            }
            if (arrayList.isEmpty()) {
                return false;
            }
            NewSessionDialog newSessionDialog = new NewSessionDialog((Frame)JVision2.getMainFrame(), arrayList);
            newSessionDialog.setVisible(true);
        }
        return true;
    }

    @Override
    public boolean isSelected() {
        return selected;
    }

    @Override
    public String getGroupName() {
        return HANGINGS_GROUP;
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoreTemporarySessions.ActionStoreAccumulatedSessions");
    }

    @Override
    public String getToolTipText() {
        return this.getCaption();
    }

    private static class NewSessionDialog
    extends StandardDialog {
        private NewSessionPanel newSessionPanel;
        private List<Session> sessions;

        public NewSessionDialog(Frame frame, List<Session> list) {
            super(frame, Messages.getString("StoreTemporarySessions.StoreAccumulatedSessionDialogTitle"));
            this.sessions = list;
            this.addOKButton(new OKAction());
            this.addCancelButton(new CancelAction());
            this.newSessionPanel = new NewSessionPanel(list.get(0).getUserAndScheduledWorklistContexts());
            this.setContent(this.newSessionPanel);
            this.pack();
            this.initLocation();
        }

        private class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super("");
                this.putValue("ShortDescription", Messages.getString("NewSessionDialog.CancelToolTip"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewSessionDialog.this.setVisible(false);
            }
        }

        private class OKAction
        extends AbstractAction {
            public OKAction() {
                super("");
                this.putValue("ShortDescription", Messages.getString("NewSessionDialog.OKToolTip"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NewSessionDialog.this.newSessionPanel.checkSavingIntoSelectedWorklists()) {
                    NewSessionDialog.this.setDialogResult(0);
                    for (Session session : NewSessionDialog.this.sessions) {
                        session.save(NewSessionDialog.this.newSessionPanel.getSelectedWorklists());
                    }
                    NewSessionDialog.this.setVisible(false);
                }
            }
        }
    }

    private static class NewSessionPanel
    extends JPanel {
        private ImageAreaWorklistChooserPanel worklistChooserPanel;
        private JPanel createSessionPanel;
        private JPanel contentPanel;
        private List<IWorklistContext> selectableWorklists;

        public NewSessionPanel(List<IWorklistContext> list) {
            this.selectableWorklists = list;
            this.init();
        }

        public boolean checkSavingIntoSelectedWorklists() {
            return this.worklistChooserPanel.checkSavingIntoWorklists(this.worklistChooserPanel.getUpdatedWorklistContexts());
        }

        public Collection<IWorklistContext> getSelectedWorklists() {
            return this.worklistChooserPanel.getUpdatedWorklistContexts();
        }

        private void init() {
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel();
            this.worklistChooserPanel = new ImageAreaWorklistChooserPanel(this.selectableWorklists, null);
            this.createSessionPanel = new JPanel(new BorderLayout());
            this.createSessionPanel.add((Component)((Object)this.worklistChooserPanel), "Center");
            this.contentPanel = new JPanel(new BorderLayout());
            this.contentPanel.add(this.createSessionPanel);
            this.add((Component)jPanel, "North");
            this.add((Component)this.contentPanel, "Center");
        }
    }
}

