/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.MagnifierOverlay;
import com.tiani.jvision.vis.Vis2;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.SwingUtilities;

public class MagnifierAction
extends AbstractPAction {
    public static final String ID = "MAGNIFIER";
    private static boolean magnifierEnabled = false;

    public static boolean isMagnifierEnabled() {
        return magnifierEnabled;
    }

    public static void disableMagnifier() {
        magnifierEnabled = false;
    }

    public MagnifierAction() {
        super("magnify_glass.svg");
    }

    @Override
    public String getCaption() {
        return Messages.getString("ImgView2.Magnifier");
    }

    @Override
    public String getGroupName() {
        return MARKUPS_GROUP;
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(90);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("FixedActions.zoom.magnifyingGlass.ToolTip");
    }

    @Override
    public boolean perform(Component component) {
        View view;
        this.notifyActionPerformed();
        magnifierEnabled = !magnifierEnabled;
        Vis2 vis2 = this.getVisBelowMouse();
        if (vis2 != null && (view = vis2.getView()) instanceof ImgView2) {
            if (magnifierEnabled) {
                ((ImgView2)view).enableMagnifyingGlass();
            } else {
                ((ImgView2)view).disableMagnifyingGlass();
            }
        }
        return true;
    }

    private Vis2 getVisBelowMouse() {
        List<Vis2> list = JVision2.getMainFrame().getAllVis();
        Point point = MouseInfo.getPointerInfo().getLocation();
        for (Vis2 vis2 : list) {
            View view = vis2.getView();
            if (view == null) continue;
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, vis2);
            Rectangle rectangle = new Rectangle(point2, vis2.getBounds().getSize());
            if (!rectangle.contains(point)) continue;
            return vis2;
        }
        return null;
    }

    public static MagnifierOverlay getActiveMagnifier() {
        List<Vis2> list = JVision2.getMainFrame().getAllVis();
        for (Vis2 vis2 : list) {
            List<MagnifierOverlay> list2;
            View view = vis2.getView();
            if (view == null || (list2 = vis2.getView().getOverlays(MagnifierOverlay.class)).isEmpty()) continue;
            return list2.get(0);
        }
        return null;
    }
}

