/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.tf.function;

import com.tiani.jvision.tf.function.ControlPoint;
import java.awt.Polygon;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ControlHandle {
    private Collection<ControlPoint> points = new Vector<ControlPoint>(1);
    private int type = -1;
    public Polygon polygon = new Polygon();
    public Polygon scalePolygon = null;
    List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public ControlHandle(int n) {
        this.type = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void add(ControlPoint controlPoint) {
        this.points.add(controlPoint);
    }

    public void setPosition(float f) {
        Iterator<ControlPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            iterator.next().setPosition(f);
        }
        this.propertyChange(new PropertyChangeEvent(this, null, null, (int)f));
    }

    public int getPosition() {
        if (this.points.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        return this.points.iterator().next().getPosition();
    }

    public float getExactPosition() {
        if (this.points.isEmpty()) {
            return Float.MIN_VALUE;
        }
        return this.points.iterator().next().getExactPosition();
    }

    public int getValue() {
        if (this.points.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        Iterator<ControlPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            n |= iterator.next().getShiftedValue();
        }
        return n;
    }

    public void setValue(int n) {
        Iterator<ControlPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            iterator.next().setValue(n);
        }
    }

    public Collection<ControlPoint> getControlPoints() {
        return this.points;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }
}

