/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.tf.function;

import com.tiani.jvision.tf.function.ColorFunction;
import com.tiani.jvision.tf.function.ControlHandle;
import com.tiani.jvision.tf.function.LutFunction;
import com.tiani.jvision.tf.function.TransferFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class ColorOpacityFunction
extends TransferFunction
implements Serializable {
    private LutFunction alpha;
    private ColorFunction color;

    public ColorOpacityFunction(int n, int n2, int[][] nArray, int[][] nArray2, String string, String string2) {
        super(string, string2);
        int n3 = n;
        int n4 = n2;
        if (nArray != null && nArray2 == null) {
            n3 = nArray[0][0] + nArray[0][nArray[0].length - 1] >> 1;
            n4 = nArray[0][nArray[0].length - 1] - nArray[0][0];
        } else if (nArray == null && nArray2 != null) {
            n3 = nArray2[0][0] + nArray2[0][nArray2[0].length - 1] >> 1;
            n4 = nArray2[0][nArray2[0].length - 1] - nArray2[0][0];
        }
        this.color = nArray != null ? new ColorFunction(nArray, string, string2) : new ColorFunction(n3, n4, string, string2);
        this.alpha = nArray2 != null ? new LutFunction(nArray2, string, 8, string2) : new LutFunction(n3, n4, string, 8, string2);
        this.recalcLut();
    }

    public ColorOpacityFunction(int n, int n2, String string, String string2) {
        super(string, string2);
        this.color = new ColorFunction(n, n2, string, string2);
        this.alpha = new LutFunction(n, n2, string, 8, string2);
        this.recalcLut();
    }

    public ColorOpacityFunction(String string, String string2) {
        super(string, string2);
        this.color = new ColorFunction(string, string2);
        this.alpha = new LutFunction(string, 8, string2);
    }

    @Override
    protected ColorOpacityFunction cloneImpl() {
        ColorOpacityFunction colorOpacityFunction = new ColorOpacityFunction(this.unit, this.description);
        colorOpacityFunction.alpha = (LutFunction)this.alpha.clone();
        colorOpacityFunction.color = (ColorFunction)this.color.clone();
        colorOpacityFunction.setInverted(this.isInverted());
        colorOpacityFunction.setFlipped(this.isFlipped());
        return colorOpacityFunction;
    }

    @Override
    public int[] recalcLut() {
        int[] nArray = this.color.getArgbLut();
        int[] nArray2 = this.alpha.getArgbLut();
        int n = this.color.getOffset();
        int n2 = this.alpha.getOffset();
        this.offset = Math.min(n, n2);
        int n3 = Math.max(nArray.length + n - this.offset, nArray2.length + n2 - this.offset);
        int[] nArray3 = this.createLUTArray(n3);
        int n4 = 0;
        int n5 = this.offset;
        while (n4 < n3) {
            int n6 = 0;
            int n7 = 0;
            n6 = n5 - n >= nArray.length ? nArray[nArray.length - 1] : (n5 < n ? nArray[0] : nArray[n5 - n]);
            n7 = n5 - n2 >= nArray2.length ? nArray2[nArray2.length - 1] : (n5 < n2 ? nArray2[0] : nArray2[n5 - n2]);
            nArray3[n4] = n7 | n6;
            ++n4;
            ++n5;
        }
        n4 = n3;
        while (n4 < nArray3.length) {
            nArray3[n4] = nArray3[n3 - 1];
            ++n4;
        }
        return nArray3;
    }

    @Override
    public Collection<ControlHandle> getHandles(int n) {
        Vector<ControlHandle> vector = new Vector<ControlHandle>();
        if ((n & 8) != 0) {
            vector.addAll(this.alpha.getHandles(n));
        }
        if ((n & 7) != 0) {
            vector.addAll(this.color.getHandles(n));
        }
        return vector;
    }

    @Override
    public void addHandle(int n, int n2, int n3) {
        if (n3 == 8) {
            this.alpha.addHandle(n, n2, n3);
        } else if (n3 == 7) {
            this.color.addHandle(n, n2, n3);
        }
    }

    @Override
    public void removeHandle(int n, int n2) {
        if (n2 == 8) {
            this.alpha.removeHandle(n, n2);
        } else if (n2 == 7) {
            this.color.removeHandle(n, n2);
        }
    }

    @Override
    public void setApplied(boolean bl) {
        super.setApplied(bl);
        this.color.setApplied(bl);
    }

    @Override
    public void setFlipped(boolean bl) {
        super.setFlipped(bl);
        this.color.setFlipped(bl);
    }
}

