/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisHRSet;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ImageProcessorNode
extends IntermediateNode {
    protected Renderer child = null;
    protected byte[] cachedByteRaw;
    protected short[] cachedShortRaw;

    public ImageProcessorNode() {
    }

    ImageProcessorNode(Renderer renderer) {
        this.addChild(renderer);
    }

    @Override
    public List<Renderer> getChildren() {
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        arrayList.add(this.child);
        return arrayList;
    }

    @Override
    public Renderer getLeaf() {
        return this.child.getLeaf();
    }

    @Override
    public IImageInformation getImageInformation() {
        return this.child.getImageInformation();
    }

    @Override
    public List<Renderer> getVisibleChildren() {
        return this.getChildren();
    }

    @Override
    public void addChild(Renderer renderer) {
        this.child = renderer;
    }

    @Override
    public void setChild(Renderer renderer, int n) {
        this.addChild(renderer);
    }

    @Override
    public void removeChild(Renderer renderer) {
        if (this.child == renderer) {
            this.child.invalidate();
            if (this.child instanceof IntermediateNode) {
                Renderer renderer2 = this.child;
                this.child = ((IntermediateNode)this.child).getChildren().get(0);
                this.child.invalidate();
                ((IntermediateNode)renderer2).removeSubtree(this.child);
            } else {
                this.child = null;
            }
        } else if (this.child instanceof IntermediateNode) {
            ((IntermediateNode)this.child).removeChild(renderer);
        }
    }

    @Override
    public void removeSubtree(Renderer renderer) {
        if (this.child == renderer) {
            this.child = null;
        } else if (this.child instanceof IntermediateNode) {
            ((IntermediateNode)this.child).removeSubtree(renderer);
        }
    }

    @Override
    public TransferFunction getTransferFunction() {
        return this.child.getTransferFunction();
    }

    protected void raw8ToRGB(int n, int n2, boolean bl, int[] nArray, int n3, int n4) {
        if (this.cachedByteRaw != null) {
            if (this.cachedByteRaw.length == n * n2) {
                this.raw8ToRGB(this.cachedByteRaw, n, n2, 0, n, this.child.getLUTForRaw(), nArray, n3, n4);
                return;
            }
            this.cachedByteRaw = null;
        }
        this.raw8ToRGB((byte[])this.child.getRaw(n, n2, n3, n4, nArray.length, 1, bl), n, n2, n3, n4, this.child.getLUTForRaw(), nArray, n3, n4);
    }

    protected void raw16ToRGB(int n, int n2, boolean bl, int[] nArray, int n3, int n4) {
        if (this.cachedShortRaw != null) {
            if (this.cachedShortRaw.length == n * n2) {
                this.raw16ToRGB(this.cachedShortRaw, n, n2, 0, n, this.child.getLUTForRaw(), nArray, n3, n4);
                return;
            }
            this.cachedShortRaw = null;
        } else {
            this.raw16ToRGB((short[])this.child.getRaw(n, n2, n3, n4, nArray.length, 2, bl), n, n2, n3, n4, this.child.getLUTForRaw(), nArray, n3, n4);
        }
    }

    protected void rawRGBToRGB(int n, int n2, boolean bl, int[] nArray, int n3, int n4) {
        this.rawRGBToRGB((int[])this.child.getRaw(n, n2, n3, n4, nArray.length, 0, bl), n, n2, n3, n4, nArray, n3, n4);
    }

    @Override
    public void setRawBuffer(Object object) {
        this.child.setRawBuffer(object);
    }

    @Override
    public int[] getLUTForRaw() {
        return this.child.getLUTForRaw();
    }

    @Override
    public int getRawContentType() {
        return this.child.getRawContentType();
    }

    @Override
    public int getMaxRawValue() {
        return this.child.getMaxRawValue();
    }

    @Override
    public ImageState getImageState() {
        return this.child.getImageState();
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        return this.child.getMouseFollower();
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.child.getOverlays();
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder, Collection<Overlay> collection, boolean bl) {
        this.child.paintOverlays(rGBBufferedImageHolder, collection, bl);
    }

    @Override
    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        return this.child.handleHotRegionPressed(string, rectangle, mouseEvent, view);
    }

    @Override
    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        return this.child.handleHotRegionReleased(string, mouseEvent, n, n2, view);
    }

    @Override
    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        return this.child.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        return this.child.handleTEvent(tEvent, object, n, view);
    }

    @Override
    public void cleanUp() {
        this.child.cleanUp();
        this.child = null;
        this.cachedByteRaw = null;
        this.cachedShortRaw = null;
    }

    @Override
    public void invalidate() {
        this.child.invalidate();
    }

    @Override
    public boolean isInvalid() {
        return this.child.isInvalid();
    }

    @Override
    public boolean isCacheGeometryValid(boolean bl, int n, int n2, int n3, int n4, int n5) {
        return this.child.isCacheGeometryValid(bl, n, n2, n3, n4, n5);
    }

    @Override
    public void setCacheGeometry(boolean bl, int n, int n2, int n3, int n4, int n5) {
        this.child.setCacheGeometry(bl, n, n2, n3, n4, n5);
    }

    @Override
    public void fillBackground(boolean bl) {
        super.fillBackground(bl);
        this.child.fillBackground(bl);
    }

    @Override
    public void setValid() {
        this.child.setValid();
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        return this.child.getHRSet(visHRSet, vis2, view);
    }

    @Override
    public Object resolveString(String string) {
        if (this.child != null) {
            return this.child.resolveString(string);
        }
        return null;
    }

    @Override
    public void addOverlay(Overlay overlay) {
        this.child.addOverlay(overlay);
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        this.child.removeOverlay(overlay);
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        this.child.getOptimumOutputSize(snapOutputGeometry);
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        this.child.storeOverlaysToSnapshot(viewSnapshot, snapOutputGeometry);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ImageProcessorNode imageProcessorNode = (ImageProcessorNode)super.clone();
        imageProcessorNode.child = (Renderer)this.child.clone();
        return imageProcessorNode;
    }

    @Override
    public PickingResult pick(double d, double d2) {
        return this.child.pick(d, d2);
    }
}

