/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.renderer.CachingIntermediateNode;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisHRSet;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BinaryNode
extends CachingIntermediateNode {
    private static final ALogger log = ALogger.getLogger(BinaryNode.class);
    protected Renderer child1 = null;
    protected Renderer child2 = null;
    protected Renderer activeChild = null;
    private ImageState imageState;

    public BinaryNode() {
    }

    public BinaryNode(Renderer renderer, Renderer renderer2) {
        this.addChild(renderer);
        this.addChild(renderer2);
    }

    @Override
    public List<Renderer> getChildren() {
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        arrayList.add(this.child1);
        arrayList.add(this.child2);
        return arrayList;
    }

    @Override
    public List<Renderer> getVisibleChildren() {
        return this.getChildren();
    }

    @Override
    public void addChild(Renderer renderer) {
        if (this.child1 == null) {
            this.child1 = renderer;
        } else {
            this.child2 = renderer;
        }
    }

    @Override
    public void setChild(Renderer renderer, int n) {
        if (n == 0) {
            this.child1 = renderer;
        } else {
            this.child2 = renderer;
        }
    }

    @Override
    public void removeChild(Renderer renderer) {
        Renderer renderer2;
        if (this.child1 == renderer) {
            this.imageState = null;
            this.child1.invalidate();
            if (this.child1 instanceof IntermediateNode) {
                renderer2 = this.child1;
                this.child1 = ((IntermediateNode)this.child1).getChildren().get(0);
                ((IntermediateNode)renderer2).removeSubtree(this.child1);
            } else {
                this.child1 = null;
            }
        } else if (this.child1 instanceof IntermediateNode) {
            ((IntermediateNode)this.child1).removeChild(renderer);
        }
        if (this.child2 == renderer) {
            this.child2.invalidate();
            if (this.child2 instanceof IntermediateNode) {
                renderer2 = this.child2;
                this.child2 = ((IntermediateNode)this.child2).getChildren().get(0);
                ((IntermediateNode)renderer2).removeSubtree(this.child2);
            } else {
                this.child2 = null;
            }
        } else if (this.child2 instanceof IntermediateNode) {
            ((IntermediateNode)this.child2).removeChild(renderer);
        }
    }

    @Override
    public void removeSubtree(Renderer renderer) {
        if (this.child1 == renderer) {
            this.child1 = null;
            this.imageState = null;
        } else if (this.child1 instanceof IntermediateNode) {
            ((IntermediateNode)this.child1).removeSubtree(renderer);
        }
        if (this.child2 == renderer) {
            this.child2 = null;
        } else if (this.child2 instanceof IntermediateNode) {
            ((IntermediateNode)this.child2).removeSubtree(renderer);
        }
    }

    @Override
    public TransferFunction getTransferFunction() {
        if (this.activeChild != null) {
            return this.activeChild.getTransferFunction();
        }
        return this.child1.getTransferFunction();
    }

    @Override
    public Renderer getLeaf() {
        if (this.activeChild != null) {
            return this.activeChild.getLeaf();
        }
        return this.child1.getLeaf();
    }

    @Override
    public IImageInformation getImageInformation() {
        if (this.activeChild != null) {
            return this.activeChild.getImageInformation();
        }
        return this.child1.getImageInformation();
    }

    @Override
    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        if (this.activeChild == this.child1) {
            return this.child1.handleHotRegionPressed(string, rectangle, mouseEvent, view);
        }
        if (this.activeChild == this.child2) {
            return this.child2.handleHotRegionPressed(string, rectangle, mouseEvent, view);
        }
        boolean bl = this.child1.handleHotRegionPressed(string, rectangle, mouseEvent, view);
        return bl |= this.child2.handleHotRegionPressed(string, rectangle, mouseEvent, view);
    }

    @Override
    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        if (this.activeChild == this.child1) {
            return this.child1.handleHotRegionReleased(string, mouseEvent, n, n2, view);
        }
        if (this.activeChild == this.child2) {
            return this.child2.handleHotRegionReleased(string, mouseEvent, n, n2, view);
        }
        boolean bl = this.child1.handleHotRegionReleased(string, mouseEvent, n, n2, view);
        return bl |= this.child2.handleHotRegionReleased(string, mouseEvent, n, n2, view);
    }

    @Override
    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        if (this.activeChild == this.child1) {
            return this.child1.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
        }
        if (this.activeChild == this.child2) {
            return this.child2.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
        }
        boolean bl = this.child1.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
        return bl |= this.child2.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (this.activeChild == this.child1 || this.child2 == null) {
            boolean bl = this.child1.handleTEvent(tEvent, object, n, view);
            return bl |= super.handleTEvent(tEvent, object, n, view);
        }
        if (this.activeChild == this.child2) {
            boolean bl = this.child2.handleTEvent(tEvent, object, n, view);
            return bl |= super.handleTEvent(tEvent, object, n, view);
        }
        boolean bl = this.child1.handleTEvent(tEvent, object, n, view);
        bl |= this.child2.handleTEvent(tEvent, object, n, view);
        return bl |= super.handleTEvent(tEvent, object, n, view);
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        return this.child1.getHRSet(visHRSet, vis2, view);
    }

    @Override
    public Object resolveString(String string) {
        Object object = this.child1.resolveString(string);
        Object object2 = this.child2.resolveString(string);
        if (object != null) {
            return object;
        }
        return object2;
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (this.activeChild != null) {
            this.activeChild.addOverlay(overlay);
        } else {
            this.child1.addOverlay(overlay);
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        this.child1.removeOverlay(overlay);
        this.child2.removeOverlay(overlay);
    }

    @Override
    public List<Overlay> getOverlays() {
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>(this.child1.getOverlays());
        arrayList.addAll(this.child2.getOverlays());
        return arrayList;
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder, Collection<Overlay> collection, boolean bl) {
        this.child1.paintOverlays(rGBBufferedImageHolder, collection, bl);
        this.child2.paintOverlays(rGBBufferedImageHolder, collection, bl);
    }

    @Override
    public ImageState getImageState() {
        if (this.imageState == null) {
            try {
                this.imageState = this.activeChild != null ? (ImageState)this.activeChild.getImageState().getClass().newInstance() : (ImageState)this.child1.getImageState().getClass().newInstance();
            }
            catch (Exception exception) {
                log.error("BinaryNode", (Throwable)exception);
            }
        }
        return this.imageState;
    }

    public void setImageState(ImageState imageState) {
        this.imageState = imageState;
    }

    @Override
    public void updateImageState() {
        ImageState imageState = this.getImageState();
        imageState.setToCommon(this.child1.getImageState(), this.child2.getImageState());
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        snapOutputGeometry.aspectRatioChangeAllowed = false;
        if (this.activeChild != null) {
            this.activeChild.getOptimumOutputSize(snapOutputGeometry);
            return;
        }
        this.child1.getOptimumOutputSize(snapOutputGeometry);
        int n = snapOutputGeometry.destinationWidth;
        int n2 = snapOutputGeometry.destinationHeight;
        this.child2.getOptimumOutputSize(snapOutputGeometry);
        if (n > snapOutputGeometry.destinationWidth && n2 > snapOutputGeometry.destinationHeight) {
            snapOutputGeometry.destinationHeight = n2;
            snapOutputGeometry.destinationWidth = n;
        }
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        this.child1.storeOverlaysToSnapshot(viewSnapshot, snapOutputGeometry);
        this.child2.storeOverlaysToSnapshot(viewSnapshot, snapOutputGeometry);
    }

    @Override
    public void cleanUp() {
        this.child1.cleanUp();
        this.child2.cleanUp();
        this.child1 = null;
        this.child2 = null;
        this.activeChild = null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BinaryNode binaryNode = (BinaryNode)super.clone();
        binaryNode.child1 = (Renderer)this.child1.clone();
        binaryNode.child2 = (Renderer)this.child2.clone();
        return binaryNode;
    }

    @Override
    public PickingResult pick(double d, double d2) {
        if (this.activeChild != null) {
            return this.activeChild.pick(d, d2);
        }
        return this.child1.pick(d, d2);
    }
}

