/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.util.StudyComparators;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.FixTextPAction;
import com.agfa.pacs.impaxee.actions.impl.FlatCompoundAbstractPAction;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.IHangingDefinition;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwitchPriorsGroupAction
implements PActionProvider {
    private static final String ID = "PRIOR_SWITCHING";
    private SwitchPriorAction next = new SwitchPriorAction(true);
    private SwitchPriorAction previous = new SwitchPriorAction(false);

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new PriorNavigationAction(this.previous, this.next));
        arrayList.add(this.next);
        arrayList.add(this.previous);
        return arrayList;
    }

    static void updateHPAfterPriorReorder(IHanging iHanging) {
        IHangingDefinition iHangingDefinition = ((UserDefinedHangingProtocolRuntime)iHanging).getHangingDefinition();
        int n = 0;
        while (n < ((HangingDefinitionRuntime)iHangingDefinition).getSnapshotCount()) {
            ConditionalHanging conditionalHanging = ((HangingDefinitionRuntime)iHangingDefinition).getSnapshot(n).getConditionalHanging();
            if (conditionalHanging != null) {
                for (ConditionalHangingScreen conditionalHangingScreen : conditionalHanging.screens()) {
                    for (DisplaySetCondition displaySetCondition2 : conditionalHangingScreen.displaySetConditions()) {
                        displaySetCondition2.runtimeSetBaseDisplaySet(null);
                    }
                }
            }
            ++n;
        }
        DataSelectionManager.getInstance().reHangup();
        DataSelectionManager.getInstance().notifyPriorsChanged();
    }

    private static class PriorNavigationAction
    extends FlatCompoundAbstractPAction {
        public PriorNavigationAction(PAction pAction, PAction pAction2) {
            super(new PAction[]{pAction, new FixTextPAction(Messages.getString("SwitchPriors.Text")), pAction2});
        }

        @Override
        public String getCaption() {
            return Messages.getString("SwitchPriors.ToolTip");
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        protected boolean isEnabledImpl() {
            return super.isEnabledImpl();
        }

        @Override
        public String getGroupName() {
            return HANGINGS_GROUP;
        }

        @Override
        public String getID() {
            return SwitchPriorsGroupAction.ID;
        }
    }

    private static class SwitchPriorAction
    extends AbstractPAction {
        private boolean toNewer;

        public SwitchPriorAction(boolean bl) {
            super(bl ? "next_item.svg" : "previous_item.svg");
            this.toNewer = bl;
        }

        @Override
        public String getID() {
            return this.toNewer ? "NEWER_PRIOR" : "OLDER_PRIOR";
        }

        @Override
        public String getGroupName() {
            return PAction.HANGINGS_GROUP;
        }

        @Override
        protected boolean isEnabledImpl() {
            return true;
        }

        private IStudyInfo getNextStudy(IStudyContainer iStudyContainer) {
            if (iStudyContainer.getLoadedPriorCount() <= 1) {
                return null;
            }
            IStudyInfo iStudyInfo = iStudyContainer.getPriorInfo(0);
            ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
            int n = 0;
            while (n < iStudyContainer.getRelevantPriorCount()) {
                IStudyInfo iStudyInfo2 = iStudyContainer.getPriorInfo(n);
                if (iStudyContainer.isPriorLoaded(n)) {
                    arrayList.add(iStudyInfo2);
                }
                ++n;
            }
            Collections.sort(arrayList, StudyComparators.getStudyInfoComparator());
            n = arrayList.indexOf(iStudyInfo);
            if ((n += this.toNewer ? -1 : 1) < 0 || n >= arrayList.size()) {
                return null;
            }
            return (IStudyInfo)arrayList.get(n);
        }

        @Override
        public String getCaption() {
            return this.toNewer ? Messages.getString("SwitchToNewerPrior") : Messages.getString("SwitchToOlderPrior");
        }

        @Override
        public String getToolTipText() {
            return this.getCaption();
        }

        @Override
        public boolean perform(Component component) {
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging == null || !(iHanging instanceof UserDefinedHangingProtocolRuntime)) {
                return false;
            }
            IStudyContainer iStudyContainer = iHanging.getStudyContainer();
            IStudyInfo iStudyInfo = this.getNextStudy(iStudyContainer);
            if (iStudyInfo == null) {
                return false;
            }
            this.notifyActionPerformed();
            iStudyContainer.reorderStudy(iStudyInfo.getKey(), 0);
            SwitchPriorsGroupAction.updateHPAfterPriorReorder(iHanging);
            return true;
        }
    }
}

