/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DisplaySetListenerAdapter;
import com.agfa.pacs.impaxee.data.manager.IDisplaySetListener;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.ImpaxEESessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.patinfo.DisplaySetLabelGroup;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DisplaySetScrollPane
extends JScrollPane {
    private DisplaySetPanel seqPanel = null;
    private JPanel panel = null;
    private Map<String, DisplaySetLabelGroup> groups = new LinkedHashMap<String, DisplaySetLabelGroup>();
    private String patientID = null;
    private IDataSelectionListener dataSelectionListener = new DisplaySetUpdatingDataSelectionManagerListener();
    private IDisplaySetListener displaySetListener = new SeriesPaletteDisplaySetListener();
    private Modes.PaletteOrientation orientation;

    DisplaySetScrollPane(DisplaySetPanel displaySetPanel, Modes.PaletteOrientation paletteOrientation) {
        super(paletteOrientation.isHorizontal() ? 21 : 20, paletteOrientation.isHorizontal() ? 30 : 31);
        this.seqPanel = displaySetPanel;
        this.orientation = paletteOrientation;
        int n = DisplaySetLabel.tokenSize + DisplaySetLabel.infoHeight;
        this.getHorizontalScrollBar().setUnitIncrement(DisplaySetLabel.tokenSize);
        this.getVerticalScrollBar().setUnitIncrement(n);
        this.getHorizontalScrollBar().setBlockIncrement(DisplaySetLabel.tokenSize * 2);
        this.getVerticalScrollBar().setBlockIncrement(n);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                for (DisplaySetLabelGroup displaySetLabelGroup : DisplaySetScrollPane.this.groups.values()) {
                    displaySetLabelGroup.setHighlighted(false);
                }
            }
        });
        if (paletteOrientation.isHorizontal()) {
            this.panel = new JPanel(new HorizontalLabelGroupLayout());
            this.getViewport().add(this.panel);
        } else {
            this.panel = new JPanel((LayoutManager)new RowLayout(0, false, false));
            this.getViewport().add(this.panel);
        }
    }

    public List<DisplaySetLabel> getDisplaySetLabels() {
        ArrayList<DisplaySetLabel> arrayList = new ArrayList<DisplaySetLabel>(32);
        if (this.groups != null) {
            for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
                arrayList.addAll(displaySetLabelGroup.getDisplaySetLabels());
            }
        }
        return arrayList;
    }

    DisplaySetPanel getSequencePanel() {
        return this.seqPanel;
    }

    void installListeners() {
        DataManager.getInstance().addDisplaySetListener(this.displaySetListener);
        DataSelectionManager.getInstance().addListener(this.dataSelectionListener);
    }

    public Modes.PaletteOrientation getOrientation() {
        return this.orientation;
    }

    DisplaySetLabel getDisplaySetLabel(IDisplaySet iDisplaySet) {
        DisplaySetLabelGroup displaySetLabelGroup = this.findGroupForStudy(iDisplaySet.getStudy());
        return displaySetLabelGroup != null ? displaySetLabelGroup.findDisplaySetLabel(iDisplaySet) : null;
    }

    public void openStudy(IStudyData iStudyData) {
        DisplaySetLabelGroup displaySetLabelGroup = this.groups.get(iStudyData.getKey());
        if (displaySetLabelGroup != null) {
            displaySetLabelGroup.open();
        }
    }

    public boolean isStudyOpen(IStudyData iStudyData) {
        DisplaySetLabelGroup displaySetLabelGroup = this.groups.get(iStudyData.getKey());
        if (displaySetLabelGroup != null) {
            return displaySetLabelGroup.isOpen();
        }
        if (DisplaySetLabelGroup.CLOSE_STUDY_BY_DEFAULT) {
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging == null) {
                return true;
            }
            IStudyContainer iStudyContainer = iHanging.getStudyContainer();
            if (iStudyContainer == null) {
                return true;
            }
            int n = iStudyContainer.getIndexOfStudy(iStudyData.getKey());
            return n == 0;
        }
        return true;
    }

    public void closeStudy(IStudyData iStudyData) {
        DisplaySetLabelGroup displaySetLabelGroup = this.groups.get(iStudyData.getKey());
        if (displaySetLabelGroup != null) {
            displaySetLabelGroup.close();
        }
    }

    public void jumpToStudy(IStudyData iStudyData, boolean bl) {
        DisplaySetLabelGroup displaySetLabelGroup = null;
        for (DisplaySetLabelGroup displaySetLabelGroup2 : this.groups.values()) {
            if (displaySetLabelGroup2.getStudy().getKey().equals(iStudyData.getKey())) {
                displaySetLabelGroup = displaySetLabelGroup2;
                continue;
            }
            displaySetLabelGroup2.setHighlighted(false);
        }
        if (displaySetLabelGroup != null) {
            displaySetLabelGroup.jumpTo();
            if (bl) {
                displaySetLabelGroup.setHighlighted(true);
            }
        }
    }

    private void initDisplaySetLabels(IPatientRepresentation iPatientRepresentation, ISplitAndSortRuntime iSplitAndSortRuntime) {
        IDisplaySet[] iDisplaySetArray;
        Object object2;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (this.groups != null) {
            for (Object object2 : this.groups.entrySet()) {
                hashMap.put((String)object2.getKey(), ((DisplaySetLabelGroup)object2.getValue()).isOpen());
            }
        }
        object2 = new HashMap();
        for (DisplaySetLabel displaySetLabel : this.getDisplaySetLabels()) {
            object2.put(displaySetLabel.getDisplaySet(), displaySetLabel.isActive());
        }
        this.removeAllDisplaySetLabels();
        if (iPatientRepresentation != null && (iDisplaySetArray = iSplitAndSortRuntime.getDisplaySets()) != null) {
            List<String> list = this.getStudyOrdering(iPatientRepresentation);
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
            int n = iDisplaySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                DisplaySetLabel displaySetLabel = this.createDisplaySetLabel(iPatientRepresentation, iDisplaySet);
                if (displaySetLabel != null) {
                    DisplaySetLabelGroup displaySetLabelGroup;
                    Boolean bl = (Boolean)object2.get(iDisplaySet);
                    if (bl != null) {
                        displaySetLabel.setIsActive(bl);
                    }
                    if ((displaySetLabelGroup = this.findGroupForStudy(iDisplaySet.getStudy())) == null) {
                        displaySetLabelGroup = new DisplaySetLabelGroup(this, iSplitAndSortRuntime, iDisplaySet.getStudy());
                        Boolean bl2 = (Boolean)hashMap.get(displaySetLabelGroup.getStudy().getKey());
                        if (bl2 != null) {
                            if (bl2.booleanValue()) {
                                displaySetLabelGroup.open();
                            } else {
                                displaySetLabelGroup.close();
                            }
                        }
                        this.groups.put(iDisplaySet.getStudyUID(), displaySetLabelGroup);
                        List<String> list2 = this.intersection(this.groups.keySet(), list);
                        this.panel.add((Component)displaySetLabelGroup, list2.indexOf(iDisplaySet.getStudyUID()));
                    }
                    displaySetLabelGroup.addDisplaySetLabel(displaySetLabel);
                    displaySetLabel.postGUIInit();
                }
                ++n2;
            }
            for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
                displaySetLabelGroup.updateLayout();
            }
        }
        this.redraw();
    }

    private List<String> intersection(Set<String> set, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            if (!set.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private DisplaySetLabel createDisplaySetLabel(IPatientRepresentation iPatientRepresentation, IDisplaySet iDisplaySet) {
        if (iPatientRepresentation != null) {
            if (iDisplaySet instanceof ImpaxEESessionDisplaySet && iDisplaySet.getSplitAndSortRuntime().getPatientRepresentation() != iPatientRepresentation) {
                return null;
            }
            return new DisplaySetLabel(iDisplaySet);
        }
        return null;
    }

    private DisplaySetLabelGroup findGroupForStudy(IStudyData iStudyData) {
        if (iStudyData == null) {
            return null;
        }
        return this.groups.get(iStudyData.getKey());
    }

    private List<String> getStudyOrdering(IPatientRepresentation iPatientRepresentation) {
        return iPatientRepresentation.getDecompositionRuntime().getStudyOrdering();
    }

    private void removeAllDisplaySetLabels() {
        for (DisplaySetLabelGroup displaySetLabelGroup : this.groups.values()) {
            displaySetLabelGroup.removeAllDisplaySetLabels();
            this.remove(displaySetLabelGroup);
        }
        this.groups.clear();
        this.panel.removeAll();
    }

    private void redraw() {
        this.seqPanel.getTabPane().doLayout();
        this.seqPanel.getTabPane().validate();
        this.seqPanel.getTabPane().repaint();
        this.repaint();
    }

    private class DisplaySetUpdatingDataSelectionManagerListener
    extends DataSelectionListenerAdapter {
        private DisplaySetUpdatingDataSelectionManagerListener() {
        }

        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            if (iPatientRepresentation2 == null || !CompareUtils.equals((Object)DisplaySetScrollPane.this.patientID, (Object)iPatientRepresentation2.getPatientKey())) {
                DisplaySetScrollPane.this.initDisplaySetLabels(iPatientRepresentation2, iPatientRepresentation2 == null ? null : iPatientRepresentation2.getDecompositionRuntime());
                DisplaySetScrollPane.this.patientID = iPatientRepresentation2 == null ? null : iPatientRepresentation2.getPatientKey();
            }
        }

        @Override
        public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
            if (iPatientRepresentation != null && iPatientRepresentation.getPatientKey().equals(DisplaySetScrollPane.this.patientID) && (bl || iHanging instanceof Session || iHanging2 instanceof Session)) {
                DisplaySetScrollPane.this.initDisplaySetLabels(iPatientRepresentation, iHanging2.getSplitAndSortRuntime());
            }
        }
    }

    private static class HorizontalLabelGroupLayout
    implements LayoutManager {
        private HorizontalLabelGroupLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                Dimension dimension = component.getPreferredSize();
                n += dimension.width;
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                ++n4;
            }
            return new Dimension(n += container.getInsets().left + container.getInsets().right, n2 += container.getInsets().top + container.getInsets().bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                Dimension dimension = component.getPreferredSize();
                n += dimension.width;
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                ++n4;
            }
            return new Dimension(n += container.getInsets().left + container.getInsets().right, n2 += container.getInsets().top + container.getInsets().bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = 0;
            Component[] componentArray = container.getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Component component = componentArray[n3];
                Dimension dimension = component.getPreferredSize();
                if (dimension.height > n) {
                    n = dimension.height;
                }
                ++n3;
            }
            int n4 = container.getInsets().left;
            n3 = container.getInsets().top;
            Component[] componentArray2 = container.getComponents();
            int n5 = componentArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                Component component = componentArray2[n6];
                component.setBounds(n4, n3, component.getPreferredSize().width, n);
                n4 += component.getPreferredSize().width;
                ++n6;
            }
        }
    }

    private class SeriesPaletteDisplaySetListener
    extends DisplaySetListenerAdapter {
        private SeriesPaletteDisplaySetListener() {
        }

        @Override
        public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray) {
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
            int n = iDisplaySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisplaySetLabel displaySetLabel;
                IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                DisplaySetLabelGroup displaySetLabelGroup = DisplaySetScrollPane.this.findGroupForStudy(iDisplaySet.getStudy());
                DisplaySetLabel displaySetLabel2 = displaySetLabel = displaySetLabelGroup != null ? displaySetLabelGroup.findDisplaySetLabel(iDisplaySet) : null;
                if (displaySetLabel != null && displaySetLabelGroup != null) {
                    displaySetLabelGroup.removeDisplaySetLabel(displaySetLabel);
                    if (displaySetLabelGroup.getNumberOfDisplaySetLabels() == 0) {
                        DisplaySetScrollPane.this.groups.remove(iDisplaySet.getStudyUID());
                        DisplaySetScrollPane.this.panel.remove(displaySetLabelGroup);
                    } else {
                        displaySetLabelGroup.updateLayout();
                    }
                }
                ++n2;
            }
            DisplaySetScrollPane.this.revalidate();
            DisplaySetScrollPane.this.repaint();
        }

        @Override
        public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list) {
            if (!iPatientRepresentation.getPatientKey().equals(DisplaySetScrollPane.this.patientID)) {
                return;
            }
            HashSet<DisplaySetLabelGroup> hashSet = new HashSet<DisplaySetLabelGroup>();
            List list2 = DisplaySetScrollPane.this.getStudyOrdering(iPatientRepresentation);
            for (IDisplaySet object : list) {
                DisplaySetLabel displaySetLabel = DisplaySetScrollPane.this.createDisplaySetLabel(iPatientRepresentation, object);
                if (displaySetLabel == null) continue;
                IStudyData iStudyData = displaySetLabel.getStudyDataOfFirstFrame();
                DisplaySetLabelGroup displaySetLabelGroup = DisplaySetScrollPane.this.findGroupForStudy(iStudyData);
                if (displaySetLabelGroup == null) {
                    displaySetLabelGroup = new DisplaySetLabelGroup(DisplaySetScrollPane.this, object.getSplitAndSortRuntime(), iStudyData);
                    DisplaySetScrollPane.this.groups.put(iStudyData.getKey(), displaySetLabelGroup);
                    List list3 = DisplaySetScrollPane.this.intersection(DisplaySetScrollPane.this.groups.keySet(), list2);
                    DisplaySetScrollPane.this.panel.add((Component)displaySetLabelGroup, list3.indexOf(iStudyData.getKey()));
                }
                if (displaySetLabelGroup.findDisplaySetLabel(object) != null) continue;
                displaySetLabelGroup.addDisplaySetLabel(displaySetLabel);
                hashSet.add(displaySetLabelGroup);
                displaySetLabel.postGUIInit();
            }
            for (DisplaySetLabelGroup displaySetLabelGroup : hashSet) {
                displaySetLabelGroup.updateLayout();
            }
            DisplaySetScrollPane.this.revalidate();
            DisplaySetScrollPane.this.repaint();
        }

        @Override
        public void repaintDisplaySets() {
            DisplaySetScrollPane.this.repaint();
        }
    }
}

