/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.data.shared.valuemapping.DefaultValueMappingOption;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.statistics.StatisticsData;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVMappingFactory;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsDialog;
import com.tiani.jvision.overlay.statistics.SeriesSelectionDialog;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.SyncUtils;
import com.tiani.jvision.vis.TemporaryVisDisplay2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.util.message.Message;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public enum OverlayStatisticsManager implements ISelectionListener
{
    INSTANCE;

    static final boolean USE_ONLY_ORIGINAL_SERIES;
    private static final String ROI = "ROI";
    private OverlayStatisticsDialog dialog;
    private View associatedView;
    private TemporaryVisDisplay2 vd;

    static {
        USE_ONLY_ORIGINAL_SERIES = Config.impaxee.jvision.OVERLAY.Statistics.useOnlyOriginalSeries.get();
    }

    private OverlayStatisticsManager() {
        DataSelectionManager.getInstance().addSelectionListener(this);
    }

    void createSeriesSelectionDialog() {
        SeriesSelectionDialog seriesSelectionDialog = new SeriesSelectionDialog((ImageType)(USE_ONLY_ORIGINAL_SERIES ? ImageType.ORIGINAL : null));
        if (seriesSelectionDialog.isEmpty()) {
            this.showErrorMessage();
            seriesSelectionDialog = null;
            return;
        }
        seriesSelectionDialog.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    void createStatistics(View view, List<IDisplaySet> list) {
        void var6_18;
        Iterator<VisData> iterator;
        Object object2;
        this.checkROINames(view);
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>(list.size());
        ArrayList<VisData> arrayList2 = new ArrayList<VisData>(list.size());
        if (!list.isEmpty()) {
            object2 = new HashMap();
            for (VisScreen2 object4 : JVision2.getMainFrame().getScreens()) {
                for (VisDisplay2 visDisplay2 : object4.getDisplays()) {
                    if (!list.contains(visDisplay2.getData().getDisplaySet())) continue;
                    object2.put(visDisplay2.getData().getDisplaySet(), visDisplay2);
                }
            }
            for (IDisplaySet iDisplaySet : list) {
                if (object2.containsKey(iDisplaySet)) continue;
                VisDisplay2 visDisplay2 = new VisDisplay2(null);
                visDisplay2.initVisDisplay(iDisplaySet, 0, false, ActivationMode.MANUAL);
                arrayList.add(visDisplay2);
            }
            ArrayList<VisDisplay2> arrayList3 = new ArrayList<VisDisplay2>(object2.values());
            arrayList3.addAll(arrayList);
            iterator = view.getVis();
            List<VisData> list2 = SyncUtils.getCompatibleDisplaySets(iterator, arrayList3, SyncUtils.CompatibilityMode.SAME_FRAME_OF_REFERENCE);
            if (!list2.contains(iterator)) {
                list2.add(0, (VisData)((Object)iterator));
            }
            for (StatisticsData<VisData> statisticsData : StatisticsData.createSortedList(list2)) {
                arrayList2.add(statisticsData.getData());
            }
        }
        object2 = this.createDisplaySet(arrayList2);
        for (VisDisplay2 visDisplay2 : arrayList) {
            visDisplay2.clearByUser();
            visDisplay2.cleanUp();
        }
        if (object2 != null) {
            this.vd = new TemporaryVisDisplay2((IDisplaySet)object2);
            this.vd.setHotRegionsEnabled(true);
            this.vd.setMouseWheelZoomEnabled(true);
            for (VisData visData : this.vd.getVis()) {
                visData.setSelected(false);
            }
        }
        if (SUVUtil.isSUVActive(view)) {
            iterator = SUVUtil.getSUVDataForFrame(view.getDisplay(), view.getFrameData());
            SUVMappingFactory sUVMappingFactory = new SUVMappingFactory((ISUVData)iterator);
        } else if (view.getImageState().getCurrentValueMapping() instanceof RealWorldValueMapping) {
            RealWorldValueMapping realWorldValueMapping = (RealWorldValueMapping)view.getImageState().getCurrentValueMapping();
        } else {
            DefaultValueMappingOption defaultValueMappingOption = new DefaultValueMappingOption(null);
        }
        iterator = new TEvent(120);
        TEventDispatch.sendEventToVis(this.vd, iterator, var6_18, TEventDispatch.ALL_VISUALS);
        this.copyOverlays(view);
        this.vd.setNavigPos(0, true, false);
        this.showDialog(view);
        for (VisData visData : this.vd.getVis()) {
            visData.getView().updateGeometry();
        }
    }

    private void copyOverlays(View view) {
        List<Overlay> list = view.getOverlays();
        for (Overlay overlay : list) {
            StatisticsPresentationObject statisticsPresentationObject;
            if (!(overlay instanceof StatisticsPresentationObject) || !(statisticsPresentationObject = (StatisticsPresentationObject)overlay).isUsableForStatisticsDiagram()) continue;
            statisticsPresentationObject.getOrCreateAnnotation();
            if (this.vd == null || !statisticsPresentationObject.getView().copyToDestinations(statisticsPresentationObject, OverlaySynchronizationMode.WORLD_COORDINATES, this.vd.getVis())) continue;
            for (SyncablePresentationObject syncablePresentationObject : statisticsPresentationObject.getRelatives()) {
                ((StatisticsPresentationObject)syncablePresentationObject).setRemovable(false);
                if (syncablePresentationObject == statisticsPresentationObject) continue;
                this.updateTextAnnotation(syncablePresentationObject);
            }
        }
    }

    private void updateTextAnnotation(SyncablePresentationObject syncablePresentationObject) {
        syncablePresentationObject.setNonEditableTextEnabled(false);
        syncablePresentationObject.resetCachedValues();
        TextOverlay textOverlay = syncablePresentationObject.getAnnotation();
        if (textOverlay != null && !textOverlay.isVisible()) {
            textOverlay.setVisible(true);
        }
    }

    private IDisplaySet createDisplaySet(List<VisData> list) {
        if (list.isEmpty()) {
            return null;
        }
        IFrameObjectData[] iFrameObjectDataArray = new IFrameObjectData[list.size()];
        int n = 0;
        while (n < iFrameObjectDataArray.length) {
            iFrameObjectDataArray[n] = list.get(n).getFrameData();
            ++n;
        }
        return HangingFactory.getInstance().newDisplaySet(iFrameObjectDataArray, DataSelectionManager.getInstance().getCurrentPatient().getDecompositionRuntime());
    }

    private void showErrorMessage() {
        Message.error(Messages.getString("OverlayStatisticsManager.Error.NoDestination.Title"), (Object)Messages.getString("OverlayStatisticsManager.Error.NoDestination.Msg"));
    }

    private void showDialog(View view) {
        this.closeDialog();
        this.associatedView = view;
        this.associatedView.getDisplay().setPOStatisticsVisibility(true);
        this.dialog = new OverlayStatisticsDialog(view, this.vd);
        this.dialog.addWindowListener(new CloseListener());
        this.dialog.setVisible(true);
    }

    private void checkROINames(View view) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        for (Overlay overlay : view.getPresentationObjects()) {
            StatisticsPresentationObject statisticsPresentationObject;
            if (!(overlay instanceof StatisticsPresentationObject) || !(statisticsPresentationObject = (StatisticsPresentationObject)overlay).isUsableForStatisticsDiagram()) continue;
            String string = statisticsPresentationObject.getOrCreateAnnotation().getTextArea().getText();
            String string2 = this.getROIName(arrayList, string, n);
            arrayList.add(string2);
            if (string.equals(string2)) continue;
            statisticsPresentationObject.getAnnotation().getTextArea().setText(string2);
        }
        view.invalidate();
        view.repaint();
    }

    private String getROIName(ArrayList<String> arrayList, String string, int n) {
        if (arrayList.contains(string)) {
            String string2 = ROI + n;
            return this.getROIName(arrayList, string2, ++n);
        }
        arrayList.add(string);
        return string;
    }

    public void closeDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.resetDialog();
        }
    }

    void resetDialog() {
        if (this.associatedView != null && this.associatedView.getDisplay() != null) {
            this.associatedView.getDisplay().setPOStatisticsVisibility(false);
        }
        if (this.dialog != null) {
            this.dialog.cleanUp();
        }
        this.dialog = null;
        this.associatedView = null;
        if (this.vd != null) {
            this.vd.clear(true, false);
            this.vd.cleanUp();
            this.vd = null;
        }
    }

    @Override
    public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
        if (this.dialog != null && this.associatedView != null) {
            this.dialog.setVisible(visDisplayData != null && (visDisplayData.getVisDisplay() == this.associatedView.getDisplay() || visDisplayData.getVisDisplay() == this.vd));
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            OverlayStatisticsManager.this.resetDialog();
        }
    }
}

