/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

class OverlayStatisticsDisplayPanel
extends JPanel
implements AdjustmentListener {
    private static final int DEFAULT_MARGIN = ComponentFactory.instance.scaleInt(5);
    private final VisDisplay2 vd;
    private final boolean[] isLocalChangeEnabled;
    private final AbstractButton globalChangesRadioButton;
    private final AbstractButton localChangesRadioButton;
    private final AbstractButton resetButton;

    public OverlayStatisticsDisplayPanel(VisDisplay2 visDisplay2) {
        super(new BorderLayout());
        this.vd = visDisplay2;
        this.isLocalChangeEnabled = new boolean[visDisplay2.getVisCount()];
        ButtonGroup buttonGroup = new ButtonGroup();
        this.globalChangesRadioButton = this.createRadioButton(buttonGroup, false);
        this.localChangesRadioButton = this.createRadioButton(buttonGroup, true);
        this.resetButton = ComponentFactory.instance.createButton(new ResetAllAction());
        this.init();
    }

    private AbstractButton createRadioButton(ButtonGroup buttonGroup, boolean bl) {
        return ComponentFactory.instance.createRadioButton(new SynchronizationAction(bl), !bl, buttonGroup, null);
    }

    private void init() {
        this.add(this.createSynchronizationOptionsPanel(), "North");
        this.add((Component)this.vd, "Center");
        this.add((Component)this.vd.getScrollBar(), "South");
        this.vd.getScrollBar().setOrientation(0);
    }

    private Component createSynchronizationOptionsPanel() {
        this.vd.getScrollBar().addAdjustmentListener(this);
        this.resetButton.setEnabled(false);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(Messages.getString("OverlayStatisticsDisplayPanel.SynchronizationOptions.Text"));
        stringBuilder.append("</html>");
        TableLayout tableLayout = new TableLayout(new double[]{-1.0, -2.0}, new double[]{-2.0, -2.0});
        tableLayout.setHGap(DEFAULT_MARGIN);
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        jPanel.add((Component)this.globalChangesRadioButton, "0,0");
        jPanel.add((Component)this.localChangesRadioButton, "0,1");
        jPanel.add((Component)this.resetButton, "1,0,1,1");
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new BorderLayout(0, DEFAULT_MARGIN));
        jPanel2.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("OverlayStatisticsDisplayPanel.SynchronizationOptions.Title")));
        jPanel2.add((Component)ComponentFactory.instance.createLabel(stringBuilder.toString()), "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    void updateSynchronizationState(int n, boolean bl) {
        this.isLocalChangeEnabled[n] = bl;
        for (SyncablePresentationObject syncablePresentationObject : this.vd.getVis(n).getView().getOverlays(SyncablePresentationObject.class)) {
            if (bl) {
                syncablePresentationObject.suspendSynchronization();
                continue;
            }
            syncablePresentationObject.activateSynchronization();
        }
        this.resetButton.setEnabled(this.isLocalChangeEnabled());
    }

    private boolean isLocalChangeEnabled() {
        boolean[] blArray = this.isLocalChangeEnabled;
        int n = this.isLocalChangeEnabled.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = blArray[n2];
            if (bl) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void cleanUp() {
        this.vd.getScrollBar().removeAdjustmentListener(this);
    }

    void setShown(boolean bl) {
        this.vd.setEnabled(bl);
        for (Vis2 vis2 : this.vd.getVisViews()) {
            vis2.setEnabled(bl);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.isLocalChangeEnabled[adjustmentEvent.getValue()]) {
            this.localChangesRadioButton.setSelected(true);
        } else {
            this.globalChangesRadioButton.setSelected(true);
        }
    }

    private class ResetAllAction
    extends AbstractAction {
        ResetAllAction() {
            super(Messages.getString("OverlayStatisticsDisplayPanel.ResetAllAction.Name"));
            this.putValue("ShortDescription", Messages.getString("OverlayStatisticsDisplayPanel.ResetAllAction.ToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < OverlayStatisticsDisplayPanel.this.vd.getVisCount()) {
                OverlayStatisticsDisplayPanel.this.updateSynchronizationState(n, false);
                ++n;
            }
            OverlayStatisticsDisplayPanel.this.globalChangesRadioButton.setSelected(true);
            for (Vis2 vis2 : OverlayStatisticsDisplayPanel.this.vd.getVisViews()) {
                View view = vis2.getView();
                view.invalidate();
                view.repaint();
            }
        }
    }

    private class SynchronizationAction
    extends AbstractAction {
        private final boolean isLocalSwitch;

        SynchronizationAction(boolean bl) {
            this.isLocalSwitch = bl;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("OverlayStatisticsDisplayPanel.SynchronizationAction.");
            if (bl) {
                stringBuilder.append("Local");
            } else {
                stringBuilder.append("Global");
            }
            stringBuilder.append('.');
            this.putValue("Name", Messages.getString(String.valueOf(stringBuilder.toString()) + "Name"));
            this.putValue("ShortDescription", Messages.getString(String.valueOf(stringBuilder.toString()) + "ToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = OverlayStatisticsDisplayPanel.this.vd.getNavigPos();
            OverlayStatisticsDisplayPanel.this.updateSynchronizationState(n, this.isLocalSwitch);
            if (!this.isLocalSwitch) {
                View view = OverlayStatisticsDisplayPanel.this.vd.getVis(n).getView();
                view.invalidate();
                view.repaint();
            }
        }
    }
}

