/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsManager;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.text.MessageFormat;

public class OverlayStatisticsAction
extends AbstractPAction {
    public static final String ID = "OVERLAY_STATISTICS";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getCaption() {
        return Messages.getString("OverlayStatisticsAction.Caption");
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("OverlayStatisticsAction.ToolTip");
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(71, 1);
    }

    @Override
    public String getGroupName() {
        return MARKUPS_GROUP;
    }

    @Override
    public boolean perform(Component component) {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null || visData.getView().getMouseHandler().roiCreationInProgress()) {
            return false;
        }
        this.notifyActionPerformed();
        if (visData.getStudyData().getParent().hasLossyPrefetchedImages()) {
            Message.warning(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Title"), Messages.getString("OverlayStatisticsAction.LossyImageWarning.Message"));
            return false;
        }
        if (visData.getParent().getPlugin().getPluginName() != PluginName.DEFAULT) {
            Message.warning(Messages.getString("OverlayStatisticsAction.PluginWarning.Title"), Messages.getString("OverlayStatisticsAction.PluginWarning.Message"));
            return false;
        }
        int n = 0;
        int n2 = 6;
        for (Overlay object : visData.getView().getOverlays()) {
            StatisticsPresentationObject statisticsPresentationObject;
            if (!(object instanceof StatisticsPresentationObject) || !(statisticsPresentationObject = (StatisticsPresentationObject)object).isUsableForStatisticsDiagram()) continue;
            ++n;
        }
        if (n > 0) {
            if (n < n2 + 1) {
                OverlayStatisticsManager.INSTANCE.createSeriesSelectionDialog();
                return true;
            }
            String string = MessageFormat.format(Messages.getString("OverlayStatisticsAction.Dialog.StatisticsCreationNotPossible"), n, n2);
            Message.info(Messages.getString("OverlayStatisticsAction.Dialog.StatisticsCreationNotPossible.Title"), string);
            return false;
        }
        return false;
    }
}

