/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.localizer;

import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.vis.VisDisplayData;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.vecmath.Vector3d;

public class DisplayLocalizerInfo {
    private static final double ANGLE_LIMIT = 0.17453292519943295;
    private static DisplayLocalizerInfo emptyInstance = new DisplayLocalizerInfo();
    private final Vector3d normal;
    private Map<Integer, ParallelityCheckResult> areParallel = new ConcurrentSkipListMap<Integer, ParallelityCheckResult>();

    public static DisplayLocalizerInfo getEmptyInstance() {
        return emptyInstance;
    }

    private DisplayLocalizerInfo() {
        this.normal = null;
    }

    public DisplayLocalizerInfo(IImageInformation iImageInformation, IImageInformation iImageInformation2, IImageInformation iImageInformation3) {
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        Vector3d vector3d2 = iImageInformation2.getPlaneNormalUV();
        Vector3d vector3d3 = iImageInformation3.getPlaneNormalUV();
        if (vector3d == null || vector3d3 == null || vector3d2 == null) {
            this.normal = null;
            return;
        }
        if (!DisplayLocalizerInfo.isParallel(vector3d, vector3d3) || !DisplayLocalizerInfo.isParallel(vector3d, vector3d2)) {
            this.normal = null;
            return;
        }
        this.normal = vector3d;
    }

    public static boolean isParallel(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.x * vector3d2.x + vector3d.y * vector3d2.y + vector3d.z * vector3d2.z;
        if (d > 1.0) {
            d = 1.0;
        }
        return Math.abs(Math.acos(d)) <= 0.17453292519943295;
    }

    ParallelityCheckResult checkParallel(VisDisplayData visDisplayData) {
        if (this.normal == null) {
            return ParallelityCheckResult.NotChecked;
        }
        ParallelityCheckResult parallelityCheckResult = this.areParallel.get(visDisplayData.getDisplaySetID());
        if (parallelityCheckResult == null) {
            Vector3d vector3d = visDisplayData.getLocalizerInfo().getNormalVector();
            if (vector3d == null) {
                parallelityCheckResult = ParallelityCheckResult.NotChecked;
            } else {
                double d = this.normal.x * vector3d.x + this.normal.y * vector3d.y + this.normal.z * vector3d.z;
                double d2 = Math.acos(d);
                d2 = d2 <= 0.0 ? 0.0 - d2 : d2;
                parallelityCheckResult = d2 > 0.17453292519943295 ? ParallelityCheckResult.NotParallel : ParallelityCheckResult.Parallel;
            }
            this.areParallel.put(visDisplayData.getDisplaySetID(), parallelityCheckResult);
        }
        return parallelityCheckResult;
    }

    private Vector3d getNormalVector() {
        return this.normal;
    }

    public static enum ParallelityCheckResult {
        Parallel,
        NotParallel,
        NotChecked;

    }
}

