/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.mappingfonts.model.enums.WordgroupType;
import com.tiani.jvision.overlay.demographics.ISubstituteEvaluation;
import com.tiani.util.expressions.IEvaluablePrivateData;
import com.tiani.util.expressions.IEvaluationContext;
import java.text.DecimalFormat;
import java.util.Date;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.TagUtils;

abstract class AbstractSubstituteEvaluation
implements ISubstituteEvaluation {
    private static final ALogger logger = ALogger.getLogger(AbstractSubstituteEvaluation.class);
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();
    private static final String EMPTY_STRING = "";
    static final String DEFAULT_NUMBER_FORMAT = "#.##";
    private static ThreadLocal<DecimalFormat> defaultDecimalFormat = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat(AbstractSubstituteEvaluation.DEFAULT_NUMBER_FORMAT);
        }
    };

    AbstractSubstituteEvaluation() {
    }

    private String convertString(Object object, WordgroupType wordgroupType, DecimalFormat decimalFormat) {
        if (object == null) {
            return null;
        }
        String string = null;
        switch (wordgroupType) {
            case DATE: 
            case TIME: 
            case DATETIME: {
                try {
                    Date date = object instanceof Date ? (Date)object : DateUtils.parseDT(null, (String)object.toString(), (boolean)false, (DatePrecision)PERFECT_PRECISION);
                    date = this.transformDate(date);
                    if (wordgroupType == WordgroupType.DATE) {
                        string = DateTimeUtils.date2String((Date)date);
                        break;
                    }
                    if (wordgroupType == WordgroupType.TIME) {
                        string = DateTimeUtils.time2LongerString((Date)date);
                        break;
                    }
                    if (wordgroupType != WordgroupType.DATETIME) break;
                    string = DateTimeUtils.dateTime2LongerString((Date)date);
                }
                catch (Exception exception) {
                    logger.warn(object + " is not a valid date");
                }
                break;
            }
            case NUMERIC: {
                try {
                    if (decimalFormat == null) {
                        decimalFormat = defaultDecimalFormat.get();
                    }
                    double d = 0.0;
                    d = object instanceof Double ? (Double)object : Double.parseDouble(object.toString());
                    string = decimalFormat.format(this.transformDouble(d));
                }
                catch (Exception exception) {
                    string = object.toString();
                }
                break;
            }
            case STRING: {
                try {
                    string = object.toString();
                    break;
                }
                catch (Exception exception) {
                    return EMPTY_STRING;
                }
            }
        }
        return string;
    }

    private String convertString(Attributes attributes, int n, WordgroupType wordgroupType, DecimalFormat decimalFormat, int n2) {
        if (attributes == null || !attributes.containsValue(n2)) {
            return null;
        }
        String string = null;
        Date date = null;
        switch (wordgroupType) {
            case DATE: 
            case TIME: {
                long l = this.getCorrespondingDateTimeTag(n2);
                if (l != 0L) {
                    try {
                        date = attributes.getDate(l);
                    }
                    catch (Exception exception) {
                        this.logDateParsingError(attributes, n2);
                        break;
                    }
                }
            }
            case DATETIME: {
                try {
                    if (date != null) {
                        date = this.transformDate(attributes.getDate(n2));
                    }
                    if (wordgroupType == WordgroupType.DATE) {
                        string = DateTimeUtils.date2String(date);
                        break;
                    }
                    if (wordgroupType == WordgroupType.TIME) {
                        string = DateTimeUtils.time2LongerString((Date)date);
                        break;
                    }
                    if (wordgroupType != WordgroupType.DATETIME) break;
                    string = DateTimeUtils.dateTime2LongerString((Date)date);
                }
                catch (Exception exception) {
                    this.logDateParsingError(attributes, n2);
                }
                break;
            }
            case NUMERIC: {
                try {
                    if (decimalFormat == null) {
                        decimalFormat = defaultDecimalFormat.get();
                    }
                    if (n == 0) {
                        string = decimalFormat.format(this.transformDouble(attributes.getDouble(n2, 0.0)));
                        break;
                    }
                    string = decimalFormat.format(this.transformDouble(attributes.getDouble(n2, n, 0.0)));
                }
                catch (Exception exception) {
                    String[] stringArray = attributes.getStrings(n2);
                    string = stringArray[n];
                }
                break;
            }
            case STRING: {
                try {
                    if (n == 0) {
                        string = this.getString(attributes, n2);
                        break;
                    }
                    string = attributes.getString(n2, n, null);
                    break;
                }
                catch (Exception exception) {
                    return EMPTY_STRING;
                }
            }
        }
        return string;
    }

    private String getString(Attributes attributes, int n) {
        if (TagUtils.isPrivateGroup((int)n) && attributes.getVR(n) == VR.UN) {
            try {
                return new String(attributes.getBytes(n));
            }
            catch (Exception exception) {
                logger.warn("Could not parse private UN Tag:" + n);
                return null;
            }
        }
        return attributes.getString(n);
    }

    private String[] getStrings(Attributes attributes, int n) {
        if (TagUtils.isPrivateGroup((int)n) && attributes.getVR(n) == VR.UN) {
            try {
                return new String[]{new String(attributes.getBytes(n))};
            }
            catch (Exception exception) {
                logger.warn("Could not parse private UN Tag:" + n);
                return null;
            }
        }
        return attributes.getStrings(n);
    }

    private long getCorrespondingDateTimeTag(int n) {
        if (n == 524337) {
            return 2251941548130353L;
        }
        if (n == 524336) {
            return 2251937253163056L;
        }
        if (n == 524338) {
            return 2251945843097650L;
        }
        if (n == 1048626) {
            return 4503805786849330L;
        }
        return 0L;
    }

    private void logDateParsingError(Attributes attributes, int n) {
        try {
            logger.warn(String.valueOf(attributes.getString(n)) + " is not a valid date. Tag is " + this.getTagAsString(n));
        }
        catch (Exception exception) {
            logger.error("Dicom access exception", (Throwable)exception);
        }
    }

    private String[] convertStrings(Attributes attributes, WordgroupType wordgroupType, DecimalFormat decimalFormat, int n) {
        if (attributes == null || !attributes.containsValue(n)) {
            return null;
        }
        String[] stringArray = null;
        Date date = null;
        switch (wordgroupType) {
            case DATE: 
            case TIME: {
                long l = this.getCorrespondingDateTimeTag(n);
                if (l != 0L) {
                    try {
                        date = attributes.getDate(l);
                    }
                    catch (Exception exception) {
                        this.logDateParsingError(attributes, n);
                        break;
                    }
                }
            }
            case DATETIME: {
                if (date == null) {
                    date = attributes.getDate(n);
                }
                stringArray = new String[1];
                try {
                    if (wordgroupType == WordgroupType.DATE) {
                        stringArray[0] = DateTimeUtils.date2String((Date)this.transformDate(date));
                        break;
                    }
                    if (wordgroupType == WordgroupType.TIME) {
                        stringArray[0] = DateTimeUtils.time2LongerString((Date)this.transformDate(date));
                        break;
                    }
                    stringArray[0] = DateTimeUtils.dateTime2LongerString((Date)this.transformDate(date));
                }
                catch (Exception exception) {
                    this.logDateParsingError(attributes, n);
                }
                break;
            }
            case NUMERIC: {
                try {
                    VR vR;
                    if (decimalFormat == null) {
                        decimalFormat = defaultDecimalFormat.get();
                    }
                    if ((vR = ElementDictionary.vrOf((int)n, null)) == VR.FD || vR == VR.FL || vR == VR.DS) {
                        double[] dArray = attributes.getDoubles(n);
                        stringArray = new String[dArray.length];
                        int n2 = 0;
                        while (n2 < dArray.length) {
                            stringArray[n2] = decimalFormat.format(this.transformDouble(dArray[n2]));
                            ++n2;
                        }
                    } else {
                        int[] nArray = attributes.getInts(n);
                        stringArray = new String[nArray.length];
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            stringArray[n3] = decimalFormat.format(this.transformDouble(Double.valueOf(nArray[n3])));
                            ++n3;
                        }
                    }
                }
                catch (Exception exception) {
                    stringArray = attributes.getStrings(n);
                }
                break;
            }
            case STRING: {
                stringArray = this.getStrings(attributes, n);
            }
        }
        return stringArray;
    }

    protected abstract Date transformDate(Date var1);

    protected abstract Double transformDouble(Double var1);

    private String getTagAsString(int n) {
        return ElementDictionary.keywordOf((int)n, null);
    }

    @Override
    public String getString(IEvaluationContext iEvaluationContext, int[] nArray, int n, int n2, WordgroupType wordgroupType, DecimalFormat decimalFormat) {
        String string = this.convertString(iEvaluationContext.getData().resolveStringEnhanced(nArray, n), n2, wordgroupType, decimalFormat, n);
        return string;
    }

    @Override
    public String getString(IEvaluablePrivateData iEvaluablePrivateData, String string, WordgroupType wordgroupType, DecimalFormat decimalFormat) {
        return this.convertString(iEvaluablePrivateData.resolveString(string), wordgroupType, decimalFormat);
    }

    @Override
    public String[] getStrings(IEvaluationContext iEvaluationContext, int[] nArray, int n, WordgroupType wordgroupType, DecimalFormat decimalFormat) {
        return this.convertStrings(iEvaluationContext.getData().resolveStringEnhanced(nArray, n), wordgroupType, decimalFormat, n);
    }
}

