/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.curve;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.overlay.ICleanable;
import com.tiani.jvision.overlay.curve.CurvePolyLine;
import com.tiani.jvision.overlay.curve.IInterpolatable;
import com.tiani.jvision.overlay.curve.ISamplingAdapter3D;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SamplingAdapter3D
implements Cloneable,
ICleanable,
ISamplingAdapter3D {
    static final float DEFAULT_SAMPLING_METRICS = 1.0f;
    private static final ALogger log = ALogger.getLogger(SamplingAdapter3D.class);
    private static final int TANGENT_SMOOTHING = 3;
    private IInterpolatable curve;
    private long modCount = 0L;
    private CurvePolyLine points = new CurvePolyLine(300, 300);
    private float samplingMetricsX = 1.0f;
    private float samplingMetricsY = 1.0f;
    private float samplingMetricsZ = 1.0f;
    private float maxDist = 1.0f;
    private double[] voxelSize = new double[]{1.0, 1.0, 1.0};
    private double[] partialLengths = null;
    private double length;
    private double area2D;
    private boolean updateNeeded = true;

    public SamplingAdapter3D(IInterpolatable iInterpolatable) {
        this.curve = iInterpolatable;
    }

    public SamplingAdapter3D(IInterpolatable iInterpolatable, float f, float f2, float f3, float f4) {
        this(iInterpolatable);
        this.samplingMetricsX = f;
        this.samplingMetricsY = f2;
        this.samplingMetricsZ = f3;
        this.maxDist = f4;
    }

    @Override
    public SamplingAdapter3D clone() {
        SamplingAdapter3D samplingAdapter3D = null;
        try {
            samplingAdapter3D = (SamplingAdapter3D)super.clone();
            samplingAdapter3D.curve = this.curve.clone();
            samplingAdapter3D.points = new CurvePolyLine(this.points);
            samplingAdapter3D.voxelSize = (double[])this.voxelSize.clone();
        }
        catch (Exception exception) {
            log.error("Clonging of " + this + " failed.", (Throwable)exception);
        }
        return samplingAdapter3D;
    }

    void setSamplingMetrics(float f, float f2, float f3) {
        if (!(DoubleEquals.equals((double)this.samplingMetricsX, (double)f) && DoubleEquals.equals((double)this.samplingMetricsY, (double)f2) && DoubleEquals.equals((double)this.samplingMetricsZ, (double)f3))) {
            this.samplingMetricsX = f;
            this.samplingMetricsY = f2;
            this.samplingMetricsZ = f3;
            this.forceUpdate();
        }
    }

    void setMaximumSamplingPointDistance(float f) {
        if (!DoubleEquals.equals((double)this.maxDist, (double)f)) {
            this.maxDist = f;
            this.forceUpdate();
        }
    }

    public void setVoxelSize(double[] dArray) {
        if (!Arrays.equals(this.voxelSize, dArray)) {
            this.voxelSize = dArray;
            this.forceUpdate();
        }
    }

    @Override
    public void cleanUp() {
        this.curve.cleanUp();
        this.curve = null;
        this.points.cleanUp();
        this.points = null;
    }

    boolean secureValidCurve() {
        long l = this.curve.getModificationCount();
        if (this.updateNeeded || this.modCount != l) {
            this.update();
            this.modCount = l;
            return true;
        }
        return false;
    }

    private void update() {
        this.points.clear();
        this.curve.interpolate(this.points, this.samplingMetricsX, this.samplingMetricsY, this.samplingMetricsZ, this.maxDist);
        this.updateNeeded = false;
        int n = this.points.getCount();
        if (n > 0) {
            this.partialLengths = new double[n];
            this.partialLengths[0] = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            float f = this.points.xPoint[0];
            float f2 = this.points.yPoint[0];
            float f3 = this.points.zPoint[0];
            float f4 = f;
            float f5 = f2;
            float f6 = f3;
            double d4 = this.voxelSize[0] * this.voxelSize[0];
            double d5 = this.voxelSize[1] * this.voxelSize[1];
            double d6 = this.voxelSize[2] * this.voxelSize[2];
            double d7 = this.voxelSize[0] * this.voxelSize[1];
            boolean bl = this.curve.isClosed() && DoubleEquals.equals((double)f3, (double)0.0);
            int n2 = 1;
            while (n2 < n) {
                f = this.points.xPoint[n2];
                f2 = this.points.yPoint[n2];
                f3 = this.points.zPoint[n2];
                if (bl && !DoubleEquals.equals((double)f3, (double)0.0)) {
                    bl = false;
                    d3 = 0.0;
                }
                double d8 = f - f4;
                double d9 = f2 - f5;
                double d10 = f3 - f6;
                d += Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
                d2 += Math.sqrt(d8 * d8 * d4 + d9 * d9 * d5 + d10 * d10 * d6);
                if (bl) {
                    d3 += (double)(f4 * f2 - f5 * f) * d7;
                }
                this.partialLengths[n2] = d;
                f4 = f;
                f5 = f2;
                f6 = f3;
                ++n2;
            }
            this.length = d2;
            this.area2D = Math.abs(d3 / 2.0);
        } else {
            this.length = 0.0;
            this.area2D = 0.0;
        }
    }

    public double getLength() {
        this.secureValidCurve();
        return this.length;
    }

    public double getArea2D() {
        this.secureValidCurve();
        return this.area2D;
    }

    boolean isCurveClosed() {
        return this.curve.isClosed();
    }

    public CurvePolyLine getPoints() {
        this.secureValidCurve();
        return this.points;
    }

    @Override
    public int getPointCount() {
        return this.getPoints().getCount();
    }

    @Override
    public Vector3d getTangentAt(float f) {
        int n = this.getIndexAtPosition(f);
        return this.getTangentAt(n);
    }

    @Override
    public Vector3d getTangentAt(int n) {
        int n2;
        this.secureValidCurve();
        int n3 = n - 3;
        int n4 = n + 3;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > (n2 = this.points.getCount() - 1)) {
            n4 = n2;
        }
        if (n3 == n4) {
            return new Vector3d();
        }
        return new Vector3d((double)(this.points.xPoint[n4] - this.points.xPoint[n3]), (double)(this.points.yPoint[n4] - this.points.yPoint[n3]), (double)(this.points.zPoint[n4] - this.points.zPoint[n3]));
    }

    @Override
    public int getPointIndexClosestTo(float f, float f2, float f3, int n) {
        this.secureValidCurve();
        int n2 = this.points.getCount();
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            n = n2 - 1;
        }
        float f4 = (float)(this.voxelSize[0] * this.voxelSize[0]);
        float f5 = (float)(this.voxelSize[1] * this.voxelSize[1]);
        float f6 = (float)(this.voxelSize[2] * this.voxelSize[2]);
        float f7 = f - this.points.xPoint[n];
        float f8 = f2 - this.points.yPoint[n];
        float f9 = f3 - this.points.zPoint[n];
        float f10 = f7 * f7 * f4 + f8 * f8 * f5 + f9 * f9 * f6;
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            f8 = this.points.yPoint[n4] - f2;
            float f11 = f8 * f8 * f5;
            if (!(f10 <= f11) && !(f10 <= (f11 += (f7 = this.points.xPoint[n4] - f) * f7 * f4)) && f10 >= (f11 += (f9 = this.points.zPoint[n4] - f3) * f9 * f6)) {
                f10 = f11;
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    @Override
    public Point3d getPointAtPosition(float f) {
        int n = this.getIndexAtPosition(f);
        return this.getPointAtPosition(n);
    }

    @Override
    public int getIndexAtPosition(float f) {
        this.secureValidCurve();
        double d = this.partialLengths[this.points.getCount() - 1];
        double d2 = d * (double)f;
        int n = 0;
        while (this.partialLengths[n] < d2) {
            ++n;
        }
        return n - 1;
    }

    @Override
    public Point3d getPointAtPosition(int n) {
        int n2;
        this.secureValidCurve();
        if (n < 0) {
            n = 0;
        }
        if (n > (n2 = this.points.getCount() - 1)) {
            n = n2;
        }
        return new Point3d((double)this.points.xPoint[n], (double)this.points.yPoint[n], (double)this.points.zPoint[n]);
    }

    void forceUpdate() {
        this.updateNeeded = true;
    }

    @Override
    public double getRelativePositionFromIndex(int n) {
        this.secureValidCurve();
        return this.partialLengths[n] / this.partialLengths[this.points.getCount() - 1];
    }
}

