/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.curve;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.overlay.BMPShutter;
import com.tiani.jvision.overlay.BinBMPShutter;
import com.tiani.jvision.overlay.CurvePainter;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IMeasurementOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.IVolumeProjection;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.OverlayLengthInformation;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.Shutter;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import com.tiani.jvision.overlay.curve.CubicSplineInterpolation;
import com.tiani.jvision.overlay.curve.CurvePolyLine;
import com.tiani.jvision.overlay.curve.SamplingAdapterImage;
import com.tiani.jvision.overlay.curve.SamplingAdapterScreen;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3f;

public class CurveOverlay
extends StatisticsPresentationObject
implements PointSequence,
IGraphicObjectContainer,
IMeasurementOverlay,
IVolumeProjection {
    private CubicSplineInterpolation curve;
    protected SamplingAdapterScreen samScr;
    protected SamplingAdapterImage samImg;
    protected int[] scrPointX = new int[5];
    protected int[] scrPointY = new int[5];
    protected CurvePainter painter = new CurvePainter();
    protected int scrCenterX;
    protected int scrCenterY;
    protected boolean closed = false;
    private ImageRegion ir = new ImageRegion(this);

    public CurveOverlay() {
        super("Curve");
        this.curve = new CubicSplineInterpolation();
        this.samScr = new SamplingAdapterScreen(this.curve);
        this.samImg = new SamplingAdapterImage(this.curve);
    }

    public CurveOverlay(double[] dArray, double[] dArray2, AnnotationUnits annotationUnits, boolean bl) {
        this(dArray, dArray2, annotationUnits, bl, false);
    }

    public CurveOverlay(double[] dArray, double[] dArray2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        this();
        int n;
        this.setShutterMode(bl2);
        if (!bl2) {
            this.setSolid(bl);
        } else {
            this.setSolid(false);
        }
        boolean bl3 = this.closed = dArray[0] == dArray[dArray.length - 1] && dArray2[0] == dArray2[dArray2.length - 1];
        if (bl2) {
            this.closed = true;
        }
        int n2 = n = this.closed ? dArray.length - 1 : dArray.length;
        if (this.scrPointX.length < dArray.length) {
            this.scrPointX = new int[dArray.length + 5];
            this.scrPointY = new int[dArray.length + 5];
        }
        int n3 = 0;
        while (n3 < n) {
            this.curve.addPoint((float)dArray[n3], (float)dArray2[n3], 0.0f);
            this.scrPointX[n3] = (int)dArray[n3];
            this.scrPointY[n3] = (int)dArray2[n3];
            ++n3;
        }
        this.curve.setClosed(this.closed);
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return !this.isShutter();
    }

    protected void makeHandles() {
        int n = this.curve.getCount();
        if (n == 0) {
            this.handles = new PresentationHandle[]{new PresentationHandle(0, 0)};
            return;
        }
        this.handles = new PresentationHandle[n + 1];
        this.scrCenterX = 0;
        this.scrCenterY = 0;
        int n2 = 0;
        while (n2 < n) {
            this.handles[n2] = new PresentationHandle(this.scrPointX[n2], this.scrPointY[n2]);
            this.scrCenterX += this.scrPointX[n2];
            this.scrCenterY += this.scrPointY[n2];
            ++n2;
        }
        this.scrCenterX /= n;
        this.scrCenterY /= n;
        TranslationHandle translationHandle = new TranslationHandle(this.scrCenterX, this.scrCenterY);
        this.handles[n] = translationHandle;
    }

    @Override
    protected void toScreen() {
        boolean bl;
        Object object;
        double[] dArray = new double[2];
        this.scrCenterX = 0;
        this.scrCenterY = 0;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = this.curve.getCount();
        if (this.scrPointX.length < n5) {
            this.scrPointX = new int[n5 + 5];
            this.scrPointY = new int[n5 + 5];
        }
        int n6 = 0;
        while (n6 < n5) {
            object = this.curve.getPoint(n6);
            dArray[0] = object.x;
            dArray[1] = object.y;
            dArray = this.toScreen(dArray);
            this.scrPointX[n6] = (int)dArray[0];
            this.scrPointY[n6] = (int)dArray[1];
            this.handles[n6].setPosition(this.scrPointX[n6], this.scrPointY[n6]);
            this.scrCenterX += this.scrPointX[n6];
            this.scrCenterY += this.scrPointY[n6];
            if (this.scrPointX[n6] > n4) {
                n4 = this.scrPointX[n6];
            }
            if (this.scrPointX[n6] < n2) {
                n2 = this.scrPointX[n6];
            }
            if (this.scrPointY[n6] > n3) {
                n3 = this.scrPointY[n6];
            }
            if (this.scrPointY[n6] < n) {
                n = this.scrPointY[n6];
            }
            ++n6;
        }
        this.scrCenterX /= n5;
        this.scrCenterY /= n5;
        this.handles[n5].setPosition(this.scrCenterX, this.scrCenterY);
        this.translationHandleIndex = n5;
        this.bounds.x = n2 - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = n - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = n4 - n2 + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = n3 - n + 2 * PresentationHandle.HANDLE_SIZE;
        double[] dArray2 = new double[]{0.0, 0.0};
        object = new double[]{100.0, 100.0};
        dArray2 = this.toScreen(dArray2);
        object = this.toScreen((double[])object);
        this.samScr.updateSamplingMetric((float)(object[0] - dArray2[0]) * 0.01f, (float)Math.abs((double)(object[1] - dArray2[1])) * 0.01f);
        this.painter.update(this.samScr.getImgPointsRef(), this);
        this.samImg.setDataPixelSize(this.getDataPixelSizeX(), this.getDataPixelSizeY());
        boolean bl2 = bl = this.ownedCompanions != null && this.ownedCompanions.length > 0 && this.getAnnotation() != null && this.spacingType == AnnotationUnits.Pixel;
        if (bl) {
            if (this.closed) {
                if (n5 > 2 && this.shapeChanged && this.getImageState().window != null) {
                    this.shapeChanged = false;
                    IImageRegionProperties iImageRegionProperties = this.updateHistogram(this.ir);
                    ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>();
                    arrayList.add(this.createAreaInformation(this.samImg.getMMArea()));
                    arrayList.add(this.createOverlayInformation(OverlayInformationID.PERIMETER, this.samImg.getMMCircumference()));
                    this.setNonEditableAnnotation(arrayList, iImageRegionProperties);
                }
            } else {
                this.makeOpenROI(this.samImg);
            }
        }
        if (this.isShutter()) {
            if (this.shutterMask == null) {
                this.shutterMask = new BMPShutter(this.shutterValue);
            }
            this.shutterMask.update(this);
        }
    }

    @Override
    public void volumeToScreen(double d, double d2, double d3, double[] dArray) {
        this.toScreen(new double[]{d, d2}, dArray);
    }

    @Override
    public boolean isInPlane(double d, double d2, double d3) {
        return true;
    }

    protected void makeOpenROI(SamplingAdapterImage samplingAdapterImage) {
        OverlayLengthInformation overlayLengthInformation = new OverlayLengthInformation(samplingAdapterImage.getMMCircumference(), this.dimensionUnit());
        this.setNonEditableAnnotation(Collections.singletonList(overlayLengthInformation), null);
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder, boolean bl) {
        if (this.isShutter() && (!this.isSelected() && this.isCompleted() || this.shutterMask instanceof BinBMPShutter)) {
            this.shutterMask.applyShutter(bufferedImageHolder.getImageArray(), bufferedImageHolder.width, bufferedImageHolder.height);
            if (!Shutter.displayOutline) {
                return;
            }
        }
        this.painter.paint(bufferedImageHolder, this, bl && this.closed, this.initStep > 2);
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        int n2 = this.curve.getCount();
        if (!this.isCompleted() && n == n2) {
            --n;
        }
        if (n == n2) {
            double[] dArray2 = this.toImage(new double[]{this.scrCenterX, this.scrCenterY});
            float f = (float)(dArray[0] - dArray2[0]);
            float f2 = (float)(dArray[1] - dArray2[1]);
            this.curve.movePoints(f, f2, 0.0f);
        } else {
            this.curve.setPoint(n, (float)dArray[0], (float)dArray[1], 0.0f);
        }
        this.toScreen();
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        Object[] objectArray;
        int n2 = this.curve.getCount();
        if (this.scrPointX.length < n2) {
            objectArray = new int[n2 + 10];
            int[] nArray = new int[n2 + 10];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = this.scrPointX[n3];
                nArray[n3] = this.scrPointY[n3];
                ++n3;
            }
            this.scrPointX = (int[])objectArray;
            this.scrPointY = nArray;
        }
        objectArray = this.toScreen(dArray);
        double d = objectArray[0];
        double d2 = objectArray[1];
        int n4 = this.getSnapHandleSize();
        if (n2 > 2) {
            boolean bl = this.closed = Math.abs((double)this.scrPointX[0] - d) < (double)(n4 / 2) && Math.abs((double)this.scrPointY[0] - d2) < (double)(n4 / 2);
        }
        if (n2 > 2 && (this.closed || Math.abs((double)this.scrPointX[n2 - 2] - d) < (double)(n4 / 2) && Math.abs((double)this.scrPointY[n2 - 2] - d2) < (double)(n4 / 2))) {
            this.curve.removeLastPoint();
            this.curve.setClosed(this.closed);
            n2 = this.curve.getCount();
            if (Math.abs((double)this.scrPointX[n2 - 1] - d) < (double)(n4 / 2) && Math.abs((double)this.scrPointY[n2 - 1] - d2) < (double)(n4 / 2) && (this.isSolid() || this.isShutter())) {
                this.closed = true;
                this.curve.setClosed(true);
            }
            this.makeHandles();
            this.afterInteractiveGeneration();
            return -1;
        }
        if (n2 > 0) {
            this.curve.setPoint(n2 - 1, (float)dArray[0], (float)dArray[1], 0.0f);
        }
        this.handles = Arrays.copyOf(this.handles, this.handles.length + 1);
        this.curve.addPoint((float)dArray[0], (float)dArray[1], 0.0f);
        n2 = this.curve.getCount();
        this.handles[n2] = new PresentationHandle(0, 0);
        this.toScreen();
        this.activeHandleIndex = n2 - 1;
        return n + 1;
    }

    protected void afterInteractiveGeneration() {
        TextOverlay textOverlay = this.createAnnotation();
        if (this.closed && textOverlay != null) {
            textOverlay.setVisible(CurveOverlay.getTextAnnotationLevel().isTextAnnotationVisible());
        }
    }

    @Override
    protected boolean splitDragged() {
        return false;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(80, "ROI");
    }

    @Override
    public boolean supportsHistogram() {
        return this.closed;
    }

    @Override
    public boolean isInside(int n, int n2) {
        int n3 = 0;
        int n4 = this.curve.getCount();
        int n5 = 0;
        while (n5 < n4) {
            Point3f point3f = this.curve.getPoint(n5);
            Point3f point3f2 = this.curve.getPoint((n5 + 1) % n4);
            if (point3f.y < (float)n2 && point3f2.y >= (float)n2 || point3f2.y < (float)n2 && point3f.y >= (float)n2) {
                if (point3f.x == point3f2.x) {
                    if (point3f.x <= (float)n) {
                        ++n3;
                    }
                } else if (point3f.x <= (float)n && point3f2.x <= (float)n) {
                    ++n3;
                } else {
                    double d = (point3f2.x - point3f.x) / (point3f2.y - point3f.y);
                    if ((double)point3f.x + d * (double)((float)n2 - point3f.y) <= (double)n) {
                        ++n3;
                    }
                }
            }
            ++n5;
        }
        return n3 & true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        int n = this.curve.getCount();
        if (this.closed) {
            ++n;
        }
        int n2 = this.curve.getCount();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        float[] fArray = new float[n * 2];
        int n3 = 0;
        while (n3 < n2) {
            Point3f point3f = this.curve.getPoint(n3);
            arrayList2.add(new Float(point3f.x));
            arrayList2.add(new Float(point3f.y));
            fArray[n3 * 2] = point3f.x;
            fArray[n3 * 2 + 1] = point3f.y;
            ++n3;
        }
        if (this.closed) {
            Point3f point3f = this.curve.getPoint(0);
            arrayList2.add(new Float(point3f.x));
            arrayList2.add(new Float(point3f.y));
            fArray[n2 * 2] = point3f.x;
            fArray[n2 * 2 + 1] = point3f.y;
        }
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setGraphicType(GraphicType.Interpolated);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n));
        graphicObject.setGraphicData(fArray);
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public Object clone() {
        CurveOverlay curveOverlay = null;
        try {
            curveOverlay = (CurveOverlay)super.clone();
            super.cloneReferences(curveOverlay);
            curveOverlay.curve = this.curve.clone();
            curveOverlay.samScr = new SamplingAdapterScreen(curveOverlay.curve);
            curveOverlay.samImg = new SamplingAdapterImage(curveOverlay.curve);
            curveOverlay.scrCenterX = this.scrCenterX;
            curveOverlay.scrCenterY = this.scrCenterY;
            int n = this.scrPointX.length;
            curveOverlay.scrPointX = new int[n];
            curveOverlay.scrPointY = new int[n];
            int n2 = 0;
            while (n2 < n) {
                curveOverlay.scrPointX[n2] = this.scrPointX[n2];
                curveOverlay.scrPointY[n2] = this.scrPointY[n2];
                ++n2;
            }
            curveOverlay.painter = new CurvePainter();
        }
        catch (Exception exception) {
            log.error("CurveOverlay", (Throwable)exception);
        }
        return curveOverlay;
    }

    @Override
    public double getMeasurementResult() {
        if (this.closed) {
            return this.samImg.getMMArea();
        }
        return this.samImg.getMMCircumference();
    }

    @Override
    public double[] getXCoordinates() {
        CurvePolyLine curvePolyLine = this.samImg.getImgPointsRef();
        int n = curvePolyLine.getCount();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = curvePolyLine.xPoint[n2];
            ++n2;
        }
        return dArray;
    }

    @Override
    public double[] getYCoordinates() {
        CurvePolyLine curvePolyLine = this.samImg.getImgPointsRef();
        int n = curvePolyLine.getCount();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = curvePolyLine.yPoint[n2];
            ++n2;
        }
        return dArray;
    }

    @Override
    public int getPointCount() {
        return this.samImg.getImgPointCount();
    }

    @Override
    public PresentationObject cloneAll() {
        CurveOverlay curveOverlay = (CurveOverlay)this.clone();
        curveOverlay.ir = new ImageRegion(curveOverlay);
        return curveOverlay;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        CurveOverlay curveOverlay = (CurveOverlay)iTransformableOverlay;
        double[] dArray = new double[2];
        int n = 0;
        while (n < curveOverlay.curve.getCount()) {
            Point3f point3f = curveOverlay.curve.getPoint(n);
            dArray[0] = point3f.x;
            dArray[1] = point3f.y;
            dArray = iOverlayPointModifier.convert(dArray);
            this.curve.setPoint(n, (float)dArray[0], (float)dArray[1], 0.0f);
            ++n;
        }
    }

    protected void createBoundingShape() {
        this.toScreen();
        Polygon polygon = this.painter.createBoundingShape(this.isSolid());
        this.outBounds = Collections.singletonList(polygon);
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            return super.inBounds(n, n2);
        }
        return bl;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }

    public SamplingAdapterImage getSamplingAdapterImage() {
        return this.samImg;
    }
}

