/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.curve;

import com.tiani.jvision.overlay.curve.ICurve;
import com.tiani.jvision.overlay.curve.ICurveListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3f;

abstract class AbstractCurve
implements ICurve {
    final List<Point3f> controlPoints;
    private final List<ICurveListener> listeners;
    private boolean isClosed;
    private long modificationCount;

    public AbstractCurve() {
        this(new ArrayList<Point3f>());
    }

    public AbstractCurve(List<Point3f> list) {
        this.controlPoints = list;
        this.listeners = new ArrayList<ICurveListener>(2);
    }

    public AbstractCurve(AbstractCurve abstractCurve) {
        this.controlPoints = new ArrayList<Point3f>();
        for (Point3f point3f : abstractCurve.controlPoints) {
            this.controlPoints.add(new Point3f(point3f));
        }
        this.listeners = new ArrayList<ICurveListener>(abstractCurve.listeners);
        this.isClosed = abstractCurve.isClosed;
    }

    @Override
    public long getModificationCount() {
        return this.modificationCount;
    }

    private void onModification() {
        ++this.modificationCount;
        for (ICurveListener iCurveListener : this.listeners) {
            iCurveListener.onCurveModification();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.controlPoints.isEmpty();
    }

    @Override
    public void addPoint(float f, float f2, float f3) {
        Point3f point3f = new Point3f(f, f2, f3);
        this.controlPoints.add(point3f);
        ++this.modificationCount;
        for (ICurveListener iCurveListener : this.listeners) {
            iCurveListener.onCurvePointAdd(point3f);
        }
    }

    @Override
    public void removePoint(int n) {
        this.controlPoints.remove(n);
        this.onModification();
    }

    @Override
    public void removeLastPoint() {
        if (!this.isEmpty()) {
            this.removePoint(this.controlPoints.size() - 1);
        }
    }

    @Override
    public void setPoint(int n, float f, float f2, float f3) {
        Point3f point3f = this.getPoint(n);
        point3f.x = f;
        point3f.y = f2;
        point3f.z = f3;
        ++this.modificationCount;
        for (ICurveListener iCurveListener : this.listeners) {
            iCurveListener.onCurvePointSet(point3f);
        }
    }

    @Override
    public void movePoints(float f, float f2, float f3) {
        for (Point3f point3f : this.controlPoints) {
            point3f.x += f;
            point3f.y += f2;
            point3f.z += f3;
        }
        this.onModification();
    }

    @Override
    public Iterator<Point3f> iterator() {
        return this.controlPoints.iterator();
    }

    @Override
    public Point3f getPoint(int n) {
        return this.controlPoints.get(n);
    }

    @Override
    public int getCount() {
        return this.controlPoints.size();
    }

    @Override
    public void setClosed(boolean bl) {
        this.isClosed = bl;
        this.onModification();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void addListener(ICurveListener iCurveListener) {
        this.listeners.add(iCurveListener);
    }

    @Override
    public void removeListener(ICurveListener iCurveListener) {
        this.listeners.remove(iCurveListener);
    }

    @Override
    public abstract ICurve clone();

    @Override
    public void cleanUp() {
        this.controlPoints.clear();
        this.listeners.clear();
    }
}

